// <summary>ソースコード：送信するセル型情報を管理するクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>送信するセル型情報を管理するクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>接続線毎に管理する</para>
    /// </remarks>
    public interface McSendCellDataIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySID csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetID();

        //==========================================
        //  送信時に必要な処理
        //==========================================
        /// <summary><para>method outline:</para>
        /// <para>送信時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCurrentTime(csTime) </para>
        /// </example>
        /// <param name="csTime">送信時刻</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>設定した時刻の情報を設定する</para>
        /// </remarks>
        void SetCurrentTime(HySTime csTime);

        /// <summary><para>method outline:</para>
        /// <para>送信すべきセルを準備（１次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendCellD1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] これから送信するセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたセルに送信すべき情報をセットする </para>
        /// </remarks>
        HySCellData[] PrepareSendCellD1();
        /// <summary><para>method outline:</para>
        /// <para>送信すべきセルを準備（２次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendCellD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,] これから送信するセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたセルに送信すべき情報をセットする </para>
        /// </remarks>
        HySCellData[,] PrepareSendCellD2();
        /// <summary><para>method outline:</para>
        /// <para>送信すべきセルを準備（３次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendCellD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[,,] これから送信するセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたセルに送信すべき情報をセットする </para>
        /// </remarks>
        HySCellData[, ,] PrepareSendCellD3();



        /// <summary><para>method outline:</para>
        /// <para>設定した情報を実際に送信する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 
        /// SetCurrentTime( SendTime ); 送信時刻設定
        /// HySCellData[ .. ]  csDt = PrepareSendCellDx()
        /// csDt[ .. ].m_dData[x] = 送信情報設定
        /// SendData()  実際に送信する
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列データの場合にはその値が設定されるが、定常データの場合にはデータを設定した時点で他のモデルからは参照出来る</para>
        /// </remarks>
        void SendData(); 

        //==========================================
        //  プロパティ画面にて各種設定する情報
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>伝送情報パターンプロパティ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfo(csPattern) </para>
        /// </example>
        /// <param name="csPattern">伝送情報パターンプロパティ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranInfoPattern(McTranInfoPatternPropertyIF csPattern);
        /// <summary><para>method outline:</para>
        /// <para>伝送情報パターンプロパティ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPattern = GetTranInfoPattern( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>McTranInfoPatternPropertyIF 伝送情報パターンプロパティ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF GetTranInfoPattern();
        /// <summary><para>method outline:</para>
        /// <para>送信パターン識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetSendPatternID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>送信パターン識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetSendPatternID();

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData) </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別管理データ</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellIDMngData(HySCellIDManageData csCellIDMngData);

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システム側で使用。モデルからの使用は禁止</para>
        /// </remarks>
        void SetDim(long lDim1);
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システム側で使用。モデルからの使用は禁止</para>
        /// </remarks>
        void SetDim(long lDim1, long lDim2);
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システム側で使用。モデルからの使用は禁止</para>
        /// </remarks>
        void SetDim(long lDim1, long lDim2, long lDim3);

        //==========================================
        //  モデル構築時に使用するメソッド
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySCellIDManageData GetCellIDMngData();

        /// <summary><para>method outline:</para>
        /// <para>伝送データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranInfo(csTranInfo) </para>
        /// </example>
        /// <param name="csTranInfo">伝送データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranInfo(McTranInfo csTranInfo);
        /// <summary><para>method outline:</para>
        /// <para>伝送データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = GetTranInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>csTranInfo 伝送データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfo GetTranInfo();

        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <param name="lDataDimInCell">セル内変数の数</param>
        /// <returns>long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3, ref long lDataDimInCell);

        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf, csElmID, csElmKind )</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="csElmID">モデルＩＤ</param>
        /// <param name="csElmKind">モデル種別</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, HySID csElmID, HySObjectKind csElmKind);

        /// <summary><para>method outline:</para>
        /// <para>伝送データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetTranInfoKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 伝送データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetTranInfoKind();
        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csDt = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McSendCellDataIF Clone();

        //===========================================
        // その他
        //===========================================

        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        HySString GetConnectionName();
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        HySID GetLowerElementID();

        //==========================================
        //  ＧＩＳ関連：各種情報設定／取得
        //==========================================
        /*
        /// <summary><para>method outline:</para>
        /// <para>送信すべきＧＩＳパターンを準備（１次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendGISPatternD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long[] これから送信するＧＩＳパターン配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたＧＩＳパターンに送信すべき情報をセットする </para>
        /// </remarks>
        long[] PrepareSendGISPatternD1();
        */
        /// <summary><para>method outline:</para>
        /// <para>送信すべきＧＩＳパターンを準備（２次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendGISPatternD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long[,] これから送信するＧＩＳパターン配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたＧＩＳパターンに送信すべき情報をセットする （将来用：特殊用途）</para>
        /// </remarks>
        long[,] PrepareSendGISPatternD2();
        /// <summary><para>method outline:</para>
        /// <para>送信すべきＧＩＳパターンを準備（３次元セル）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PrepareSendGISPatternD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> long[,,] これから送信するＧＩＳパターン配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>　此処で準備されたＧＩＳパターンに送信すべき情報をセットする （将来用：特殊用途） </para>
        /// </remarks>
        long[, ,] PrepareSendGISPatternD3();
        // 将来拡張用
        ///// <summary><para>method outline:</para>
        ///// <para>距離配列の設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetCellDistance(dDistance)</para> 
        ///// </example>
        ///// <param name="dDistance">double[] 最初のセル始点からの距離配列</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void SetCellDistance(double[] dDistance);
        ///// <summary><para>method outline:</para>
        ///// <para>セル始点・終点緯度情報配列の設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetCellLatitude(dCellLat)</para> 
        ///// </example>
        ///// <param name="dCellLat">double[] セルの始点／終点の緯度情報配列</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void SetCellLatitude(double[] dCellLat);
        ///// <summary><para>method outline:</para>
        ///// <para>セル始点・終点経度情報配列の設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetCellLongitude(dCellLon)</para> 
        ///// </example>
        ///// <param name="dCellLon">double[] セルの始点／終点の経度情報配列</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void SetCellLongitude(double[] dCellLon);
        ///// <summary><para>method outline:</para>
        ///// <para>代表点の緯度情報配列の設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetSpecificLatitude(dSpecificLat)</para> 
        ///// </example>
        ///// <param name="dSpecificLat">double[] 代表点の緯度情報配列</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void SetSpecificLatitude(double[] dSpecificLat);
        ///// <summary><para>method outline:</para>
        ///// <para>代表点の経度情報配列の設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetSpecificLongitude(dSpecificLon)</para> 
        ///// </example>
        ///// <param name="dSpecificLon">double[] 代表点の経度情報配列</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //void SetSpecificLongitude(double[] dSpecificLon);

        //==========================================
        //  ＧＩＳ関連：各種情報取得
        //==========================================
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lKind, ref lDim1, ref lDim2, ref lDim3, ref lDataDimInCell) </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lAltDim">高度方向のメッシュ分割数</param>
        /// <param name="lCellDataDim">１メッシュ内のデータ配列数</param>
        /// <returns>
        /// long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る。
        /// 　　　　　　　ＧＩＳ情報でない時には０が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetGISMeshDimension(ref HySGeoMesh.MESH_DATA_KIND lKind, ref long lLonDim, ref long lLatDim, ref long lAltDim, ref long lCellDataDim);
        /// <summary><para>method outline:</para>
        /// <para>地理的位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLocation(dSWLat, dSWLon, dNELat, dNELon) </para>
        /// </example>
        /// <param name="dSWLat">南西頂点緯度（度単位）</param>
        /// <param name="dSWLon">南西頂点経度（度単位）</param>
        /// <param name="dNELat">北東頂点緯度（度単位）</param>
        /// <param name="dNELon">北東頂点経度（度単位）</param> 
        /// <returns>=true:伝送データがＧＩＳデータの場合、=false:伝送データがＧＩＳ以外のデータの場合</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool SetLocation(double dSWLat, double dSWLon, double dNELat, double dNELon);
        /// <summary><para>method outline:</para>
        /// <para>地理的位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetLocation(ref dSWLat,ref dSWLon,ref dNELat,ref dNELon) </para>
        /// </example>
        /// <param name="dSWLat">南西頂点緯度（度単位）</param>
        /// <param name="dSWLon">南西頂点経度（度単位）</param>
        /// <param name="dNELat">北東頂点緯度（度単位）</param>
        /// <param name="dNELon">北東頂点経度（度単位）</param> 
        /// <returns>=true:伝送データがＧＩＳデータの場合、=false:伝送データがＧＩＳ以外のデータの場合</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool GetLocation(ref double dSWLat, ref double dSWLon, ref double dNELat, ref double dNELon);
        /// <summary><para>method outline:</para>
        /// <para>高度位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAltitude(dUpAlt, dLwAlt) </para>
        /// </example>
        /// <param name="dUpAlt">上限高度（ｍ単位）</param>
        /// <param name="dLwAlt">下限高度（ｍ単位）</param>
        /// <returns>=true:伝送データがＧＩＳデータの場合、=false:伝送データがＧＩＳ以外のデータの場合</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool SetAltitude(double dUpAlt, double dLwAlt);
        /// <summary><para>method outline:</para>
        /// <para>高度位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HGetAltitude(ref dUpAlt, ref dLwAlt) </para>
        /// </example>
        /// <param name="dUpAlt">上限高度（ｍ単位）</param>
        /// <param name="dLwAlt">下限高度（ｍ単位）</param>
        /// <returns>=true:伝送データがＧＩＳデータの場合、=false:伝送データがＧＩＳ以外のデータの場合</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool GetAltitude(ref double dUpAlt, ref double dLwAlt);
    }
}
