// <summary>ソースコード：伝送情報共通情報管理</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>セル型伝送情報共通情報管理</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    //[Serializable]
    public interface McTranCommonCellDataIF : HySDataRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionID( csCnnctID ) </para>
        /// </example>
        /// <param name="csCnnctID">接続線ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetConnectionID(HySID csCnnctID);
        /// <summary><para>method outline:</para>
        /// <para>接続線ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetConnectionID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 接続線ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線のＩＤを取得する</para>
        /// </remarks>
        HySID GetConnectionID();

        /// <summary><para>method outline:</para>
        /// <para>接続線名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionName( csCnnctName ) </para>
        /// </example>
        /// <param name="csCnnctName">接続線名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素複数の接続線で結ぶ場合等に使用</para>
        /// </remarks>
        void SetConnectionName(HySString csCnnctName);
        /// <summary><para>method outline:</para>
        /// <para>接続線名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetConnectionName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 接続線名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>要素を接続している接続線の名称を取得する</para>
        /// </remarks>
        HySString GetConnectionName();

        /// <summary><para>method outline:</para>
        /// <para>上流要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUpperElement( csElm ) </para>
        /// </example>
        /// <param name="csElm">要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素を設定する</para>
        /// </remarks>
        void SetUpperElement(McElement csElm);
        /// <summary><para>method outline:</para>
        /// <para>下流要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLowerElement( csElm ) </para>
        /// </example>
        /// <param name="csElm">要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された要素を設定する</para>
        /// </remarks>
        void SetLowerElement(McElement csElm);

        /// <summary><para>method outline:</para>
        /// <para>上流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetUpperElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素を取得する</para>
        /// </remarks>
        McElement GetUpperElement();
        /// <summary><para>method outline:</para>
        /// <para>下流要素取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetLowerElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McElement 要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された要素を取得する</para>
        /// </remarks>
        McElement GetLowerElement();
        /// <summary><para>method outline:</para>
        /// <para>上流要素名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csElmName = GetUpperElementName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 要素名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された要素名を取得する</para>
        /// </remarks>
        HySString GetUpperElementName();
        /// <summary><para>method outline:</para>
        /// <para>下流要素名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csElmName = GetLowerElementName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 要素名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に接続された要素名を取得する</para>
        /// </remarks>
        HySString GetLowerElementName();
        /// <summary><para>method outline:</para>
        /// <para>上流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>取得した要素が自分を更新している</para>
        /// </remarks>
        HySID GetUpperElementID();
        /// <summary><para>method outline:</para>
        /// <para>下流要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csElmID = GetUpperElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier 識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続先要素に対して情報を伝送する</para>
        /// </remarks>
        HySID GetLowerElementID();


        /// <summary><para>method outline:</para>
        /// <para>上流端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUpperPort( csElm ) </para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された端子を設定する</para>
        /// </remarks>
        void SetUpperPort(McPort csPort);
        /// <summary><para>method outline:</para>
        /// <para>下流端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLowerPort( csPort ) </para>
        /// </example>
        /// <param name="csPort">端子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された端子を設定する</para>
        /// </remarks>
        void SetLowerPort(McPort csPort);

        /// <summary><para>method outline:</para>
        /// <para>上流端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPort csPort = GetUpperPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPort 端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>上流に設定された端子を取得する</para>
        /// </remarks>
        McPort GetUpperPort();
        /// <summary><para>method outline:</para>
        /// <para>下流端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPort csPort = GetLowerPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPort 端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>下流に設定された端子を取得する</para>
        /// </remarks>
        McPort GetLowerPort();

        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDefine.InterpolateType GetInterpolateType();

        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McReceiveCellDataIF csRevDt = GetReceiveCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McReceiveCellDataIF 受信したセル型情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて受信情報本体をを取得する</para>
        /// </remarks>
        McReceiveCellDataIF GetReceiveCellData();
        /// <summary><para>method outline:</para>
        /// <para>受信したセル型情報取得クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateMcReceiveCellData(csPrptyInf); </para>
        /// </example>
        /// <param name="csPrptyInf">セル型伝送データプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>生成したインスタンスは自身のメンバー変数として保持</para>
        /// </remarks>
        void CreateMcReceiveCellData(McCellTranPropertyIF csPrptyInf);

        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csSndDt = GetSendCellData(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF 送信するセル型情報設定クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本クラスを通じて送信情報を設定する</para>
        /// </remarks>
        McSendCellDataIF GetSendCellData(); 
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報設定クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateSendCellData(csPrptyInf); </para>
        /// </example>
        /// <param name="csPrptyInf">セル型伝送データプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>生成したインスタンスは自身のメンバー変数として保持</para>
        /// </remarks>
        void CreateSendCellData(McCellTranPropertyIF csPrptyInf);

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara);

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csNewObj = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McTranInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranCommonCellDataIF Clone();

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool CopyInfo(McTranCommonCellDataIF csOrgInfo);
    }
}
