// <summary>ソースコード：伝送情報パターンプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.Interface.Data
{
    /// <summary><para>class outline:</para>
    /// <para>伝送情報パターンプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    public interface McTranInfoPatternPropertyIF : HySDataRoot
    {
        //=== 必須情報 ====
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPatternID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetPatternID(HySID csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetPatternID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID GetPatternID();

        /// <summary><para>method outline:</para>
        /// <para>データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTranDataKind(csDataKind) </para>
        /// </example>
        /// <param name="csDataKind">データ種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTranDataKind(HySObjectKind csDataKind);
        /// <summary><para>method outline:</para>
        /// <para>データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtKind = GetTranDataKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetTranDataKind();

        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell １セル内の各データの種別を示すクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataCharacteristicInCell GetCellDataCharacteristic();
        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChar); </para>
        /// </example>
        /// <param name="csCellChar">１セル内の各データの種別を示すクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChar);
        /// <summary><para>method outline:</para>
        /// <para>１セル内の各データの種別を示すクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = CreateCellDataCharacteristic(3);
        ///    csKind.SetTranDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="lDim">セル内変数の数</param>
        /// <returns>HySDataCharacteristicInCell １セル内の各データの種別を示すクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataCharacteristicInCell CreateCellDataCharacteristic(long lDim);

        /// <summary><para>method outline:</para>
        /// <para>内挿方式設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInterpolateType(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿方式</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信側のみ使用する</para>
        /// </remarks>
        void SetInterpolateType(HySDefine.InterpolateType eInterpolateType);
        /// <summary><para>method outline:</para>
        /// <para>内挿方式取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDefine.InterpolateType eInterpolateType = GetInterpolateType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDefine.InterpolateType  内挿方式</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信側のみ使用する</para>
        /// </remarks>
        HySDefine.InterpolateType GetInterpolateType();

        /// <summary><para>method outline:</para>
        /// <para>第１配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetDim(long lDim1);
        /// <summary><para>method outline:</para>
        /// <para>第２配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetDim(long lDim1, long lDim2);
        /// <summary><para>method outline:</para>
        /// <para>第３配列の数を設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDim(lDim1,lDim2,lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetDim(long lDim1, long lDim2, long lDim3);

        /// <summary><para>method outline:</para>
        /// <para>セルメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDimension(ref lDim1, ref lDim2, ref lDim3) </para>
        /// </example>
        /// <param name="lDim1">第１分割数</param>
        /// <param name="lDim2">第２分割数</param>
        /// <param name="lDim3">第３分割数</param>
        /// <param name="lDataDimInCell">セル内変数の数</param>
        /// <returns>long 次元数　1次元＝１、２次元＝２、３次元＝３が　返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long GetDimension(ref long lDim1, ref long lDim2, ref long lDim3, ref long lDataDimInCell);

        //=== 補足情報 ====
        /// <summary><para>method outline:</para>
        /// <para>名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetName( csName ) </para>
        /// </example>
        /// <param name="csName">名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        void SetName(HySString csName);
        /// <summary><para>method outline:</para>
        /// <para>名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetName( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        HySString GetName();
        /// <summary><para>method outline:</para>
        /// <para>ユーザー定義種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetKind(csKind) </para>
        /// </example>
        /// <param name="csKind">ユーザー定義種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetKind(HySObjectKind csKind);
        /// <summary><para>method outline:</para>
        /// <para>ユーザー定義種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtKind = GetKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind ユーザー定義種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySObjectKind GetKind();

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF csDt = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfoPatternPropertyIF Clone();

        /// <summary><para>method outline:</para>
        /// <para>パターン情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter);
        /// <summary><para>method outline:</para>
        /// <para>XMLからパターン情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool XmlIN(HySXmlNode csXml);
    }
}
