﻿// <summary>ソースコード：ライブラリ管理処理基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;

namespace CommonMP.HYMCO.Interface.LibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯライブラリ管理抽象クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>DBの種別に関係なく　ＨＹＭＣＯとしての　ライブラリ管理共通処理を入れる</para>
    /// </remarks>
    abstract public class McLibraryManager : HySBaseLibraryManager
    {
        /// <summary>ライブラリ管理表示情報データ</summary>
        protected HySDataRoot m_csData = null;

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override bool EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            HySEventObject csEventObj = (HySEventObject)csEvent;
            
            long lEventNo = csEventObj.GetEventNo();
            long lSubEventNo = csEventObj.GetSubEventNo();
            HySID csDBKind = csEventObj.GetSuppID();

            bool bEventAccepted = false;    // イベント受付フラグ

            if (lEventNo == HySEventObject.CMND_DB_QUERY)
            {   // 検索ならば
                if (lSubEventNo == McDefine.QUERY_LIBRARY_LIST)
                {   // ライブラリ一覧検索
                    bEventAccepted = true;
                    bRtn = SchLibrary(csEventObj);
                }
            }
            else if (lEventNo == HySEventObject.CMND_DB_COMMON)
            {   // 任意処理ならば
                bEventAccepted = true;
                bRtn = ArbJob(csEventObj);
            }

            // 本クラスでサポートしないイベントは基底クラスに転送する
            if (!bEventAccepted)
            {
                bRtn = base.EventCallback(csEventObj);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ表示用情報検索</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SchLibrary( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean SchLibrary(HySEventObject csEvent)
        {
            Boolean bRtn = false;
            //検索結果：m_csDispLibTreeDataを第２付加データにセットして返す
            HySID csSuppID = null;
            HySDataRoot csData = null;
            HySDataRoot csSubData = m_csData;
            bRtn = PutEvent(csEvent, HySEventObject.NOTICE_DB_OK, csEvent.GetSubEventNo(), csSuppID, csData, m_csData);
            if (bRtn == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McLibraryManager.SchLibrary",
                    Properties.HymcoIFResources.STATEMENT_SEND_FAILURE + "("+ Properties.HymcoIFResources.STATEMENT_SERCH + ")");
               // HySLog.LogOut(HySLog.ONLINE, "McLibraryManager.SchLibrary", "イベント送信失敗(検索)");
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>任意処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ArbJob( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>必要ならばオーバーライドする</para>
        /// </remarks>
        public virtual Boolean ArbJob(HySEventObject csEvent)
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "McLibraryManager::ArbJob", "Called");
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetData(csData)</para>
        /// </example>
        /// <param name="csData">データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetData(HySDataRoot csData)
        {
            m_csData = csData;
        }
    }
}
