﻿// <summary>ソースコード：ＨＹＭＣＯ定義情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYMCO.Interface
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]
    ///        S.H. [2022/01/21] 定義追加　</para>
    /// </remarks>
    public class McDefine
    {

        // ===========================
        // シミュレーター種別識別子関係
        // ===========================
        /// <summary>ＨＹＭＣＯシミュレーター種別識別子関係</summary>
        static public readonly HySObjectKind SIMULATOR_KIND = new HySObjectKind("HYMCO");

        // =======================================================================
        // ＨＹＭＣＯ全体システム関連識別子（HySCommonInfoHashへの設定エリア名称）
        // =======================================================================
        /// <summary>プロジェクトグループ名称キー</summary>
        static public readonly string PROJECT_GROUP_NAME = "HymcoProjectGoupName";
        /// <summary>計算ロット名称キー</summary>
        static public readonly string CALCULATION_LOT_NAME = "HymcoCalculationLot";
        /// <summary>共通エラー格納領域キー</summary>
        static public readonly string CALCULATION_ERROR_INF = "CalErrorInf";

        // =======================
        // ファクトリ識別子
        // =======================
        /// <summary>業務処理ファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_BUSIPROCEDURE = new HySID("HYMCO" + "Factory" + "BusiProc");
        /// <summary>シミュレーションファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_SIMULATION = new HySID("HYMCO" + "Factory" + "Simulator");
        /// <summary>ライブラリーマネージャーファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_LIBRARY_MNG = new HySID("HYMCO" + "Factory" + "LibraryManager");
        ///// <summary>GISファクトリー</summary>
        //static public readonly HySIdentifier FACTORY_ID_GIS = new HySID("SYSTEM"+ "Factory"+ "GIS"); <-- HYMCO 固有があるわけではない
        ///// <summary>ビューアファクトリー</summary>
        //static public readonly HySIdentifier FACTORY_ID_VIEWR = new HySID("SYSTEM"+ "Factory"+ "Viewer"); <-- HYMCO 固有があるわけではない
        /// <summary>画面ファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_SCREEN = new HySID("HYMCO" + "Factory" + "Screen");
        /// <summary>ビューア内処理ファクトリー</summary>
        static public readonly HySIdentifier FACTORY_ID_VIEWRJOB = new HySID("HYMCO" + "Factory" + "ViewerJob");

        /// <summary>ファクトリクリエータパッケージ名称</summary>
        static public readonly HySString HYMCO_FACTORY_CREATOR_PACKAGE_NAME = new HySString("CommonMP.HYMCO._SYSTEM_");
        /// <summary>モデルファクトリクリエータクラス名称</summary>
        static public readonly HySString HYMCO_MODEL_FACTORY_CREATOR_CLASS_NAME = new HySString("HYMCO_MODEL_FACTORY_CREATOR_IMPLE");
        /// <summary>スクリーンファクトリクリエータクラス名称</summary>
        static public readonly HySString HYMCO_SCREEN_FACTORY_CREATOR_CLASS_NAME = new HySString("HYMCO_SCREEN_FACTORY_CREATOR_IMPLE");

        /// <summary>プロパティ画面ファクトリーセット</summary>
        static public readonly HySIdentifier FACTORY_ID_PROPERTY_SCREEN_SET = new HySID("HYMCO" + "Factory" + "ScreenSet");
        /// <summary>要素モデルファクトリーセット</summary>
        static public readonly HySIdentifier FACTORY_ID_MODEL_SET = new  HySID("HYMCO" + ".CoreImpl.Model." + "McModelFactorySet");

        // Ver1.1 追加 >>>
        // =================================
        // プロジェクトデータ変換用処理関連
        // （DBエクスポートデータ→プロジェクトグループデータ変換用）
        // =================================
        /// <summary>プロジェクトデータ変換用業務</summary>
        static public readonly HySKind SUB_DBCNV_BUSIPROCEDURE = new HySObjectKind("DBCnvBusiProcedure");
        /// <summary>業務処理ファクトリー(プロジェクトデータ変換用)</summary>
        static public readonly HySIdentifier FACTORY_ID_DBCNV_BUSIPROCEDURE = new HySID("DBCnv" + "Factory" + "BusiProc");
        // Ver1.1 追加 <<<

        // =======================
        // データ識別子
        // =======================
        /// <summary>モデル接続構造体</summary>
        static public readonly HySString HYM_DATA_STRUCT_INFO = new HySString("McStructInfo");
        /// <summary>プロジェクト情報</summary>
        static public readonly HySString HYM_DATA_PROJECT_INFO = new HySString("McProjectInfo");
        /// <summary>演算モデルチェック結果情報</summary>
        static public readonly HySString HYM_DATA_CHECK_INFO = new HySString("McCheckInfo");
        /// <summary>演算ログ情報</summary>
        static public readonly HySString HYM_DATA_LOG_INFO = new HySString("McModelLogData");
        /// <summary>シミュレーション進行状況保存</summary>
        static public readonly HySString HYM_DATA_SIMULATION_INFO = new HySString("McSimulationStatus");

        /// <summary>演算時刻データ</summary>
        static public readonly HySString SIMULATION_TIME = new HySString("SimulationTime");
        /// <summary>開始時刻データ</summary>
        static public readonly HySString START_TIME = new HySString("StartTime");
        /// <summary>演算経過時刻データ</summary>
        static public readonly HySString PASSING_TIME = new HySString("TotalPassingTime");
        /// <summary>目標時刻データ</summary>
        static public readonly HySString TARGET_TIME = new HySString("TargetTime");
        /// <summary>刻み時間データ</summary>
        static public readonly HySString DELTA_TIME = new HySString("DeltaTime");

        /// <summary>送信伝送データ</summary>
        static public readonly HySString SEND_INFO = new HySString("SendInfo");
        /// <summary>受信伝送データ</summary>
        static public readonly HySString RECEIVE_INFO = new HySString("ReceiveInfo");

        // =======================
        // 画面識別子関係
        // =======================
        /// <summary>ＨＹＭＣＯプロジェクト管理画面識別子</summary>
        static public readonly String PROJECTSCREEN_ID = "Project";
        /// <summary>ＨＹＭＣＯライブラリ管理画面識別子</summary>
        static public readonly String LIBRARYSCREEN_ID = "Library";
        /// <summary>ＨＹＭＣＯ演算単位系共通識別子</summary>
        static public readonly String FIGUREUNITY_COMMON_ID = "FigureUnity";

        /// <summary>プロジェクト管理画面</summary>
        static public readonly HySKind HYM_PROJECTCTL_SCREEN = new HySObjectKind("HYMCO.Screen.Project");
        /// <summary>ライブラリ管理画面</summary>
        static public readonly HySKind HYM_LIBRARYCTL_SCREEN = new HySObjectKind("HYMCO.Screen.Library");
        /// <summary>モデル管理画面</summary>
        static public readonly HySKind HYM_MODELCTL_SCREEN = new HySObjectKind("HYMCO.Screen.Model");
        /// <summary>パラメータ設定画面</summary>
        static public readonly HySKind HYM_MODELPROPERTY_SCREEN = new HySObjectKind("HYMCO.Screen.ModelProperty");


        //// <summary>モデルデータジェネレーター制御設定画面</summary>
        //static public readonly HySKind HYM_MDL_DATA_GENERATOR_CTL_SCREEN = new HySObjectKind("HYMCO.Screen.ModelDataGeneratorCtl");
        /// <summary>ＨＹＭＣＯ演算単位系共通識別子</summary>
        static public readonly String HYM_MDL_DATA_GENERATOR_CTL_SCREEN_ID = "HYMCO.ModelDataGeneratorCtl";
        /// <summary>ＨＹＭＣＯ演算単位系共通識別子</summary>
        static public readonly String HYM_WRAPPER_MODELINFO_EDIT_CTL_SCREEN_ID = "HYMCO.WrapperModelInfoEditCtl";

        // =======================
        // データ型式定義
        // =======================
        /// <summary>データ型式定義</summary>
        public enum ValKind
        {
            /// <summary>bool 型</summary>
            BOOL = 1,
            /// <summary>long 型</summary>
            LONG,
            /// <summary>double 型</summary>
            DOUBLE,
            /// <summary>string 型</summary>
            STRING,
            /// <summary> enum 型 </summary>
            ENUM
            ///// <summary>McDim1DataTranInfo 型</summary>
            //DIM1_DATA,
            ///// <summary>McDim2DataTranInfo 型</summary>
            //DIM2_DATA,
            ///// <summary>McDim3DataTranInfo 型</summary>
            //DIM3_DATA,
            ///// <summary>McMultiSerialTranInfo 型</summary>
            //MULTI_SERIAL_DATA
        }

        // =======================
        // モデルタイプ定義
        // =======================
        /// <summary>標準モデル</summary>
        static public readonly HySObjectKind MODEL_TYPE_STANDARD = new HySObjectKind("Standard");
        /// <summary>グループモデル</summary>
        static public readonly HySObjectKind MODEL_TYPE_GROUP = new HySObjectKind("Group");
        /// <summary>収束演算系グループ内要素モデル（将来用？）</summary>
        static public readonly HySObjectKind MODEL_TYPE_GROUP_ELEMENT = new HySObjectKind("GroupElement");

        // =======================
        // 陽解法／陰解法　タイプ定義
        // =======================
        /// <summary> 解法定義 </summary>
        public enum SolutionType
        { 
            /// <summary>一般的解法</summary>
            NORMAL_TYPE=1,
            /// <summary>収束演算による解法</summary>
            CONVERGENCE_TYPE 
        }

        // =======================
        // 収束演算時の　復帰範囲
        // =======================
        /// <summary> 要素の記憶範囲 </summary>
        public enum ElementMemoryLevel
        {
            /// <summary> 収束演算の要素内情報メモリ範囲：　全て記憶 </summary>
            ELEMENT_MEMORY_ALL =1,
            /// <summary> 収束演算の要素内情報メモリ範囲：　出力情報のみ記憶 </summary>
            ELEMENT_MEMORY_SNDPORT_ONLY 
        }

        // =======================
        // DataFusionのタイミング 同期／非同期
        // =======================
        /// <summary> 要素の記憶範囲 </summary>
        public enum DataFusionTiming
        {
            /// <summary> 同期 </summary>
            SYNCHRONOUS = 1,
            /// <summary> 非同期 </summary>
            ASYNCHRONOUS 
        }



        // =======================
        // Enum定義
        // =======================

        /// <summary>描画モード種別</summary>
        public enum DrawModeKind
        {
            /// <summary>作画モード</summary>
            HYM_DRAW = 1,
            /// <summary>作画モード要素追加</summary>
            HYM_DRAW_ADD_ELEMENT,
            /// <summary>作画連続モード</summary>
            HYM_DRAW_CONTINU,
            /// <summary>作画モード接続線</summary>
            HYM_DRAW_LINE,
            /// <summary>作画連続モード接続線</summary>
            HYM_DRAW_LINE_CONTINU,
            /// <summary>作画モード接続線送信側選択</summary>
            HYM_DRAW_LINE_FROM_SELECT,
            /// <summary>作画モード接続線受信側選択</summary>
            HYM_DRAW_LINE_TO_SELECT,
            /// <summary>選択モード</summary>
            HYM_SELECT,
            /// <summary>選択モード（画面エレメント選択）</summary>
            HYM_SELECT_ELEMENT,
            /// <summary>コピーモード</summary>
            HYM_COPY,
            /// <summary>切り取りモード</summary>
            HYM_CUT,
            /// <summary>貼り付けモード</summary>
            HYM_PASTE,
            /// <summary>貼り付けモード要素追加</summary>
            HYM_PASTE_ADD_ELEMENT,
            /// <summary>貼り付け連続モード</summary>
            HYM_PASTE_CONTINU,
            /// <summary> 削除モード</summary>
            HYM_DELETE,
            /// <summary>回転モード</summary>
            HYM_ROTATE,
            /// <summary>全回転モード</summary>
            HYM_ALLROTATE,
            /// <summary>モデルチェック中</summary>
            HYM_MODEL_CHECK,
            /// <summary>プロパティリスト編集中</summary>
            HYM_PROPETY_LIST_EDIT,
            /// <summary>表示位置スクロールモード</summary>
            HYM_DISPLAY_POSITION_SCROLL,
            /// <summary>ツールバー編集中</summary>
            HYM_TOOLBAR_EDIT,
            /// <summary>未指定</summary>
            HYM_NonMode
        }

        /// <summary>シンボル描画種別</summary>
        public enum SymbolDrawKind
        {
            /// <summary>要素シンボル</summary>
            HYM_STD_ELEMENT = 1,
            /// <summary>部分系グループシンボル</summary>
            HYM_GROUP,
            /// <summary>収束演算系グループシンボル</summary>
            HYM_CALC_GROUP,
            /// <summary>受信端子シンボル</summary>
            HYM_RECEIVE,
            /// <summary>送信端子シンボル</summary>
            HYM_SEND,
            /// <summary>流入中継端子シンボル（外部からサブシステムへ流入する）</summary>
            HYM_TRANS_IN,
            /// <summary>流出中継端子シンボル（サブシステムから外部へ流出する）</summary>
            HYM_TRANS_OUT,
            /// <summary>接続線シンボル</summary>
            HYM_LINE,
            /// <summary>未指定</summary>
            HYM_NonSymbol
        }

        /// <summary>メッセージレベル</summary>
        public enum MessageLevel
        {
            /// <summary>レベル無し</summary>
            HYM_NON_LEVEL = 1,
            /// <summary>モデルチェック(Warning)</summary>
            HYM_MODELCHECK_WARNING,
            /// <summary>モデルチェック(Error)</summary>
            HYM_MODELCHECK_ERROR,
            /// <summary>モデルチェック(Information)</summary>
            HYM_MODELCHECK_INFORMATION,
            /// <summary>演算系エラー</summary>
            HYM_SIMULATION_ERROR,
            /// <summary>演算系２</summary>
            HYM_SIMULATION_2,
            /// <summary>演算系３</summary>
            HYM_SIMULATION_3
        }

        /// <summary>レイヤー区分</summary>
        public enum LayerKind
        {
            /// <summary>要素レイヤー</summary>
            ELEMENT = 1,
            /// <summary>端子レイヤー</summary>
            PORT = 2,
            /// <summary>接続線レイヤー</summary>
            LINE = 4,
            /// <summary>IDレイヤー</summary>
            ID = 8,
            /// <summary>名称レイヤー</summary>
            NAME = 16,
            /// <summary>要素セレクトレイヤー</summary>
            ELEMENT_SELECT = 32,
            /// <summary>端子セレクトレイヤー</summary>
            PORT_SELECT = 64,
            /// <summary>接続線セレクトレイヤー</summary>
            LINE_SELECT = 128,
            /// <summary>ラバーバンドレイヤー</summary>
            RUBBER_BAND = 256,
            /// <summary>スライド用移動レイヤー</summary>
            MOVE = 512,
            /// <summary>スライド用移動テンポラリレイヤー</summary>
            MOVE_TEMP = 1024,
            /// <summary>指定なし</summary>
            NONE = 2048
        }


        //// ===============================
        //// シンボル描画情報定義
        //// ===============================
        ///// <summary>ライン描画幅</summary>
        //static public readonly float HYM_DRAW_LINE_WIDTH = 2.0F;


        // ===============================
        // シンボル描画サブ種別定義
        // ===============================
        /// <summary>流域シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_BASIN = new HySObjectKind("Basin");
        /// <summary>河道シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_LANE = new HySObjectKind("Lane");
        /// <summary>ユーザーシンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_USER = new HySObjectKind("Arbitrary");
        /// <summary>入力シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_INPUT = new HySObjectKind("Input");
        /// <summary>出力シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_OUTPUT = new HySObjectKind("Output");
        /// <summary>シンボル未指定</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_NONSYMBOL = new HySObjectKind("");
        /// <summary>サブシステム部分系シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_SUBSYSTEM = new HySObjectKind("SubSystem");
        /// <summary>収束演算シンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_CONVERGENCE = new HySObjectKind("Convergence");
        /// <summary>マージモデルシンボル</summary>
        static public readonly HySObjectKind HYM_DRAW_SUB_KIND_DATA_MERGE = new HySObjectKind("DataMerge");


        // ===============================
        // その他定義
        // ===============================
        /// <summary>ダミーエレメント</summary>
        static public readonly HySID STRUCT_DMY_ELM = new HySID("dmy" + "Elm" + "");
        /// <summary> デフォルト時刻 </summary>
        static public readonly HySTime DEFAULT_TIME = new HySTime(-20000 * 365, 0, 0, 0);


        // ===================================================
        // HYMCO 構成要素種別識別名 (HYMCO.dicon 内で使用)
        // ===================================================
        /// <summary>モデル</summary>
        static public readonly String HYMCO_DICN_MODEL = "Model";
        /// <summary>プロパティ設定画面</summary>
        static public readonly String HYMCO_DICN_PROPERTY_SCREEN = "PropertyScreen";
        /// <summary>画面</summary>
        static public readonly String HYMCO_DICN_SCREEN = "Screen";

        // =======================
        // 構造定義ファイル　XMLタグ定義
        // =======================

        // === ルート ===
        /// <summary> プロジェクトXMLタグ　 </summary>
        static public readonly string xml_PROJECT = "HymcoProject";
        /// <summary> プロジェクトグループ名 XMLタグ　 </summary>
        static public readonly string xml_PROJECT_GROUP = "ProjectGroup";

        /// <summary> 構造定義ファイル本体　XMLタグ　CalElement </summary>
        static public readonly string xml_MAINSYSTEM = "MainSystem";
        /// <summary> プロパティXMLタグ　 </summary>
        static public readonly string xml_PROPERTY_ROOT = "PropertyRoot";
        /// <summary> 初期化XMLタグ　 </summary>
        static public readonly string xml_INITIAL_ROOT = "InitialRoot";

        /// <summary> プロパティXMLファイル名　属性　 </summary>
        static public readonly string xml_PROPERTY_FILE = "PropertyFileName";
        /// <summary> 初期化XMLファイル名　属性　 </summary>
        static public readonly string xml_INITIAL_FILE = "InitialFileName";

        // === 要素 ===
        /// <summary> XMLタグ　CalElement SymbolDrawKind.HYM_STD_ELEMENTに対応 </summary>
        static public readonly string xml_CALELEMENT = "CalElement";
        /// <summary> XMLタグ　Subsystem SymbolDrawKind.HYM_GROUPに対応 </summary>
        static public readonly string xml_SUBSYSTEM = "Subsystem";
        /// <summary> XMLタグ　Convergence(収束演算) SymbolDrawKind.HYM_CALC_GROUPに対応</summary>
        static public readonly string xml_CONVERGENCE = "Convergence";
        // === 端子 ===
        /// <summary> XMLタグ　CalElement(入力端子) SymbolDrawKind.HYM_INPUTに対応 </summary>
        static public readonly string xml_INPUT_PORT = "InputPort";
        /// <summary> XMLタグ　CalElement(出力端子) SymbolDrawKind.HYM_OUTPUTに対応 </summary>
        static public readonly string xml_OUTPUT_PORT = "OutputPort";
        /// <summary> XMLタグ　CalElement（(受信端子) SymbolDrawKind.HYM_RECEIVEに対応 </summary>
        static public readonly string xml_RECEIVE_PORT = "ReceivePort";
        /// <summary> XMLタグ　CalElement(送信端子) SymbolDrawKind.HYM_SENDに対応 </summary>
        static public readonly string xml_SEND_PORT = "SendPort";
        /// <summary> XMLタグ　CalElement(流入中継端子) SymbolDrawKind.HYM_TRANS_INに対応 </summary>
        static public readonly string xml_RECEIVE_TERMINAL = "ReceiveTerminal";
        /// <summary> XMLタグ　CalElement(流出中継端子) SymbolDrawKind.HYM_TRANS_OUTに対応 </summary>
        static public readonly string xml_SEND_TERMINAL = "SendTerminal";
        // === 接続 ===
        /// <summary> XMLタグ　Convergence(接続) SymbolDrawKind.HYM_LINEに対応</summary>
        static public readonly string xml_CONNECTION = "Connection";

        // === 共通構成要素 ===
        /// <summary> XMLタグ　Property </summary>
        static public readonly string xml_PROPERTY = "Property";
        /// <summary> XMLタグ　InitialSet </summary>
        static public readonly string xml_INITIAL_SET = "InitialSet";
        /// <summary> XML属性　ID </summary>
        static public readonly string xml_ID = "ID";
        /// <summary> XML属性　FactoryID </summary>
        static public readonly string xml_FACTORYID = "FactoryID";
        // === サブシステム構成要素 ===
        /// <summary> XMLタグ　Wiring </summary>
        static public readonly string xml_COMPONENT = "Components";
        /// <summary> XMLタグ　Wiring </summary>
        static public readonly string xml_WIRRING = "Wiring";
        /// <summary> XMLタグ　From </summary>
        static public readonly string xml_FROM = "From";
        /// <summary> XMLタグ　To </summary>
        static public readonly string xml_TO = "To";
        // === エレメント構成要素 ===
        /// <summary> XML属性　Kind </summary>
        static public readonly string xml_KIND = "ShapeKind";
        /// <summary> XML属性　Model </summary>
        static public readonly string xml_MODEL = "Model";
        /// <summary> XML属性　X </summary>
        static public readonly string xml_X = "X";
        /// <summary> XML属性　Y </summary>
        static public readonly string xml_Y = "Y";
        /// <summary> XML属性　Rotation </summary>
        static public readonly string xml_ROTATION = "Rotation";
        /// <summary> XML属性　Width </summary>
        static public readonly string xml_Width = "Width";
        /// <summary> XML属性　Height </summary>
        static public readonly string xml_Height = "Height";
        /// <summary> XML属性　ElementName </summary>
        static public readonly string xml_ElementName = "ElementName";
        /// <summary> XMLタグ　Port </summary>
        static public readonly string xml_PORT = "Ports";
        // === 接続構成要素 ===
        /// <summary> XML属性　Model </summary>
        static public readonly string xml_TRANINFO = "TranInfo";
        // === 端子構成要素 ===
        /// <summary> XML属性　Direction </summary>
        static public readonly string xml_DIRECTION = "Direction";
        /// <summary> XML属性　InnerX </summary>
        static public readonly string xml_InnerX = "InnerX";
        /// <summary> XML属性　InnerY </summary>
        static public readonly string xml_InnerY = "InnerY";

        // === モデル情報
        /// <summary> XMLタグ　ModelList </summary>
        static public readonly string xml_MODELLIST = "ModelList";
        /// <summary> XMLタグ　CalModel </summary>
        static public readonly string xml_CALMODEL = "CalModel";
        //// <summary> XMLタグ　Property </summary>
        //static public readonly string xml_MODELPROPERTY = "Property";

        /// <summary> XMLタグ　Supplemental </summary>
        static public readonly string xml_SUPPLEMENTAL = "Supplemental";
        
        /// <summary> XMLタグ　Variable </summary>
        static public readonly string xml_VARIABLE = "Variable";
        /// <summary> XML属性　Key </summary>
        static public readonly string xml_KEY = "Key";
        /// <summary> XML属性　Name </summary>
        static public readonly string xml_NAME = "Name";
        /// <summary> XML属性　DataType </summary>
        static public readonly string xml_DATATYPE = "DataType";
        /// <summary> XML属性　Value </summary>
        static public readonly string xml_VALUE = "Value";

        /// <summary> XML属性　Kind </summary>
        static public readonly string xml_MODELKIND = "Kind";
        /// <summary> XML属性　FactoryID </summary>
        static public readonly string xml_MODELFACTORYID = "FactoryID";
        /// <summary> XML属性　Classification </summary>
        static public readonly string xml_DIVISION = "Division";
        /// <summary> XML属性　Classification </summary>
        static public readonly string xml_CLASSIFICATION = "Classification";
        /// <summary> XML属性　Creator </summary>
        static public readonly string xml_CREATOR = "Creator";
        /// <summary> XML属性　Version </summary>
        static public readonly string xml_VERSION = "Version";
        /// <summary> XML属性　Summary </summary>
        static public readonly string xml_SUMMARY = "Summary";
        /// <summary> XML属性　ModelType </summary>
        static public readonly string xml_MODELTYPE = "ModelType";
        /// <summary> XML属性　InterpolateType </summary>
        static public readonly string xml_INTERPOLATETYPE = "InterpolateType";

        /// <summary> XML属性 セル型データの取得クラス管理情報</summary>
        static public readonly string xml_CELL_DATA_GETTER_MANAGER = "CellDataGetterManager";
        /// <summary> XMLタグ　接続：送信要素側の送信パターン </summary>
        static public readonly string xml_SEND_ELM_PATTERN = "SendElementOutPattern";
        /// <summary> XMLタグ　接続：受信要素側の受信パターン </summary>
        static public readonly string xml_RECV_ELM_PATTERN = "ReceiveElementInPattern";
        /// <summary> XML属性　送受信設定パターンＩＤ：PatternID </summary>
        static public readonly string xml_PATTERN_ID = "PatternID";


        // === 演算制御情報
        /// <summary> XML属性　DataFusionTiming </summary>
        static public readonly string xml_DATAFUSIONTIMING = "DataFusionTiming";
        /// <summary> XML属性　DisbandLock </summary>
        static public readonly string xml_DISBANDLOCK = "DisbandLock";
        /// <summary> XML属性　TimeStep </summary>
        static public readonly string xml_TIMESTEP = "TimeStep";

        // === 伝送セル内識別とモデルセルの対応関連
        /// <summary> XMLタグ　接続：送信要素内セル識別情報管理データ格納ファイル名 </summary>
        static public readonly string xml_CELL_ID_MNG_FILE = "CellIDMngFile";
        /// <summary> XMLタグ　伝送セル識別情報対応表 </summary>
        static public readonly string xml_TRAN_CELL_MANAGE_TABLE = "CellManageTable";
        /// <summary> XMLタグ　伝送セル </summary>
        static public readonly string xml_TRAN_CELL = "TranCell";
        /// <summary> XMLタグ　接続上位モデルセル情報 </summary>
        static public readonly string xml_UPPER_MODEL_CELL = "UpperModelCell";
        /// <summary> XMLタグ　接続下位モデルセル情報 </summary>
        static public readonly string xml_LOWER_MODEL_CELL = "LowerModelCell";
        /// <summary> XML属性　伝送セルＩＤ </summary>
        static public readonly string xml_TRAN_CELL_ID = "TranID";
        /// <summary> XML属性　伝送セル種別 </summary>
        static public readonly string xml_TRAN_CELL_KIND = "TranKind";
        /// <summary> XML属性　セル配列位置第１次元 </summary>
        static public readonly string xml_CELL_DIM1 = "IdxD1";
        /// <summary> XML属性  セル配列位置第２次元 </summary>
        static public readonly string xml_CELL_DIM2 = "IdxD2";
        /// <summary> XML属性  セル配列位置第３次元 </summary>
        static public readonly string xml_CELL_DIM3 = "IdxD3";
        /// <summary> XML属性  ファイル名称 </summary>
        static public readonly string xml_FILE_NAME = "FileName";
        //------------ start of add 2022/01/21 S.H. --------------
        /// <summary> XMLタグ　接続上位モデルセル情報 </summary>
        static public readonly string xml_UPSTREAM = "UpstreamPrpty";
        /// <summary> XMLタグ　接続下位モデルセル情報 </summary>
        static public readonly string xml_DOWNSTREAM = "DownstreamPrpty";
        /// <summary> XMLタグ　接続上位モデルセル情報 </summary>
        static public readonly string xml_UP_ELEM = "UpperElementPrpty";
        /// <summary> XMLタグ　接続下位モデルセル情報 </summary>
        static public readonly string xml_DOWN_ELEM = "LowerElementPrpty";
        //------------ end of add 2022/01/21 S.H. --------------

        // プロジェクトファイル .XML 用
        /// <summary>XMLタグ　構造定義ファイル </summary>
        static public readonly string xml_PRJCT_SCF = "SCFile";
        /// <summary>XML属性　構造定義ファイル名 </summary>
        static public readonly string xml_PRJCT_SCF_NAME = "FileName";
        /// <summary>XMLタグ　シミュレーション制御 </summary>
        static public readonly string xml_PRJCT_SIMULATION = "Simulation";
        /// <summary>XMLタグ　時間 </summary>
        static public readonly string xml_PRJCT_TIME = "Time";
        /// <summary>XML属性　シミュレーション開始時刻 </summary>
        static public readonly string xml_PRJCT_START_TIME = "start";
        /// <summary>XML属性　シミュレーション開始時刻 </summary>
        static public readonly string xml_PRJCT_PAUSE_TIME = "pause";
        /// <summary>XML属性　シミュレーション開始時刻 </summary>
        static public readonly string xml_PRJCT_GOAL_TIME = "goal";
        /// <summary>XML属性　シミュレーション開始時刻 </summary>
        static public readonly string xml_PRJCT_DELTA_TIME = "delta";
        /// <summary>XML属性　シミュレーション開始時刻 </summary>
        static public readonly string xml_PRJCT_TIME_UNIT = "Unit";
        // ===============================
        // その他の定義
        // ===============================

        /// <summary> 正常計算終了： シミュレーション計算 Calculation() の戻り値 </summary>
        static public readonly long CALCULATION_NORMAL_RETURN = 0;
        /// <summary> 異常計算終了： シミュレーション計算 Calculation() の戻り値 </summary>
        static public readonly long CALCULATION_ABEND_RETURN = -1;
        /// <summary> 収束せずに終了： シミュレーション計算 Calculation() の戻り値 </summary>
        static public readonly long CALCULATION_NOT_CONVERGED_RETURN = -2;
        /// <summary> 計算強制終了指示： シミュレーション計算 Calculation() の戻り値 </summary>
        static public readonly long CALCULATION_FORCE_STOP_RETURN = -3;
        /// <summary> 要素接続の構造上に問題あり： シミュレーション計算 Calculation() の戻り値 </summary>
        static public readonly long CALCULATION_ABEND_RETURN_BECAUSE_OF_STRUCT_ERROR = -93;
        /// <summary> （構造定義）伝送線レコード数自動調整不能 </summary>
        static public readonly long CALCULATION_CANNOT_OPTIMIZE_RETURN = -94;

        /// <summary>シンボル描画回転角度(0度)</summary>
        static public readonly double HYM_DRAW_ANGLE_0 = 0.0;
        /// <summary>シンボル描画回転角度(90度)</summary>
        static public readonly double HYM_DRAW_ANGLE_90 = 90.0;
        /// <summary>シンボル描画回転角度(180度)</summary>
        static public readonly double HYM_DRAW_ANGLE_180 = 180.0;
        /// <summary>シンボル描画回転角度(270度)</summary>
        static public readonly double HYM_DRAW_ANGLE_270 = 270.0;
        /// <summary>シンボル描画回転角度(360度)</summary>
        static public readonly double HYM_DRAW_ANGLE_360 = 360.0;
        /// <summary>シンボル描画回転角度(-90度)</summary>
        static public readonly double HYM_DRAW_ANGLE_M90 = -90.0;

        ///// <summary>リサイズポイントサイズ</summary>
        //static public readonly int HYM_RESIZE_POINT_SIZE = 4;

        /// <summary>モデルデバッグログ表示数最大値（リミット値）</summary>
        static public readonly long HYM_DEBUGLOG_DISP_MAX = 5000;

        // ===============================
        // イベント関係（サブイベント番号）
        // ===============================

        // -- 全体 --
        /// <summary>共通：OK印</summary>
        static public readonly long HYM_OK_SUBEVENT = 0x900000;
        /// <summary>共通：NG印</summary>
        static public readonly long HYM_NG_SUBEVENT = 0x990000;

        // -- モデル/伝送情報プロパティ設定 --
        /// <summary>モデル/伝送情報プロパティ設定</summary>
        static public readonly long MODEL_PROPERTY_SET = 0x00000013;

        /// <summary>ライブラリ検索</summary>
        static public readonly long QUERY_LIBRARY_LIST = 0x10000295;

        /// <summary>登録</summary>
        static public readonly long HYM_DB_REGISTER = 0x10000296;
        /// <summary>コピー登録</summary>
        static public readonly long HYM_LIBRARY_COPY_REGISTER = 0x10000297;

        ///<summary>プロジェクトデータエクスポート</summary>
        static public readonly long HYM_PRJDATA_EXPORT = 0x10000B01;
        ///<summary>プロジェクトデータインポート</summary>
        static public readonly long HYM_PRJDATA_IMPORT = 0x10000B02;
        ///<summary>プロジェクトデータインポート（ID設定）</summary>
        static public readonly long HYM_PRJDATA_IMPORT_SET_ID = 0x10000B03;
        // Ver1.1 追加 >>>
        ///<summary>プロジェクトデータ変換</summary>
        static public readonly long HYM_PRJDATA_CONVERT = 0x10000B04;
        ///<summary>プロジェクトデータ変換（ID設定）</summary>
        static public readonly long HYM_PRJDATA_CONVERT_SET_ID = 0x10000B05;
        // Ver1.1 追加 <<<

        // -- プロジェクト管理画面関連　--

        /// <summary>プロジェクト管理新規プロジェクト情報追加指示</summary>
        static public readonly long HYM_APPEND_EMPTY_PROJECTINF = 0x10000111;
        /// <summary>プロジェクト管理プロジェクト情報追加完了報告</summary>
        static public readonly long HYM_APPEND_PROJECTINF_END = 0x10000112;
        /// <summary>プロジェクト管理プロジェクト情報追加指示</summary>
        static public readonly long HYM_APPEND_PROJECTINF = 0x10000113;

        /// <summary>プロジェクト管理プロジェクトオープンＮＧ</summary>
        static public readonly long HYM_PROJECT_OPEN_NG = 0x10000211;


        // -- モデル管理画面関連　--
        /// <summary>データコンテナ送信</summary>
        static public readonly long HYM_DATACONTAINER_SEND = 0x10000201;
        /// <summary>データコンテナ設定報告</summary>
        static public readonly long HYM_NOTICE_DATACONTAINER_SET = 0x10000202;
        /// <summary>表示設定ID ON</summary>
        static public readonly long HYM_MODEL_SCREEN_DISP_KIND_ID_ON = 0x10000301;
        /// <summary>表示設定ID OFF</summary>
        static public readonly long HYM_MODEL_SCREEN_DISP_KIND_ID_OFF = 0x10000302;
        /// <summary>表示設定名称 ON</summary>
        static public readonly long HYM_MODEL_SCREEN_DISP_KIND_NAME_ON = 0x10000303;
        /// <summary>表示設定名称 OFF</summary>
        static public readonly long HYM_MODEL_SCREEN_DISP_KIND_NAME_OFF = 0x10000304;
        /// <summary>プロジェクト取り込み</summary>
        static public readonly long HYM_INCORPORATE_PROJECT = 0x10000305;

        /// <summary>要素モデル設定</summary>
        static public readonly long HYM_ELEMENT_MODEL_SET = 0x10000501;
        /// <summary>入力データ設定</summary>
        static public readonly long HYM_INPUT_DATA_SET = 0x10000502;
        /// <summary>出力データ設定</summary>
        static public readonly long HYM_OUTPUT_DATA_SET = 0x10000503;
        /// <summary>伝送情報型設定</summary>
        static public readonly long HYM_TRANSMISSION_INFORMATION_TYPE_SET = 0x10000504;
        /// <summary>ライブラリ設定情報解除</summary>
        static public readonly long HYM_LIBRARY_DATA_CANCEL = 0x10000505;

        /// <summary>アクティブ時モデル管理画面プロジェクト名称設定報告</summary>
        static public readonly long HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION = 0x10000701;
        /// <summary>クローズ時モデル管理画面プロジェクト名称設定報告</summary>
        static public readonly long HYM_CLOSED_PROJECT_NAME_SETUP_INFORMATION = 0x10000702;
        /// <summary>モデル管理画面ライブラリ設定要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_SETUP_REQUEST = 0x10000703;
        /// <summary>モデル管理画面ライブラリ設定解除要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_CANCEL_REQUEST = 0x10000704;
        /// <summary>モデル管理画面アクティブ通知</summary>
        static public readonly long HYM_NOTICE_MODEL_SCREEN_ACTIVE = 0x10000705;
        /// <summary>モデル管理画面クローズ指示</summary>
        static public readonly long HYM_MODEL_SCREEN_CLOSE = 0x10000706;
        /// <summary>モデル管理画面ライブラリ管理画面表示タブ1変更要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_TAB1_CHANGE = 0x10000707;
        /// <summary>モデル管理画面ライブラリ管理画面表示タブ2変更要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_TAB2_CHANGE = 0x10000708;
        /// <summary>モデル管理画面ライブラリ管理画面表示タブ3変更要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_TAB3_CHANGE = 0x10000709;
        /// <summary>モデル管理画面ライブラリ管理画面表示タブ4変更要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_TAB4_CHANGE = 0x10000710;
        /// <summary>モデル管理画面ライブラリ管理画面表示ツリー要求</summary>
        static public readonly long HYM_MODEL_LIBRARY_TREE_REQUEST = 0x10000711;
        /// <summary>モデル管理画面ライブラリ管理画面表示ツリー情報</summary>
        static public readonly long HYM_MODEL_LIBRARY_TREE_DATA = 0x10000712;

        /// <summary>モデル構造定義ファイル(XML)読み込み要求</summary>
        static public readonly long HYM_STRUCT_FILE_READ_REQUEST = 0x10000801;
        /// <summary>モデル構造定義ファイル(XML)読み込み完了</summary>
        static public readonly long HYM_NOTICE_STRUCT_FILE_READ_REQUEST = 0x10000802;
        /// <summary>モデル構造定義ファイル(XML)書き出し要求</summary>
        static public readonly long HYM_STRUCT_FILE_WRITE_REQUEST = 0x10000803;
        //↓↓↓↓↓必要ない？？？
        /// <summary>モデル構造定義ファイル(XML)書き出し完了</summary>
        static public readonly long HYM_NOTICE_STRUCT_FILE_WRITE_REQUEST = 0x10000804;

        /// <summary>シミュレーション状態保持クラス変更通知</summary>
        static public readonly long HYM_SIMULATION_STATUS_MODIFY_INFORMATION = 0x10000851;
        /// <summary>ヒストリーファイル更新要求通知</summary>
        static public readonly long HYM_HISTORY_FILE_UPDATE_REQUEST = 0x10000852;

        // -- その他関連　--

        /// <summary>データコンテナ新規生成</summary>
        static public readonly long HYM_CREATE_NEW_DATACONTAINER = 0x10000901;
        /// <summary>シミュレータ生成失敗</summary>
        static public readonly long HYM_SIMU_CREATE_NG = 0x10000902;
        /// <summary>モデル管理画面演算ログ出力要求</summary>
        static public readonly long HYM_MODELLOG_DISP_REQUEST = 0x10000904;

        /// <summary>モデルジェネレーター動作要求(構造定義ファイル作成)</summary>
        static public readonly long REQ_MODEL_STRUCT_GENERATOR_REQUEST = 0x10000915;
        /// <summary>モデルジェネレーター動作正常終了(構造定義ファイル作成)</summary>
        static public readonly long ACK_MODEL_STRUCT_GENERATOR_REQUEST = 0x10000916;
        /// <summary>モデルジェネレーター動作異常終了(構造定義ファイル作成)</summary>
        static public readonly long NAK_MODEL_STRUCT_GENERATOR_REQUEST = 0x10000917;
        /// <summary>要素モデル接続線レコード数の自動調整指示</summary>
        static public readonly long REQ_OPTIMIZE_RECORD_NUMBER = 0x10000920;
        /// <summary>要素モデル接続線レコード数の自動調整正常終了</summary>
        static public readonly long ACK_OPTIMIZE_RECORD_NUMBER = 0x10000921;
        /// <summary>要素モデル接続線レコード数の自動調整異常終了</summary>
        static public readonly long NAK_OPTIMIZE_RECORD_NUMBER = 0x10000922;

        // =======================
        // メニューコールバック
        // =======================
        /// <summary>ファイル：プロジェクト（ファイルベース）：新規作成</summary>
        static public readonly long HYMCO_PROJECT_NEW = 10101;
        /// <summary>ファイル：プロジェクト（ファイルベース）：開く</summary>
        static public readonly long HYMCO_PROJECT_OPEN = 10111;
        /// <summary>ファイル：プロジェクト（ファイルベース）：上書き保存</summary>
        static public readonly long HYMCO_PROJECT_SAVE = 10121;
        /// <summary>ファイル：プロジェクト（ファイルベース）：名前をつけて保存</summary>
        static public readonly long HYMCO_PROJECT_SAVE_NEW = 10122;
        /// <summary>ファイル：プロジェクト（ファイルベース）：ポータブルデータ取込</summary>
        static public readonly long HYMCO_PROJECT_IMPORT = 10131;
        /// <summary>ファイル：プロジェクト（ファイルベース）：ポータブルデータ作成</summary>
        static public readonly long HYMCO_PROJECT_EXPORT = 10141;

        /// <summary>ファイル：ＤＢ管理プロジェクト：新規作成</summary>
        static public readonly long HYMCO_FILE_NEW = 10100;
        /// <summary>ファイル：ＤＢ管理プロジェクト：検索</summary>
        static public readonly long HYMCO_DB_SEARCH = 10110;
        /// <summary>ファイル：ＤＢ管理プロジェクト：登録</summary>
        static public readonly long HYMCO_DB_REGIST = 10120;
        /// <summary>ファイル：ＤＢ管理プロジェクト：インポート</summary>
        static public readonly long HYMCO_DB_IMPORT = 10130;
        /// <summary>ファイル：ＤＢ管理プロジェクト：エクスポート</summary>
        static public readonly long HYMCO_DB_EXPORT = 10140;
        
        /// <summary>ファイル：演算中断保存：開く</summary>
        static public readonly long HYMCO_FILE_OPEN = 10200;
        /// <summary>ファイル：演算中断保存：閉じる</summary>
        static public readonly long HYMCO_FILE_CLOSE = 10300;
        /// <summary>ファイル：演算中断保存：上書き保存</summary>
        static public readonly long HYMCO_FILE_SAVE = 10500;
        /// <summary>ファイル：演算中断保存：名前を付けて保存</summary>
        static public readonly long HYMCO_FILE_SAVE_NEW = 10600;
        /// <summary>ファイル：構造定義ファイル：読み込み</summary>
        static public readonly long HYMCO_MODEL_STRUCTINFO_READ = 50601;
        /// <summary>ファイル：構造定義ファイル：書き出し(簡易)</summary>
        static public readonly long HYMCO_MODEL_STRUCTINFO_WRITE_PART = 50602;
        /// <summary>ファイル：構造定義ファイル：書き出し(完全)</summary>
        static public readonly long HYMCO_MODEL_STRUCTINFO_WRITE_ALL = 50603;
        /// <summary>ファイル：構造定義ファイル：書き出し(分割)</summary>
        static public readonly long HYMCO_MODEL_STRUCTINFO_WRITE_SEPARATE = 50604;
// Ver1.1 追加 >>>
        /// <summary>ファイル：環境設定：データフォルダー格納先設定</summary>
        static public readonly long HYMCO_SETTING_DATAFOLDER = 10700;
        /// <summary>ファイル：環境設定：GIS起動パス設定</summary>
        static public readonly long HYMCO_SETTING_GISPATH = 10710;
// Ver1.1 追加 <<<
        /// <summary>ファイル：終了</summary>
        static public readonly long HYMCO_FILE_EXIT = 10800;

        /// <summary>編集：元に戻す</summary>
        static public readonly long HYMCO_EDIT_UNDO = 20100;
        /// <summary>編集：やり直し</summary>
        static public readonly long HYMCO_EDIT_REDO = 20200;
        /// <summary>編集：切り取り</summary>
        static public readonly long HYMCO_EDIT_CUT = 20400;
        /// <summary>編集：コピー</summary>
        static public readonly long HYMCO_EDIT_COPY = 20500;
        /// <summary>編集：貼り付け</summary>
        static public readonly long HYMCO_EDIT_PASTE = 20600;
        /// <summary>編集：削除</summary>
        static public readonly long HYMCO_EDIT_DELETE = 20700;
        /// <summary>編集：すべて選択</summary>
        static public readonly long HYMCO_EDIT_SELECTALL = 20900;
        /// <summary>編集：順序：最前面へ移動</summary>
        static public readonly long HYMCO_EDIT_MOVE_TOP = 21001;
        /// <summary>編集：順序：最背面へ移動</summary>
        static public readonly long HYMCO_EDIT_MOVE_BOTTOM = 21002;
        /// <summary>編集：グループ化：部分系グループ化</summary>
        static public readonly long HYMCO_EDIT_PART_GROUP = 21101;
        /// <summary>編集：グループ化：収束演算系グループ化</summary>
        static public readonly long HYMCO_EDIT_CONVEGENT_CALC_GROUP = 21102;
        /// <summary>編集：グループ化：グループ解除</summary>
        static public readonly long HYMCO_EDIT_DISBAND = 21103;

        /// <summary>プロジェクト管理：ビルド</summary>
        static public readonly long HYMCO_PROJECT_CALC_BUILD = 30010;
        /// <summary>プロジェクト管理：計算開始</summary>
        static public readonly long HYMCO_PROJECT_CALC_START = 30100;
        /// <summary>プロジェクト管理：計算中断</summary>
        static public readonly long HYMCO_PROJECT_CALC_PAUSE = 30200;
        /// <summary>プロジェクト管理：計算停止</summary>
        static public readonly long HYMCO_PROJECT_CALC_STOP = 30300;
        /// <summary>プロジェクト管理：計算リセット</summary>
        static public readonly long HYMCO_PROJECT_CALC_RESET = 30500;
        /// <summary>プロジェクト管理：制御パラメータ設定</summary>
        static public readonly long HYMCO_PROJECT_PARA_SET = 30600;
        /// <summary>プロジェクト管理：プロジェクトプロパティ表示</summary>
        static public readonly long HYMCO_PROJECT_DISP_PROPERTY = 30610;    // Ver1.5 追加（プロジェクトプロパティ画面）
        /// <summary>ライブラリ管理：設定</summary>
        static public readonly long HYMCO_LIBRARY_SET = 40100;
        /// <summary>ライブラリ管理：解除</summary>
        static public readonly long HYMCO_LIBRARY_RELEASE = 40200;

        /// <summary>モデル管理：プロジェクト取り込み</summary>
        static public readonly long HYMCO_MODEL_LOAD_PROJECT = 50100;
        /// <summary>モデル管理：内部表示：表示</summary>
        static public readonly long HYMCO_MODEL_PART_DISPLAY = 50201;
        /// <summary>モデル管理：内部表示：閉じる</summary>
        static public readonly long HYMCO_MODEL_PART_CLOSE = 50202;
        /// <summary>モデル管理：計算結果表示：画面表示</summary>
        static public readonly long HYMCO_MODEL_CALCRESULT_VIEWERDISP = 50301;
        /// <summary>モデル管理：計算結果表示：計算結果ファイル表示</summary>
        static public readonly long HYMCO_MODEL_CALCRESULT_FILEDISP = 50302;
        /// <summary>モデル管理：モデルチェック</summary>
        static public readonly long HYMCO_MODEL_CHECK = 50400;
        /// <summary>モデル管理：表示設定：ＩＤを表示(設定）</summary>
        static public readonly long HYMCO_MODEL_DISP_ID_ON = 50501;
        /// <summary>モデル管理：表示設定：ＩＤを表示（解除）</summary>
        static public readonly long HYMCO_MODEL_DISP_ID_OFF = 50502;
        /// <summary>モデル管理：表示設定：名前を表示（設定）</summary>
        static public readonly long HYMCO_MODEL_DISP_NAME_ON = 50503;
        /// <summary>モデル管理：表示設定：名前を表示（解除）</summary>
        static public readonly long HYMCO_MODEL_DISP_NAME_OFF = 50504;

        /// <summary>モデル管理：カスタマイズ</summary>
        static public readonly long HYMCO_MODEL_CUSTUMIZE = 50700;
        /// <summary>モデル管理：ガイドマップ</summary>
        static public readonly long HYMCO_MODEL_GUIDMAP = 50800;

        /// <summary>モデル管理：要素間接続データレコード数自動調整</summary>
        static public readonly long HYMCO_MODEL_OPTIMIZE_TRANINFR = 50802;

        /// <summary>ツール：モデルジェネレータ</summary>
        static public readonly long HYMCO_TOOL_MODEL_GENERATOER = 60100;
        ///// <summary>ツール：結果表示</summary>
        //static public readonly long HYMCO_TOOL_GIS = 60200;

        /// <summary>ツール：ラッパーモデル情報編集</summary>
        static public readonly long HYMCO_TOOL_WRAPPER_MODEL_EDIT = 60800;

        /// <summary>ヘルプ：ライブラリ管理</summary>
        static public readonly long HYMCO_HELP_CTL_LIB_MANGAGE = 80900;
        /// <summary>ヘルプ：ライブラリ入力</summary>
        static public readonly long HYMCO_HELP_CTL_LIB_IMPORT = 80901;
        /// <summary>ヘルプ：ライブラリ出力</summary>
        static public readonly long HYMCO_HELP_CTL_LIB_EXPORT = 80902;
        /// <summary>ヘルプ：ライブラリ削除</summary>
        static public readonly long HYMCO_HELP_CTL_LIB_DELETE = 80903;

        // =======================
        // ファイル入出力関連
        // =======================
        /// <summary>上書き保存失敗:ファイルパス無し</summary>
        static public readonly HySString ERR_SAVE_NO_FILE_PATH = new HySString("NoFilePath");
    }
}
