﻿// <summary>ソースコード：モデル関連情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;


namespace CommonMP.HYMCO.Interface
{
    /// <summary><para>class outline:</para>
    /// <para>モデル関連の定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McModelLibraryDefine
    {
        // ===========================
        // 演算要素種別識別子関係（システムで準備しておくモデルのみ）
        // ===========================
        /// <summary>システムモデルファクトリ</summary>
        static public readonly HySID SYSTEM_MODEL_FACTORY = new  HySID("McSystemModelFactory");
        //// <summary>システムプロパティ画面ファクトリ</summary>
        //static public readonly HySID SYSTEM_PROPERTY_SCREEN_FACTORY = new HySID("McSystemPropertyScreenFactory");

        // ===========================
        // 演算要素種別識別子関係（システムで準備しておくモデルのみ）
        // ===========================
        /// <summary>演算要素</summary>
        static public readonly HySObjectKind ELEMENT = new HySObjectKind(("Element"));
        /// <summary>演算用の要素</summary>
        static public readonly HySObjectKind ELEMENT_CALC = new HySObjectKind(("CalculationElement"));
        /// <summary>収束演算用の要素</summary>
        static public readonly HySObjectKind ELEMENT_CONVERGENCE = new HySObjectKind(("CovergenceElement"));
        /// <summary>グループ化要素</summary>
        static public readonly HySObjectKind ELEMENT_GROUP = new HySObjectKind(("GroupElement"));


        // ===========================
        // モデル種別識別子関係（システムで準備しておくモデルのみ）
        // ===========================
        /// <summary>何もしない演算モデル</summary>
        static public readonly HySObjectKind HYM_MODEL_IDLE = new HySObjectKind(("IdleModel"));
        /// <summary>データマージモデル</summary>
        static public readonly HySObjectKind HYM_MODEL_DATA_MERGE = new HySObjectKind(("DataMerge"));
        /// <summary>部分系演算制御モデル</summary>
        static public readonly HySObjectKind HYM_MODEL_SUBSYSTEM = new HySObjectKind(("SubSystemCtl"));
        /// <summary>繰り返し収束演算系演算制御モデル</summary>
        static public readonly HySObjectKind HYM_MODEL_CONVERGENCE_ITERATION = new HySObjectKind(("McCnvrgncIterationInfo"));
        /// <summary>水理収束演算系演算制御H24版</summary>
        static public readonly HySObjectKind HYM_MODEL_HYDRAULIC_CONVERGENCE_CTL_H24 = new HySObjectKind(("McHydraulicCnvrgncCtlH24"));
        /// <summary>プロジェクト(FigureUnity)用モデル種別識別子</summary>
        static public readonly HySObjectKind HYM_MODEL_FIG_UNITY = new HySObjectKind(("FigUnityPropertyProperty"));
        /// <summary>演算結果DBアクセス出力要素</summary>
        static public readonly HySObjectKind HYM_MODEL_CALRESULT_DBA_OUT = new HySObjectKind(("CalResultDBAccessOut"));
        /// <summary>時系列任意入力計算結果モニターグラフ出力モデル要素</summary>
        static public readonly HySObjectKind MODEL_SCREEN_OUT_LINES = new HySObjectKind("McLineGraphScreenOut");
        /// <summary>時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力モデル要素</summary>
        static public readonly HySObjectKind MODEL_SCREEN_OUT_HYETO_HYDRO = new HySObjectKind("McHyetoHydroGraphScreenOut");
        /// <summary>１次元配列縦断データ入力計算結果モニターグラフ出力モデル要素</summary>
        static public readonly HySObjectKind MODEL_SCREEN_OUT_REVERBED = new HySObjectKind("McReverbedGraphScreenOut");


        // ===========================
        // モデルジェネレーターが使用するデータ設定画面（システムで準備しておく汎用画面）
        // ===========================
        /// <summary>１次元配列縦断データ入力計算結果モニターグラフ出力モデル要素</summary>
        static public readonly HySObjectKind MODEL_GENERATOR_SELECT_COMMON_SCREEN = new HySObjectKind("McMdlGenSelectCommonScreen");

        // ===========================
        // モデルジェネレーターが使用するデフォルトデータ（システムで準備しておく汎用情報）
        // ===========================

        // ===========================
        // モデル名称関係（システムで準備しておくモデルのみ）
        // ===========================
        /// <summary>何もしない演算モデル</summary>
        static public readonly HySString MODEL_NAME_IDLE = new HySString(Properties.HymcoIFResources.MODEL_NAME_IDLE);  //"何もしない演算モデル"
        /// <summary>データマージモデル</summary>
        static public readonly HySString MODEL_NAME_DATA_MERGE = new HySString(Properties.HymcoIFResources.MODEL_NAME_DATA_MERGE);  //"データをマージする要素"
        /// <summary>部分系演算制御モデル</summary>
        static public readonly HySString MODEL_NAME_SUBSYSTEM = new HySString(Properties.HymcoIFResources.MODEL_NAME_SUBSYSTEM);    //"部分系演算制御"
        /// <summary>典型収束演算系演算制御モデル</summary>
        static public readonly HySString MODEL_NAME_CONVERGENCE_ITERATION = new HySString(Properties.HymcoIFResources.MODEL_NAME_CONVERGENCE_ITERATION);    //"繰り返し収束演算系演算制御"
        /// <summary>水理収束演算系演算制御H24版</summary>
        static public readonly HySString MODEL_NAME_HYDRAULIC_CONVERGENCE_CTL_H24 = new HySString(Properties.HymcoIFResources.MODEL_NAME_HYDRAULIC_CONVERGENCE_CTL_H24);  // "水理収束演算系演算制御H24版"
        /// <summary>演算結果DBアクセス出力要素</summary>
        static public readonly HySString MODEL_NAME_CALRESULT_DBA_OUT = new HySString(Properties.HymcoIFResources.MODEL_NAME_CALRESULT_DBA_OUT);    //"演算結果ＤＢ出力要素"
        /// <summary>時系列任意入力計算結果モニターグラフ出力モデル名称</summary>
        static public readonly HySString MODEL_NAME_SCREEN_OUT_LINES = new HySString(Properties.HymcoIFResources.MODEL_NAME_SCREEN_OUT_LINES);  //"時系列任意入力計算結果モニターグラフ出力"
        /// <summary>時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力モデル名称</summary>
        static public readonly HySString MODEL_NAME_SCREEN_OUT_HYETO_HYDRO = new HySString(Properties.HymcoIFResources.MODEL_NAME_SCREEN_OUT_HYETO_HYDRO);  //"時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力"
        /// <summary>１次元配列縦断データ入力計算結果モニターグラフ出力モデル名称</summary>
        static public readonly HySString MODEL_NAME_SCREEN_OUT_REVERBED = new HySString(Properties.HymcoIFResources.MODEL_NAME_SCREEN_OUT_REVERBED);    //"１次元配列縦断データ入力計算結果モニターグラフ出力"

        // ===========================
        // モデル種別大区分　classification　（LibraryCategory.xml内に記述されている文字列）
        // ===========================
             
        // <Division Name="演算要素" ID="Element">
        /// <summary>演算要素</summary>
        static public readonly HySObjectKind DIVISION_CALCULATION_MODEL = new HySObjectKind("Element");
        //<Division Name="入力方式" ID="Input">
        /// <summary>入力方式</summary>
        static public readonly HySObjectKind DIVISION_INPUT_MODEL = new HySObjectKind("Input");
        //<Division Name="出力方式" ID="Output">
        /// <summary>出力方式</summary>
        static public readonly HySObjectKind DIVISION_OUTPUT_MODEL = new HySObjectKind("Output");
        //<Division Name="伝送情報型" ID="TransInformation">
        /// <summary>伝送情報型</summary>
        static public readonly HySObjectKind DIVISION_TRANSINFORMATION = new HySObjectKind("TransInformation");

        // ===========================
        // モデル種別小区分　classification　（LibraryCategory.xml内に記述されている文字列）
        // ===========================

        /// <summary>水文モデル関連Hydrological</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_HYDROLOGY = new HySObjectKind(new HySString("CAL_HYDROLOGICAL_MODELS"));
        /// <summary>河川モデル関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_RIVER = new HySObjectKind(new HySString("CAL_RIVER_MODELS"));
        /// <summary>ダム／発電モデル関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_DAM = new HySObjectKind(new HySString("CAL_DAM_MODELS"));
        /// <summary>用排水モデル関連duct</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_WATERDUCT = new HySObjectKind(new HySString("CAL_WATERDUCT_MODELS"));
        /// <summary>地下水モデル関連groundwater</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_GROUNDWATER = new HySObjectKind(new HySString("CAL_GROUNDWATER_MODELS"));
        /// <summary>★海洋モデル関連coast</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_OCEAN = new HySObjectKind(new HySString("CAL_OCEAN_MODELS"));
        /// <summary>海岸／港湾モデル関連coast</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_COAST = new HySObjectKind(new HySString("CAL_COAST_MODELS"));
        /// <summary>水循環モデル関連circulation</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_WATERCIRCULATION = new HySObjectKind(new HySString("CAL_WATERCIRCULATION_MODELS"));
        //// <summary>流域計算モデル関連</summary>
        //static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_BASIN = new HySObjectKind(new HySString("CAL_BASIN_MODELS"));
        //// <summary>河道計算モデル関連</summary>
        //static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_LANE = new HySObjectKind(new HySString("CAL_LANE_MODELS"));
        /// <summary>その他計算モデル関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_ETC = new HySObjectKind(new HySString("CAL_MODELS"));
        /// <summary>計算制御モデル関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_MODEL_CTL = new HySObjectKind(new HySString("CAL_CONTROL_MODEL"));
        /// <summary>サンプルモデル等</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE = new HySObjectKind(new HySString("CAL_SAMPLE_MODELS"));

        
        /// <summary>CSVファイル入力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_INPUT_CSV_FILE = new HySObjectKind(new HySString("INPUT_CSV_FILE"));
        /// <summary>特定フォーマットファイル入力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_INPUT_SPF_FILE = new HySObjectKind(new HySString("INPUT_SPECIFIC_FILE"));
        
        /// <summary>画面出力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_OUTPUT_SCREEN = new HySObjectKind(new HySString("OUTPUT_SCREEN"));
        /// <summary>CSVファイル出力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_OUTPUT_CSV_FILE = new HySObjectKind(new HySString("OUTPUT_CSV_FILE"));
        /// <summary>GISファイル出力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_OUTPUT_GIS_FILE = new HySObjectKind(new HySString("OUTPUT_GIS_FILE"));
        /// <summary>特定フォーマットファイル出力要素関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_OUTPUT_SPF_FILE = new HySObjectKind(new HySString("OUTPUT_SPECIFIC_FILE"));

        /// <summary>定常：汎用形式伝送データ関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_STD_CONST_FORM = new HySObjectKind(new HySString("TRAN_STANDARD_CONST_FORM"));
        /// <summary>時系列：汎用形式伝送データ関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_STD_SERIAL_FORM = new HySObjectKind(new HySString("TRAN_STANDARD_SERIAL_FORM"));
        /// <summary>GIS伝送データ関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_GIS_FORM = new HySObjectKind(new HySString("TRAN_GIS_FORM"));   
        /// <summary>グラフ伝送データ関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_GRAPH_FORM = new HySObjectKind(new HySString("TRAN_GRAPH_FORM"));  
        /// <summary>特定形式伝送データ関連</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_SPF_FORM = new HySObjectKind(new HySString("TRAN_SPECIAL_FORM"));
        /// <summary>★相互伝送データ関連 Mutual</summary>
        static public readonly HySObjectKind MODEL_CLASSIFICATION_TRAN_MUTUAL_FORM = new HySObjectKind(new HySString("TRAN_MUTUAL_FORM"));

    }
}
