// <summary>ソースコード：モデル関連情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYMCO.Interface
{
    /// <summary><para>class outline:</para>
    /// <para>伝送データ型式の定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McTranInfoDefine
    {
        // ===========================
        // 伝送データ種別識別子関係（システムで準備しておくモデルのみ）
        // ===========================

        /// <summary>１次元定常情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D1_CELL = new HySObjectKind(("McD1CellArrayTranInfo"));
        /// <summary>２次元定常情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D2_CELL = new HySObjectKind(("McD2CellArrayTranInfo"));
        /// <summary>３次元定常情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D3_CELL = new HySObjectKind(("McD3CellArrayTranInfo"));
        /// <summary>ＧＩＳ１次元情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D1_GIS = new HySObjectKind(("McGeoDim1TranInfo"));
        /// <summary>ＧＩＳ２次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D2_GIS_MESH = new HySObjectKind(("McGeoDim2MeshTranInfo"));
        /// <summary>ＧＩＳ３次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D3_GIS_MESH = new HySObjectKind(("McGeoDim3MeshTranInfo"));

        /// <summary>セル一つの時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind SINGLE_CELL_SERIAL = new HySObjectKind(("McTimeSeriesSingleCellTranInfo"));
        /// <summary>１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D1_CELL_SERIAL = new HySObjectKind(("McTimeSeriesD1CellArrayTranInfo"));
        /// <summary>２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D2_CELL_SERIAL = new HySObjectKind(("McTimeSeriesD2CellArrayTranInfo"));
        /// <summary>３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D3_CELL_SERIAL = new HySObjectKind(("McTimeSeriesD3CellArrayTranInfo"));
        /// <summary>ＧＩＳ１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D1_GIS_SERIAL = new HySObjectKind(("McTimeSeriesGeoD1TranInfo"));
        /// <summary>ＧＩＳ２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D2_GIS_MESH_SERIAL = new HySObjectKind(("McTimeSeriesGeoD2MeshTranInfo"));
        /// <summary>ＧＩＳ３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySObjectKind D3_GIS_MESH_SERIAL = new HySObjectKind(("McTimeSeriesGeoD3MeshTranInfo"));

        /// <summary>相互結合要素間伝送データ</summary>
        static public readonly HySObjectKind MUTUAL_SINGLE_TRAN_SERIAL = new HySObjectKind(("McTimeSeriesSingleMutualCellTranInfor"));
        /// <summary>相互結合要素間伝送データ</summary>
        static public readonly HySObjectKind MUTUAL_D1_TRAN_SERIAL = new HySObjectKind(("McTimeSeriesD1MutualCellTranInfor"));
        /// <summary>相互結合要素間伝送データ</summary>
        static public readonly HySObjectKind MUTUAL_D2_TRAN_SERIAL = new HySObjectKind(("McTimeSeriesD2MutualCellTranInfor"));
        /// <summary>相互結合要素間伝送データ</summary>
        static public readonly HySObjectKind MUTUAL_D3_TRAN_SERIAL = new HySObjectKind(("McTimeSeriesD3MutualCellTranInfor"));

        //// <summary>プロトタイプ版：１次元折れ線表示用伝送データ</summary>
        //static public readonly HySObjectKind TRNINF_LINE_GRAPH = new HySObjectKind(("McLineGraphTranInfo"));
        /// <summary>プロトタイプ版：時系列情報 要素間伝送データ</summary>
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySObjectKind TRNINF_MULTI_SERIAL_PROTOTYPE = new HySObjectKind(("McMultiSerialTranInfo"));
            /// <summary>プロトタイプ版：１次元時系列情報 要素間伝送データ</summary>
            [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySObjectKind TRNINF_1DIM_SERIAL_PROTOTYPE = new HySObjectKind(("McTimeSeries1DTranInfo"));
            /// <summary>プロトタイプ版：２次元時系列情報 要素間伝送データ</summary>
            [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySObjectKind TRNINF_2DIM_SERIAL_PROTOTYPE = new HySObjectKind(("McTimeSeries2DTranInfo"));

        // ===========================
        // 伝送データ名称関係（システムで準備しておくモデルのみ）
        // ===========================

        /// <summary>１次元定常情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D1_CELL = new HySString(Properties.HymcoIFResources.NAME_D1_CELL);    //"１次元配列定常情報"
        /// <summary>２次元定常情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D2_CELL = new HySString(Properties.HymcoIFResources.NAME_D2_CELL);    //"２次元配列定常情報"
        /// <summary>３次元定常情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D3_CELL = new HySString(Properties.HymcoIFResources.NAME_D3_CELL);    //"３次元配列定常情報"
        /// <summary>ＧＩＳ１次元情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D1_GIS = new HySString(Properties.HymcoIFResources.NAME_D1_GIS);  //"ＧＩＳ１次元情報"
        /// <summary>ＧＩＳ２次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D2_GIS_MESH = new HySString(Properties.HymcoIFResources.NAME_D2_GIS_MESH);    //"ＧＩＳ２次元メッシュ情報"
        /// <summary>ＧＩＳ３次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D3_GIS_MESH = new HySString(Properties.HymcoIFResources.NAME_D3_GIS_MESH);    //"ＧＩＳ３次元メッシュ情報"

        /// <summary>セル一つの時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_SINGLE_CELL_SERIAL = new HySString(Properties.HymcoIFResources.NAME_SINGLE_CELL_SERIAL);  //"ポイント時系列情報"
        /// <summary>１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D1_CELL_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D1_CELL_SERIAL);  //"１次元配列時系列情報"
        /// <summary>２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D2_CELL_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D2_CELL_SERIAL);  //"２次元配列時系列情報"
        /// <summary>３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D3_CELL_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D3_CELL_SERIAL);  //"３次元配列時系列情報"

        /// <summary>ＧＩＳ１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D1_GIS_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D1_GIS_SERIAL);    //"ＧＩＳ１次元時系列情報"
        /// <summary>ＧＩＳ２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D2_GIS_MESH_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D2_GIS_MESH_SERIAL);  //"ＧＩＳ２次元メッシュ時系列情報"
        /// <summary>ＧＩＳ３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D3_GIS_MESH_SERIAL = new HySString(Properties.HymcoIFResources.NAME_D3_GIS_MESH_SERIAL);  //"ＧＩＳ３次元メッシュ時系列情報"

        /// <summary>相互結合＿時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_SINGLE_MUTUAL_SERIAL = new HySString("相互通信＿ポイント＿時系列情報");  //"相互通信＿時系列情報"
        /// <summary>相互結合＿時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D1_MUTUAL_SERIAL = new HySString("相互通信＿一次元＿時系列情報");  //"相互通信＿時系列情報"
        /// <summary>相互結合＿時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D2_MUTUAL_SERIAL = new HySString("相互通信＿二次元＿時系列情報");  //"相互通信＿時系列情報"
        /// <summary>相互結合＿時系列情報 要素間伝送データ</summary>
        static public readonly HySString NAME_D3_MUTUAL_SERIAL = new HySString("相互通信＿三次元＿時系列情報");  //"相互通信＿時系列情報"


            //// <summary>プロトタイプ版：１次元折れ線表示用伝送データ</summary>
            //static public readonly HySString TRNINF_NAME_LINE_GRAPH = new HySString("折れ線表示用伝送データ(ﾌﾟﾛﾄﾀｲﾌﾟ版)");
            /// <summary>プロトタイプ版：時系列情報 要素間伝送データ</summary>
            [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySString TRNINF_NAME_MULTI_SERIAL_PROTOTYPE = new HySString(Properties.HymcoIFResources.TRNINF_NAME_MULTI_SERIAL_PROTOTYPE);    //"時系列情報 要素間伝送データ(ﾌﾟﾛﾄﾀｲﾌﾟ版)"
            /// <summary>プロトタイプ版：１次元時系列情報 要素間伝送データ</summary>
            [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySString TRNINF_NAME_1DIM_SERIAL_PROTOTYPE = new HySString(Properties.HymcoIFResources.TRNINF_NAME_1DIM_SERIAL_PROTOTYPE);  //"１次元時系列情報 要素間伝送データ(ﾌﾟﾛﾄﾀｲﾌﾟ版)"
            /// <summary>プロトタイプ版：２次元時系列情報 要素間伝送データ</summary>
            [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない")]
            static public readonly HySString TRNINF_NAME_2DIM_SERIAL_PROTOTYPE = new HySString(Properties.HymcoIFResources.TRNINF_NAME_2DIM_SERIAL_PROTOTYPE);  //"２次元時系列情報 要素間伝送データ(ﾌﾟﾛﾄﾀｲﾌﾟ版)"


        // ===========================
        // 伝送データ名称関係（システムで準備しておくモデルのみ）
        // モデルウィザードの送受信パターン設定用に定義（パターン識別子用の伝送情報付加情報）
        // ===========================

        /// <summary>１次元定常情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D1_CELL = new HySString("_1D");    //"１次元配列定常情報"
        /// <summary>２次元定常情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D2_CELL = new HySString("_2D");    //"２次元配列定常情報"
        /// <summary>３次元定常情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D3_CELL = new HySString("_3D");    //"３次元配列定常情報"
        /// <summary>ＧＩＳ１次元情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D1_GIS = new HySString("_1D_GIS");  //"ＧＩＳ１次元情報"
        /// <summary>ＧＩＳ２次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D2_GIS_MESH = new HySString("_2D_GIS");    //"ＧＩＳ２次元メッシュ情報"
        /// <summary>ＧＩＳ３次元メッシュ情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D3_GIS_MESH = new HySString("_3D_GIS");    //"ＧＩＳ３次元メッシュ情報"

        /// <summary>セル一つの時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_SINGLE_CELL_SERIAL = new HySString("_Point");  //"ポイント時系列情報"
        /// <summary>１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D1_CELL_SERIAL = new HySString("_1D_S");  //"１次元配列時系列情報"
        /// <summary>２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D2_CELL_SERIAL = new HySString("_2D_S");  //"２次元配列時系列情報"
        /// <summary>３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D3_CELL_SERIAL = new HySString("_3D_S");  //"３次元配列時系列情報"

        /// <summary>ＧＩＳ１次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D1_GIS_SERIAL = new HySString("_1D_GIS_S");    //"ＧＩＳ１次元時系列情報"
        /// <summary>ＧＩＳ２次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D2_GIS_MESH_SERIAL = new HySString("_2D_GIS_S");  //"ＧＩＳ２次元メッシュ時系列情報"
        /// <summary>ＧＩＳ３次元時系列情報 要素間伝送データ</summary>
        static public readonly HySString WIZARD_D3_GIS_MESH_SERIAL = new HySString("_3D_GIS_S");  //"ＧＩＳ３次元メッシュ時系列情報"


        // ===========================
        // 伝送データ内のセルＩＤ管理表種別定義
        // ===========================
        /*
        /// <summary>セルを識別するＩＤを管理するデータの種別</summary>
        public enum CellIDManageDataKind
        {
            /// <summary>McCellIDMngData用</summary>
            TRAN_CELL_ID_TYPE = 1,
            /// <summary>McModelCellCorrespondenceInf 用</summary>
            MODEL_CELL_CORRESPONDENCE_TYPE
        }
        /// <summary>伝送データ内のセルＩＤ管理表  McCellIDMngData</summary>
        static public readonly HySString NAME_TRAN_CELL_ID_MANAGE_DATA = new HySString("伝送データ内セル識別子管理表");
        /// <summary>上下のモデル内セル対応表（モデルジェネレータ等使用） McModelCellCorrespondenceInf</summary>
        static public readonly HySString NAME_MODEL_CELL_CORRESPONDENCE = new HySString("上下モデルセル対応表");
        */

        /// <summary>伝送データ次元数設定上限値(環境設定ファイルから読み出されて設定される)</summary>
        static public long TRNINF_DIM_MAX = 50000;
    }
}
