// <summary>ソースコード：未来計算型演算モデル基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


namespace CommonMP.HYMCO.Interface.Model
{
    /// <summary><para>class outline:</para>
    /// <para>未来計算型演算モデル基底クラス（通常　演算処理は本クラスを派生して作成する）</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para> 補間処理付き </para>
    /// <para>モデル特性：現在の入力値から未来のモデル内状態を計算し出力する（時間が進む）</para>
    /// </remarks>
    public abstract class McForecastModelBase : McBasicCalculateModelBase, McForcastTypeModel
    {
        /// <summary>最終目標時刻（フレームワーク側の計算制御には使用せず。参照のみ）</summary>
        protected HySTime m_csFinalGoalTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary>最終目標時刻（フレームワーク側の計算制御には使用せず。参照のみ）</summary>
        protected HySTime m_csMemoryFinalGoalTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(ref csInitialData, ref csInputDataList, ref csOutputDataList)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="csInputDataList">前段接続要素からの伝送情報リスト</param>
        /// <param name="csOutputDataList">前段接続要素への伝送情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool Initialize(ref McPropertyInfoRoot csInitialData, ref HySDataLinkedList csInputDataList, ref HySDataLinkedList csOutputDataList)
        {
            bool bRtn = base.Initialize(ref csInitialData, ref csInputDataList, ref csOutputDataList);
            
            if (bRtn == true)
            {
                if (DataFusion(ref csOutputDataList) != 0)
                {
                    bRtn = false;
                }
            }
            return bRtn;
        }

        //
        /// <summary><para>method outline:</para>
        /// <para>最終目標時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSimuGoalTime( csTm )</para>
        /// </example>
        /// <param name="csTm">最終目標時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>設定した値は、フレームワーク側では使用しない。派生クラスで参照するのみ</para>
        /// </remarks>
        public override void SetSimuGoalTime(HySTime csTm)
        {
            m_csFinalGoalTime.SetTime(csTm);
        }

        /// <summary><para>method outline:</para>
        /// <para>現在状態の一時記憶（但し計算途中状態は除く）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Memorize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Memorize()とRemember()は対で使用する</para>
        /// </remarks>
        public override void Memorize()
        {
            base.Memorize();
            m_csMemoryFinalGoalTime = m_csFinalGoalTime.Clone();

        }
        /// <summary><para>method outline:</para>
        /// <para>Memorize()した情報の復元</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Remember() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Memorize()とRemember()は対で使用する</para>
        /// </remarks>
        public override void Remember()
        {
            base.Remember();
            m_csFinalGoalTime = m_csMemoryFinalGoalTime.Clone();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルにモデル内情報を全て書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileOUT(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileOUT(HySDataRoot csData)
        {
            bool bRtn = base.FileOUT(csData);
            if (bRtn == true)
            {
                ((McCmnElementOutData)csData).SetTimeData(McForecastModelBase.FINAL_GOAL_TIME, m_csFinalGoalTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイルからモデル情報を全て読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = FileIN(csData)</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool FileIN(HySDataRoot csData)
        {
            bool bRtn = base.FileIN(csData);
            if (bRtn == true)
            {
                m_csFinalGoalTime = (HySTime)((McCmnElementOutData)csData).GetTimeData(McForecastModelBase.FINAL_GOAL_TIME);
                if (m_csFinalGoalTime == null) { m_csFinalGoalTime = HySTime.DEFAULT_TIME.Clone(); }
            }
            return bRtn;
        }

        /// <summary>最終演算目標時刻データ</summary>
        static public readonly HySString FINAL_GOAL_TIME = new HySString("m_csFinalGoalTime");
    }
}
