﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラスＩ／Ｆ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public interface HYMCO_MODEL_FACTORY_CREATOR : McRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory();
    }
}

namespace CommonMP.HYMCO.Interface.Model
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface McModelFactory : HySFactory
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySID CreateFactoryID();

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McCalModel CreateCalModel(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID);

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind);
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind);

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csLibraryID, csModelKind,csCalInfoID ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csCalInfoID">データID（ダミー)</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McCalInfo CreateCalInfo(HySID csLibraryID, HySObjectKind csModelKind, HySID csCalInfoID);

        /// <summary><para>method outline:</para>
        /// <para>伝送データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = CreateTransData(csLibraryID, csTransDataKind, csPropertyInfo, csTransDataID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <param name="csPropertyInfo">伝送データプロパティ表示／設定情報クラス</param>
        /// <param name="csTransDataID">伝送データID</param>
        /// <returns>データ伝送クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McTranInfo CreateTransData(HySID csLibraryID, HySObjectKind csTransDataKind, McPropertyInfoRoot csPropertyInfo, HySID csTransDataID);

        /// <summary><para>method outline:</para>
        /// <para>伝送データプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateTranInfoPropertyInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyInfoRoot CreateTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csTransDataKind);
        /// <summary><para>method outline:</para>
        /// <para>伝送データ初期化設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateTranInfoInitialInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>伝送データプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyInfoRoot CreateTranInfoInitialInfo(HySID csLibraryID, HySObjectKind csTransDataKind);

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        HySDataLinkedList GetCalModelInfoList();


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ================= start of モデルデータ半自動作成ツール用メソッド ============================
        // モデルデータ半自動作成ツール（モデルジェネレーター）を作成する開発者は下記メソッド群を
        // オーバーライド実装して下さい。


        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        HySDataLinkedList GetModelNetworkGeneratorList();
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID);
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID);
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とするデータのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind);

        // ================= end  of モデルデータ半自動作成ツール用メソッド ============================
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする必須のデータを提供するか？</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsEssentialModelGenerationData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:必須、=false:モデルによっては不要</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータが必須か否かを返す（共通の画面上に表示する／しないを決める）</para>
        /// </remarks>
        bool IsEssentialModelGenerationData();

    }
}
