﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリ基底クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;


namespace CommonMP.HYMCO.Interface.Model
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリ基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public abstract class McModelFactoryBase : HySFactoryMono , McModelFactory
    {
        /// <summary>モデル情報リスト </summary>
        protected HySDataLinkedList m_csCalModelInforList = new HySDataLinkedList();

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactoryBase csFact = new McModelFactoryBase( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelFactoryBase( )
        {
            this.SetFactoryID(this.CreateFactoryID());
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySID CreateFactoryID();

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McCalModel CreateCalModel(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            return CreateCalModel(csModelKind);
        }
         /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McCalModel CreateCalModel(HySObjectKind csModelKind);

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csLibraryID, csModelKind,csCalInfoID ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csCalInfoID">データID（ダミー)</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McCalInfo CreateCalInfo(HySID csLibraryID, HySObjectKind csModelKind, HySID csCalInfoID)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            return CreateCalInfo(csModelKind);
        }
        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McCalInfo CreateCalInfo(HySObjectKind csModelKind);

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McPropertyInfoRoot CreateModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind);
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind);


        /// <summary><para>method outline:</para>
        /// <para>伝送データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTranInfo = CreateTransData(csLibraryID, csTransDataKind, csPropertyInfo, csTransDataID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <param name="csPropertyInfo">伝送データプロパティ表示／設定情報クラス</param>
        /// <param name="csTransDataID">伝送データID</param>
        /// <returns>null</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo CreateTransData(HySID csLibraryID, HySObjectKind csTransDataKind, McPropertyInfoRoot csPropertyInfo, HySID csTransDataID)
        {
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateTranInfoPropertyInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>null</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreateTranInfoPropertyInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>伝送データ初期化設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateTranInfoInitialInfo(csLibraryID, csTransDataKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csTransDataKind">伝送データ種別識別子</param>
        /// <returns>null</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfoRoot CreateTranInfoInitialInfo(HySID csLibraryID, HySObjectKind csTransDataKind)
        {
            return null;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public abstract HySDataLinkedList GetCalModelInfoList();

        // ================= モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelNetworkGeneratorList()
        {
            // 親クラス側では何もしない事
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // 親クラス側では何もしない事
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // 親クラス側では何もしない事
            return null;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする独自データのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();
            return csRtnList;
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルジェネレータが必要とする必須のデータを提供するか？</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = IsEssentialModelGenerationData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:必須、=false:モデルによっては不要</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>親クラスは必ずfalse。特殊なファクトリのみfalse であり、通常のモデルがオーバーライドする必要はない</para>
        /// </remarks>
        public virtual bool IsEssentialModelGenerationData()
        { return false; }
    }
}
