// <summary>ソースコード：演算要素モデルネットワーク生成</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.Interface.Model
{  
    /// <summary><para>class outline:</para>
    /// <para>演算要素モデルネットワーク生成インターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    ///<para>remarks:</para>
    /// <para>
    /// 各モデル要素を組み合わせて、全体も出るを作成するクラスの例。
    /// 出力は構造定義ファイルに出力される。
    /// </para>
    /// </remarks>
    public interface McModelNetworkGenerator : McRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetID(HySIdentifier csID);
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySIdentifier GetID();
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool Equal(HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>生成モデルのリスト</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csElmList =  GetElementList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 生成されたモデルのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        HySDataLinkedList GetElementList();
        /// <summary><para>method outline:</para>
        /// <para>生成モデルのリストへの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddElement(csElmInf) </para>
        /// </example>
        /// <param name="csElmInf">生成されたモデル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void AddElement(HySDataRoot csElmInf);

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成前のチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CheckBefoModelGeneration(
        ///                       ref csMDGInfo)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 演算要素モデルネットワーク作成の前に、期待通りの情報が取得されているかをチェックする
        /// </para>
        /// </remarks>
        bool CheckBefoModelGeneration(ref McModelDataGenerationInfoIF csMDGInfo);

        /// <summary><para>method outline:</para>
        /// <para>演算システム全体を制御するプロパティ情報の生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateSystemPorperty(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する。
        /// 此処では,個別のモデルに対するプロパティではなく、全体を制御するプロパティ情報を生成する。
        ///   例：同期／非同期動作区分、部分系動作／収束演算区分　等
        /// </para>
        /// </remarks>
        HySXmlNode CreateSystemPorperty(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter);

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelNetworkData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する
        /// 個別の演算要素を組み合わせて（ネットワークを形成して）一つのモデルを構築する
        /// </para>
        /// </remarks>
        bool CreateModelNetworkData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent, 
                    ref HySXmlWriter csXmlWriter);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = BreakCreation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し </para>
        /// </remarks>
        void BreakCreation( );
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止フラグのリセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ResetBreakCreation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し </para>
        /// </remarks>
        void ResetBreakCreation();

        /// <summary><para>method outline:</para>
        /// <para>自ライブライ以外の演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateExternalModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 自ライブライ外（他のライブラリ）のモデルに対するパラメータ設定等を行いたい場合に使用する。
        /// 例えば、A氏が作成した演算要素を　自らのモデル内の構成要素として採用したい場合、そのパラメータを設定する為のクラスを自分で生成する。
        /// </para>
        /// </remarks>
        McModelParameterGenerator CreateExternalModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID);
    }
}
