// <summary>ソースコード：演算要素モデルネットワーク生成親クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


namespace CommonMP.HYMCO.Interface.Model
{
    /// <summary><para>class outline:</para>
    /// <para>演算要素モデルネットワーク生成親クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/01/01][新規作成]</para> 
    ///<para>remarks:</para>
    /// <para>
    /// 各モデル要素を組み合わせて、全体も出るを作成するクラスの例。
    /// 出力は構造定義ファイルに出力される。
    /// </para>
    /// </remarks>
    public abstract class McModelNetworkGeneratorBase : McModelNetworkGenerator
    {
        /// <summary>識別ＩＤ</summary>
        protected HySID m_csID;

        /// <summary>モデル要素リスト </summary>
        protected HySDataLinkedList m_csElementList = new HySDataLinkedList();
        /// <summary>モデル要素接続リスト </summary>
        protected HySDataLinkedList m_csConnectionList = new HySDataLinkedList();
        /// <summary>処理中断フラグ </summary>
        protected bool m_bBreakFlg = false;

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier csID)
        {
            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>生成モデルのリスト</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csElmList =  GetElementList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 生成されたモデルのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetElementList()
        { return m_csElementList; }
        /// <summary><para>method outline:</para>
        /// <para>生成モデルのリストへの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddElement(csElmInf) </para>
        /// </example>
        /// <param name="csElmInf">生成されたモデル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddElement(HySDataRoot csElmInf)
        {
            m_csElementList.AddLast(csElmInf);
        }

        /// <summary><para>method outline:</para>
        /// <para>接続情報のリスト</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataLinkedList csCnctList =  GetConnectionList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 接続情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetConnectionList()
        { return m_csConnectionList; }
        /// <summary><para>method outline:</para>
        /// <para>接続情報のリストへの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddConnection(csCnnctInf) </para>
        /// </example>
        /// <param name="csCnnctInf">生成されたモデル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddConnection(HySDataRoot csCnnctInf)
        {
            m_csConnectionList.AddLast(csCnnctInf);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成前のチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CheckBefoModelGeneration(
        ///                       ref csMDGInfo)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 演算要素モデルネットワーク作成の前に、期待通りの情報が取得されているかをチェックする
        /// </para>
        /// </remarks>
        public abstract bool CheckBefoModelGeneration(ref McModelDataGenerationInfoIF csMDGInfo);

        /// <summary><para>method outline:</para>
        /// <para>演算システム全体を制御するプロパティ情報の生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateSystemPorperty(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する。
        /// 此処では,個別のモデルに対するプロパティではなく、全体を制御するプロパティ情報を生成する。
        ///   例：同期／非同期動作区分、部分系動作／収束演算区分　等
        /// </para>
        /// </remarks>
        public abstract HySXmlNode CreateSystemPorperty(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter);

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelNetworkData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する。
        /// 個別の演算要素を組み合わせて（ネットワークを形成して）一つのモデルを構築する
        /// </para>
        /// </remarks>
        public virtual bool CreateModelNetworkData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = true;
            m_bBreakFlg = false;
            m_csElementList.Clear();
            m_csConnectionList.Clear();

            if (this.m_bBreakFlg == true) { return false; }
            // Componentsタグ
            HySXmlNode csCompornentNode = HySXmlNode.CreateElement(McDefine.xml_COMPONENT, csXmlWriter);
            if (this.CreateModels(ref csMDGInfo, ref csCompornentNode, ref csXmlWriter) == false)
            {
                if (this.m_bBreakFlg != true)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.TRIAL_RUN, this.ToString(), "CreateModels", 
                        Properties.HymcoIFResources.STATEMENT_MODEL_GEN_ERR );
                   // HySLog.LogOut(HySLog.TRIAL_RUN, this.ToString(), "CreateModels", " ModelGeneration Error.");
                }
                bRtn = false; 
            }
            csXmlParent.AppendChild(csCompornentNode);

            if (this.m_bBreakFlg == true) { return false; }
            // Wirringタグ
            HySXmlNode csWirringNode = HySXmlNode.CreateElement(McDefine.xml_WIRRING, csXmlWriter);
            if (this.CreateModelConnection(ref csMDGInfo, ref csWirringNode, ref csXmlWriter) == false)
            {
                if (this.m_bBreakFlg != true)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.TRIAL_RUN, this.ToString(), "CreateModelConnection", 
                        Properties.HymcoIFResources.STATEMENT_MODEL_WRT_ERR );
                   // HySLog.LogOut(HySLog.TRIAL_RUN, this.ToString(), "CreateModelConnection", " ModelWirring Error.");
                }
                bRtn = false;
            }        
            csXmlParent.AppendChild(csWirringNode);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素／接続線生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModels(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する
        /// </para>
        /// </remarks>
        public abstract bool CreateModels(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter);

        /// <summary><para>method outline:</para>
        /// <para>モデル間接続情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelConnection(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する
        /// </para>
        /// </remarks>
        public virtual bool CreateModelConnection(
            ref McModelDataGenerationInfoIF csMDGInfo,
            ref  HySXmlNode csXmlParent,
            ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = true;
            ConnectionTagInf csCnctInf=null;
            ConnectionPropertyInf csCnctPrptyInf=null;
            HySXmlNode csCnctNode = null;
            HySXmlNode csCnctPrptyNode = null;
            long lCnctCnt = m_csConnectionList.GetCount();
            m_csConnectionList.SetCursorFirst();
            for (long lCnct = 0; lCnct < lCnctCnt; lCnct++)
            {   // 接続数繰り返す
                
                if (this.m_bBreakFlg == true) { return false; }

                csCnctInf = m_csConnectionList.GetCursorData() as ConnectionTagInf;
                if (csCnctInf != null)
                {
                    // 接続タグ生成
                    csCnctNode = this.CreateConnectionTag(csCnctInf, ref csXmlWriter);
                    // プロパティタグ設定
                    csCnctPrptyInf = csCnctInf.m_csPrptyInf;
                    if (csCnctPrptyInf != null)
                    { // プロパティ情報有り
                        csCnctPrptyNode = this.CreateConnectionPropertyTag(csCnctPrptyInf, ref csXmlWriter);
                        csCnctNode.AppendChild(csCnctPrptyNode);
                    }
                    else
                    {
                        //bRtn = false;
                    }

                    csXmlParent.AppendChild(csCnctNode);
                }

                m_csConnectionList.MoveCursorNext();
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = BreakCreation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し </para>
        /// </remarks>
        public virtual void BreakCreation( )
        {
            m_bBreakFlg = true;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成中止フラグのリセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = ResetBreakCreation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し </para>
        /// </remarks>
        public virtual void ResetBreakCreation()
        {
            m_bBreakFlg = false;
        }
        /// <summary><para>method outline:</para>
        /// <para>自ライブライ以外の演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateExternalModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 自ライブライ外（他のライブラリ）のモデルに対するパラメータ設定等を行いたい場合に使用する
        /// 例えば、A氏が作成した演算要素を　自らのモデル内の構成要素として採用したい場合、そのパラメータを設定する為のクラスを自分で生成する。
        /// </para>
        /// </remarks>
        public virtual McModelParameterGenerator CreateExternalModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            // 親クラス側では何もしない事
            return null;
        }

        // ===========================================
        // 個別タブ生成ツールメソッド
        // ===========================================
        
        /// <summary><para>method outline:</para>
        /// <para>構造定義　要素モデルタグ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = CreateElementTag( csElmInf, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csElmInf">要素タグ生成必要情報</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode CreateElementTag(
            McElementTagInf csElmInf,
            ref HySXmlWriter csXmlWriter
            )
        {
            HySXmlNode csRtnNode = csXmlWriter.CreateElement(McDefine.xml_CALELEMENT);
            csRtnNode.SetAttribute(McDefine.xml_ID, csElmInf.m_csElementID.ToString());
            csRtnNode.SetAttribute(McDefine.xml_MODEL, csElmInf.m_csModelKind.ToString());
            csRtnNode.SetAttribute(McDefine.xml_FACTORYID, csElmInf.m_csLibraryID.ToString());
            if (csElmInf.m_csDrawSubKind != null)
            {
                csRtnNode.SetAttribute(McDefine.xml_KIND, csElmInf.m_csDrawSubKind.ToString());
            }
            csRtnNode.SetAttribute(McDefine.xml_X, csElmInf.m_lX.ToString());
            csRtnNode.SetAttribute(McDefine.xml_Y, csElmInf.m_lY.ToString());
            if ((object)csElmInf.m_sElementName != null)
            {
                csRtnNode.SetAttribute(McDefine.xml_ElementName, csElmInf.m_sElementName.ToString());
            }
            HySXmlNode csPortNode = csXmlWriter.CreateElement(McDefine.xml_PORT);
            csRtnNode.AppendChild(csPortNode);
            // 下記の様なタグが生成される
            // <CalElement ID="E512-1520-9112009" Model="KinematicWave_Sample" FactoryID="Example.ModelSample.Fctry" X="-223" Y="-27" >
            //    <Ports>
            //    </Ports>
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>構造定義　端子モデルタグ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = AddPortTag( ref csElmXmlNode, csPortInf, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csElmXmlNode">要素タグXML</param>
        /// <param name="csPortInf">端子タグ生成必要情報</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bRtn true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool AddPortTag(
                    ref HySXmlNode  csElmXmlNode,
                    McPortTagInf csPortInf,
                    ref HySXmlWriter csXmlWriter
            )
        {
            bool bRtn = false;
            HySXmlNodeList csPortNodeList = csElmXmlNode.GetChildNodeList();
            if (csPortNodeList != null)
            {   // タグ<Port> を探す
                HySXmlNode csPortNode = csPortNodeList.GetNode(0);
                if (csPortNode != null)
                {   // タグ<Port> があれば

                    // 追加する端子のタグを生成
                    HySXmlNode csAddPortNode = CreatePortTag(csPortInf, ref csXmlWriter);
                    if (csAddPortNode != null)
                    {
                        // 端子タグを追加
                        csPortNode.AppendChild(csAddPortNode);
                        bRtn = true;
                    }
                }
            }
            return bRtn;
        }

        // 端子関係タグ生成
        /// <summary><para>method outline:</para>
        /// <para>構造定義　端子タグ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = CreatePortTag( csPortInf, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csPortInf">端子タグ生成必要情報</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual HySXmlNode CreatePortTag(
            McPortTagInf csPortInf,
            ref HySXmlWriter csXmlWriter
            )
        {
            HySXmlNode csRtnNode = null;
            if (csPortInf.m_eSndRcv == McPortTagInf.SendReceive.RECEIVE)
            {
                csRtnNode = csXmlWriter.CreateElement(McDefine.xml_RECEIVE_PORT);
            }
            else
            {
                csRtnNode = csXmlWriter.CreateElement(McDefine.xml_SEND_PORT);
            }
            csRtnNode.SetAttribute(McDefine.xml_ID, csPortInf.m_csID.ToString());
            // 下記の様なタグが生成される
            //  <SendPort ID="P412-5520-9200911"   />
            return csRtnNode;
        }

        // 接続線関係タグ生成
        /// <summary><para>method outline:</para>
        /// <para>構造定義　接続タグ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = CreateConnectionTag( csCnctInf, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csCnctInf">接続タグ生成必要情報</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode CreateConnectionTag(
            ConnectionTagInf csCnctInf,
            ref HySXmlWriter csXmlWriter
            )
        {
            HySXmlNode csRtnNode = csXmlWriter.CreateElement(McDefine.xml_CONNECTION);
            csRtnNode.SetAttribute(McDefine.xml_ID, csCnctInf.m_csConnectionID.ToString());
            csRtnNode.SetAttribute(McDefine.xml_FROM, csCnctInf.m_csFromPortID.ToString());
            csRtnNode.SetAttribute(McDefine.xml_TO, csCnctInf.m_csToPortID.ToString());
            csRtnNode.SetAttribute(McDefine.xml_TRANINFO, csCnctInf.m_csTranInfoKind.ToString());
            csRtnNode.SetAttribute(McDefine.xml_FACTORYID, csCnctInf.m_csLibraryID.ToString());
            if ((object)csCnctInf.m_csConnectionName != null)
            {
                csRtnNode.SetAttribute(McDefine.xml_NAME, csCnctInf.m_csConnectionName.ToString());
            }
            
            // 下記の様なタグが生成される
            //     <Connection ID="C233-84010-12102009" From="P433-54010-12200910" To="P533-44010-12200910" TranInfo="McTimeSeriesD1CellArrayTranInfo" FactoryID="McSystemModelFactory" >
            
            return csRtnNode;
        }
        // 接続線プロパティタグ生成
        /// <summary><para>method outline:</para>
        /// <para>構造定義　接続プロパティ　タグ生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = CreateConnectionPropertyTag( csCnctPrptyInf, ref csXmlWriter )</para>
        /// </example>
        /// <param name="csCnctPrptyInf">接続プロパティタグ生成必要情報</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode CreateConnectionPropertyTag(
            ConnectionPropertyInf csCnctPrptyInf,
            ref HySXmlWriter csXmlWriter
            )
        {
            HySXmlNode csRtnNode = csXmlWriter.CreateElement(McDefine.xml_PROPERTY);

            // レコード最大値
            HySXmlNode csNode = csXmlWriter.CreateElement(McDefine.xml_VARIABLE);
            csNode.SetAttribute(McDefine.xml_KEY, "MaxRecordDataNum");
            csNode.SetAttribute(McDefine.xml_NAME, "最大レコード数");
            csNode.SetAttribute(McDefine.xml_DATATYPE, "LONG");
            csNode.SetAttribute(McDefine.xml_VALUE, csCnctPrptyInf.m_lMaxRecord.ToString());
            csRtnNode.AppendChild(csNode);
            // 配列設定
            if (csCnctPrptyInf.m_lDim1 > 0)
            {
                csNode = csXmlWriter.CreateElement(McDefine.xml_VARIABLE);
                csNode.SetAttribute(McDefine.xml_KEY, "Dim1");
                csNode.SetAttribute(McDefine.xml_NAME, "最大レコード数");
                csNode.SetAttribute(McDefine.xml_DATATYPE, "LONG");
                csNode.SetAttribute(McDefine.xml_VALUE, csCnctPrptyInf.m_lDim1.ToString());
                csRtnNode.AppendChild(csNode);
            }
            if (csCnctPrptyInf.m_lDim2 > 0)
            {
                csNode = csXmlWriter.CreateElement(McDefine.xml_VARIABLE);
                csNode.SetAttribute(McDefine.xml_KEY, "Dim2");
                csNode.SetAttribute(McDefine.xml_NAME, "最大レコード数");
                csNode.SetAttribute(McDefine.xml_DATATYPE, "LONG");
                csNode.SetAttribute(McDefine.xml_VALUE, csCnctPrptyInf.m_lDim2.ToString());
                csRtnNode.AppendChild(csNode);
            }
            if (csCnctPrptyInf.m_lDim3 > 0)
            {
                csNode = csXmlWriter.CreateElement(McDefine.xml_VARIABLE);
                csNode.SetAttribute(McDefine.xml_KEY, "Dim3");
                csNode.SetAttribute(McDefine.xml_NAME, "最大レコード数");
                csNode.SetAttribute(McDefine.xml_DATATYPE, "LONG");
                csNode.SetAttribute(McDefine.xml_VALUE, csCnctPrptyInf.m_lDim3.ToString());
                csRtnNode.AppendChild(csNode);
            }
            // 送信パターン
            csNode = csXmlWriter.CreateElement(McDefine.xml_SEND_ELM_PATTERN);
            csNode.SetAttribute(McDefine.xml_PATTERN_ID, csCnctPrptyInf.m_csSndPtnID.ToString());
            csRtnNode.AppendChild(csNode);
            // 受信パターン
            csNode = csXmlWriter.CreateElement(McDefine.xml_RECV_ELM_PATTERN);
            csNode.SetAttribute(McDefine.xml_PATTERN_ID, csCnctPrptyInf.m_csRcvPtnID.ToString());
            csRtnNode.AppendChild(csNode);

            // 内挿情報設定
            csNode = csXmlWriter.CreateElement(McDefine.xml_INTERPOLATETYPE);
            if( csCnctPrptyInf.m_eInterpltTyp == HySDefine.InterpolateType.LINEAR )
            {   // 線形補間ならば
                csNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sLINEAR_INTERPOLATE);
            }
            else if (csCnctPrptyInf.m_eInterpltTyp == HySDefine.InterpolateType.GET_NEXT_DATA)
            {   // 直後値取得ならば
                csNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sGET_NEXT_DATA_INTERPOLATE);
            }
            else
            {   // なにもしない（直近値取得）
                csNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sNO_INTERPOLATE);
            }
            csRtnNode.AppendChild(csNode);

            // 接続設定
            csNode = csCnctPrptyInf.m_csCellGetter.XmlOUT(ref csXmlWriter);
            csRtnNode.AppendChild(csNode);

            // セル識別子とセルの配列管理データ
            if ((object)csCnctPrptyInf.m_csCellIDMngInfFile != null)
            {
                csNode = csXmlWriter.CreateElement(McDefine.xml_CELL_ID_MNG_FILE);
                csNode.SetAttribute(McDefine.xml_NAME, csCnctPrptyInf.m_csCellIDMngInfFile.ToString());
                csNode.SetAttribute(McDefine.xml_MODELKIND, "McModelCellCorrespondenceInf");
                csRtnNode.AppendChild(csNode);
            }

            //   下記の様なタグが生成される
            //      <Property>
            //        <Variable Key="MaxRecordDataNum" Name="最大レコード数" DataType="LONG" Value="96" />
            //        <Variable Key="Dim1" Name="セル配列数" DataType="LONG" Value="51" />
            //        <SendElementOutPattern PatternID="AllCellOut" />
            //        <ReceiveElementInPattern PatternID="ANY" />
            //        <InterpolateType Kind="LINEAR" />
            //        <CellDataGetter>
            //          <Index Order="0" Value="0" />
            //          <CellData>
            //            <Index Order="0" Value="0" />
            //            <Index Order="1" Value="0" />
            //          </CellData>
            //        </CellDataGetter>
            //        <CellIDMngFile Name="SampleRightSideIn.xml" Kind="McModelCellCorrespondenceInf" />
            //      </Property>
            //        

            return csRtnNode;
        }
        // ======================================
        //    関連情報定義クラス
        // ======================================
        /// <summary><para>class outline:</para>
        /// <para>要素タグ生成必要情報</para>
        /// </summary>
        /// <remarks>
        /// <para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/17][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class McElementTagInf : HySDataRoot
        {
            /// <summary>要素識別子</summary>
            internal HySID m_csElementID = null;
            /// <summary>モデル/伝送データの種別（必須）</summary>
            internal HySObjectKind m_csModelKind = null;
            /// <summary>ライブラリ識別子（必須）</summary>
            internal HySID m_csLibraryID = null;
            /// <summary>描画位置(X)</summary>
            internal long m_lX = 10;
            /// <summary>描画位置(Y)</summary>
            internal long m_lY = 10;
            /// <summary>要素名称</summary>
            internal HySString m_sElementName = null;
            /// <summary>描画オブジェクト区分</summary>
            internal HySObjectKind m_csDrawSubKind = null;

            /// <summary>
            /// 使用禁止
            /// </summary>
            private McElementTagInf()
            {
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McElementTagInf csElmInf = new McElementTagInf(csElementID, csModelKind, csLibraryID, lX, lY) </para>
            /// </example>
            /// <param name="csElementID">要素ＩＤ</param>
            /// <param name="csModelKind">モデル種別</param>
            /// <param name="csLibraryID">ライブラリー識別子</param>
            /// <param name="lX">モデル配置位置：Ｘ座標</param>
            /// <param name="lY">モデル配置位置：Ｙ座標</param>
            /// <returns>エレメントタグ情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McElementTagInf(
                 HySID csElementID,
                 HySObjectKind csModelKind,
                 HySID csLibraryID,
                 long lX,
                 long lY
                     )
            {
                m_csElementID = csElementID.Clone();
                m_csModelKind = csModelKind.Clone();
                m_csLibraryID = csLibraryID.Clone();
                m_lX = lX;
                m_lY = lY;
            }
            /// <summary><para>method outline:</para>
            /// <para>シンボル描画種別設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>SetElementShape(eKind)</para>
            /// </example>
            /// <param name="eKind">
            /// シンボル描画種別（例：McDefine.HYM_DRAW_SUB_KIND_BASIN）
            /// </param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual void SetElementShape(HySObjectKind eKind)
            {
                m_csDrawSubKind = eKind.Clone();
            }
            /// <summary><para>method outline:</para>
            /// <para>要素名称設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>SetElementName(csElementName)</para>
            /// </example>
            /// <param name="csElementName">要素名称</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual void SetElementName(HySString csElementName)
            {
                m_sElementName = csElementName.Clone();
            }
            /// <summary><para>method outline:</para>
            /// <para>要素識別子取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySID csID = GetElmenetID( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>要素識別子</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySID GetElmenetID()
            { return m_csElementID; }
            /// <summary><para>method outline:</para>
            /// <para>ライブラリ識別子取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySID csID = GetLibID( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>ライブラリ識別子</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySID GetLibID()
            { return m_csLibraryID; }
            /// <summary><para>method outline:</para>
            /// <para>ジェネレーター種別取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySObjectKind csKind = GetMdlKind( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>ジェネレーター種別</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySObjectKind GetMdlKind()
            { return m_csModelKind; }
        }
        /// <summary><para>class outline:</para>
        /// <para>端子タグ生成必要情報</para>
        /// </summary>
        /// <remarks>
        /// <para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/17][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class McPortTagInf : HySDataRoot
        {
            /// <summary>端子識別子</summary>
            internal HySID m_csID = null;
            /// <summary>送受信区分</summary>
            public enum SendReceive
            {
                /// <summary>送信端子</summary>
                SEND = 1,
                /// <summary>受信端子</summary>
                RECEIVE
            }
            /// <summary>送受信区分</summary>
            internal SendReceive m_eSndRcv = SendReceive.RECEIVE;
            /// <summary>
            /// 使用禁止
            /// </summary>
            private McPortTagInf()
            {
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> McPortTagInf csPortInf = new McPortTagInf(eSndRcv, csPortID) </para>
            /// </example>
            /// <param name="eSndRcv">送受信区分</param>
            /// <param name="csPortID">端子ＩＤ</param>
            /// <returns>端子タグ情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public McPortTagInf(
                SendReceive eSndRcv,
                 HySID csPortID
                     )
            {
                m_csID = csPortID;
                m_eSndRcv = eSndRcv;
            }
            /// <summary><para>method outline:</para>
            /// <para>端子識別子取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySID csID = GetPortID( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>要素識別子</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySID GetPortID()
            { return m_csID; }
        }
        /// <summary><para>class outline:</para>
        /// <para>接続タグ生成必要情報</para>
        /// </summary>
        /// <remarks>
        /// <para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/17][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class ConnectionTagInf : HySDataRoot
        {
            /// <summary>接続識別子</summary>
            internal HySID m_csConnectionID = null;
            /// <summary>送信側端子識別子</summary>
            internal HySID m_csFromPortID = null;
            /// <summary>受信側端子識別子</summary>
            internal HySID m_csToPortID = null;
            /// <summary>伝送データの種別</summary>
            internal HySObjectKind m_csTranInfoKind = null;
            /// <summary>伝送データ生成ライブラリ識別子</summary>
            internal HySID m_csLibraryID = null;
            /// <summary>要素名称</summary>
            internal HySString m_csConnectionName = null;
            /// <summary>接続線プロパティ情報</summary>
            internal ConnectionPropertyInf m_csPrptyInf = null;

            /// <summary>
            /// 使用禁止
            /// </summary>
            private ConnectionTagInf()
            {
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> ConnectionTagInf csCnctInf = new ConnectionTagInf(csConnectionID,csFromPortID,m_csToPortID, m_csTranInfoKind, csLibraryID,csPrptyInf) </para>
            /// </example>
            /// <param name="csConnectionID">接続線ＩＤ</param>
            /// <param name="csFromPortID">送信側端子ＩＤ</param>
            /// <param name="csToPortID">受信側端子ＩＤ</param>    
            /// <param name="csTranInfoKind">伝送データ種別</param>
            /// <param name="csLibraryID">ライブラリー識別子</param>
            /// <param name="csPrptyInf">プロパティ情報</param>
            /// <returns>エレメントタグ情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public ConnectionTagInf(
                 HySID csConnectionID,
                 HySID csFromPortID,
                 HySID csToPortID,
                 HySObjectKind csTranInfoKind,
                 HySID csLibraryID,
                 ConnectionPropertyInf csPrptyInf
                     )
            {
                m_csConnectionID = csConnectionID.Clone();
                m_csFromPortID = csFromPortID.Clone();
                m_csToPortID = csToPortID.Clone();
                m_csTranInfoKind = csTranInfoKind.Clone();
                m_csLibraryID = csLibraryID.Clone();
                m_csPrptyInf = csPrptyInf;
            }

            /// <summary><para>method outline:</para>
            /// <para>接続線名称設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>SetConnectionName(csConnectionName)</para>
            /// </example>
            /// <param name="csConnectionName">接続線名称</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual void SetConnectionName(HySString csConnectionName)
            {
                m_csConnectionName = csConnectionName.Clone();
            }
        }
        /// <summary><para>class outline:</para>
        /// <para>接続プロパティ生成必要情報</para>
        /// </summary>
        /// <remarks>
        /// <para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2009/12/17][新規作成]</para>
        /// </remarks>
        [Serializable]
        public class ConnectionPropertyInf : HySDataRoot
        {

            /// <summary> セル接続情報</summary>
            internal HySCellDataGetter m_csCellGetter = null;
            /// <summary>送信側パターン識別子</summary>
            internal HySID m_csSndPtnID = null;
            /// <summary>受信側パターン識別子</summary>
            internal HySID m_csRcvPtnID = null;
            /// <summary>内挿処理区分</summary>
            internal HySDefine.InterpolateType m_eInterpltTyp;
            /// <summary>最大レコード数</summary>
            internal long m_lMaxRecord = 16;
            /// <summary>配列数</summary>
            internal long m_lDim1 = 1;
            /// <summary>配列数</summary>
            internal long m_lDim2 = 0;
            /// <summary>配列数</summary>
            internal long m_lDim3 = 0;

            //// <summary>セル識別子とセルの配列管理データ</summary>
            //internal McCellIDMngIF m_csCellMngData = null;
            /// <summary>セル識別子とセルの配列管理データファイル</summary>
            internal HySString m_csCellIDMngInfFile = null;

            /// <summary>
            /// 使用禁止
            /// </summary>
            private ConnectionPropertyInf()
            {
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> ConnectionPropertyInf csCnctInf = new ConnectionPropertyInf(
            /// csCellGetter,csSndPtnID,csRcvPtnID, eInterpltTyp, lMaxRecord,lDim1,lDim2,lDim3)
            /// </para>
            /// </example>
            /// <param name="csCellGetter">配線情報</param>
            /// <param name="csSndPtnID">上流モデルの送信パターンＩＤ</param>
            /// <param name="csRcvPtnID">下流モデルの受信パターンＩＤ</param>    
            /// <param name="eInterpltTyp">内挿処理種別</param>
            /// <param name="lMaxRecord">伝送情報上の最大レコード保持数</param>
            /// <param name="lDim1">セル配列数（１次側）</param>
            /// <param name="lDim2">セル配列数（２次側）</param>
            /// <param name="lDim3">セル配列数（３次側）</param>
            /// <returns>エレメントタグ情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public ConnectionPropertyInf(
                HySCellDataGetter csCellGetter,
                HySID csSndPtnID,
                HySID csRcvPtnID,
                HySDefine.InterpolateType eInterpltTyp,
                long lMaxRecord,
                long lDim1,
                long lDim2,
                long lDim3
                     )
            {
                m_csCellGetter = csCellGetter;
                m_csSndPtnID = csSndPtnID;
                m_csRcvPtnID = csRcvPtnID;
                m_eInterpltTyp = eInterpltTyp;
                m_lMaxRecord = lMaxRecord;
                m_lDim1 = lDim1;
                m_lDim2 = lDim2;
                m_lDim3 = lDim3;
            }
            /// <summary><para>method outline:</para>
            /// <para>セル識別子とセルの配列管理データ設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>SetCellIDMngFileName(csCellIDMngInfFile)</para>
            /// </example>
            /// <param name="csCellIDMngInfFile">セル識別子とセルの配列管理データを定義したファイル</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public virtual void SetCellIDMngFileName(HySString csCellIDMngInfFile)
            {
                m_csCellIDMngInfFile = csCellIDMngInfFile;
            }
        }
        //
    }

}
