// <summary>ソースコード：演算モデル用パラメータ等情報生成親クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


namespace CommonMP.HYMCO.Interface.Model
{
    /// <summary><para>class outline:</para>
    /// <para>演算モデル用パラメータ等情報生成親クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public abstract class McModelParameterGeneratorBase : McModelParameterGenerator
    {
        /// <summary>識別ＩＤ</summary>
        protected HySID m_csID;

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( csID ) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier csID)
        {
            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelPropertyData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csPropertyInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csPropertyInfoParent">親XMLノードクラス（プロパティ情報用）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義プロパティファイルへ情報を設定する
        /// </para>
        /// </remarks>
        public virtual bool CreateModelPropertyData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csPropertyInfoParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = true;
            // ①エレメントタグXML作成
            HySXmlNode csCalMdlNode = csXmlWriter.CreateElement(McDefine.xml_CALELEMENT);
            csCalMdlNode.SetAttribute(McDefine.xml_ID, m_csID.ToString());


            HySXmlNode csPropertyNode = csXmlWriter.CreateElement(McDefine.xml_PROPERTY);
            //<Property>

            // ②独自プロパティ情報作成
            bool bLclRtn = CreateModelPropertyDetailData(ref csMDGInfo, ref csPropertyNode, ref csXmlWriter);
            if (bLclRtn == true)
            {
                HySXmlNodeList csPrptyList = csPropertyNode.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                if (csPrptyList.GetCount() == 0)
                {
                    csCalMdlNode.AppendChild(csPropertyNode);
                    csPropertyInfoParent.AppendChild(csCalMdlNode);
                }
                else
                {
                    bRtn = CreateModelPropertyDetailData(ref csMDGInfo, ref csCalMdlNode, ref csXmlWriter);
                }
            }
            else
            {
                bRtn = false;
            }
            //<CalElement ID="E717-1520-9112009">
            csPropertyInfoParent.AppendChild(csCalMdlNode);

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateInitialData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csInitialInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csInitialInfoParent">親XMLノードクラス（初期化情報）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義初期化情報を設定する
        /// </para>
        /// </remarks>
        public virtual bool CreateInitialData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csInitialInfoParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = true;
            // ①エレメントタグXML作成
            //<CalElement ID="E717-1520-9112009">
            HySXmlNode csCalMdlNode = csXmlWriter.CreateElement(McDefine.xml_CALELEMENT);
            csCalMdlNode.SetAttribute(McDefine.xml_ID, m_csID.ToString());

            // ②初期化情報関連XML作成
            HySXmlNode csInitialNode = csXmlWriter.CreateElement(McDefine.xml_INITIAL_SET);
            //<InitialSet>

            // 独自設定情報作成
            bool bLclRtn = CreateInitialDetailData(ref csMDGInfo, ref csInitialNode, ref csXmlWriter);//, ref  csNode);
            if (bLclRtn == true)
            {
                HySXmlNodeList csInitialNodeList = csInitialNode.GetChildNodeListByTagName(McDefine.xml_INITIAL_SET);
                if (csInitialNodeList.GetCount() == 0)
                {
                    csCalMdlNode.AppendChild(csInitialNode);
                    csInitialInfoParent.AppendChild(csCalMdlNode);
                }
                else
                {
                    bRtn = CreateInitialDetailData(ref csMDGInfo, ref csCalMdlNode, ref csXmlWriter);//, ref  csNode);
                }
            }
            else
            {
                bRtn = false;
            }

            csInitialInfoParent.AppendChild(csCalMdlNode);
            return bRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csPropertyInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csPropertyInfoParent">親XMLノードクラス（プロパティ情報用）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義プロパティファイルへ情報を設定する
        /// </para>
        /// </remarks>
        protected abstract bool CreateModelPropertyDetailData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csPropertyInfoParent,
                    ref HySXmlWriter csXmlWriter);

        /// <summary><para>method outline:</para>
        /// <para>初期化情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateInitialData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csInitialInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csInitialInfoParent">親XMLノードクラス（初期化情報）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義初期化情報を設定する
        /// </para>
        /// </remarks>
        protected abstract bool CreateInitialDetailData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csInitialInfoParent,
                    ref HySXmlWriter csXmlWriter);
            
    }
}
