﻿// <summary>ソースコード：ＨＹＭＣＯモデルプロパティ画面クラスＩ／Ｆ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYMCO.Interface.Viewer
{
    /// <summary><para>class outline:</para>
    /// <para>モデルプロパティ画面クラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/16][新規作成]</para>
    /// </remarks>
    public interface McModelPropertyFormIF
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定内容チェック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ParaSet_Check();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>false : 正常、true : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool ParaSet_Check();

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定変更チェック・設定反映処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bModifyFlg = ParaModify_Check(bSetFlg ref bChangeFlg1, ref bChangeFlg2);</para>
        /// </example>
        /// <param name="bSetFlg">反映フラグ（true:変更チェック＆設定反映　false:変更チェックのみ）</param>
        /// <param name="bChangeFlg1">変更タイプ１（シミュレーションモデル再構築不要）</param>
        /// <param name="bChangeFlg2">変更タイプ２（シミュレーションモデル再構築要）</param>
        /// <returns>false : 変更無し、true : 変更有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool ParaModify_Check(bool bSetFlg, ref bool bChangeFlg1, ref bool bChangeFlg2);
    }
}
