﻿

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.Interface.Viewer
{
    /// <summary><para>class outline:</para>
    /// <para>モデルプロパティ表示スクリーンクラスＩ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public interface McModelPropertyScreen : HySScreen
    {
        ///// <summary><para>method outline:</para>
        ///// <para>識別子比較</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> csMcElement.Equal( csID ) </para>
        ///// </example>
        ///// <param name="csID">比較する種別識別子</param>
        ///// <returns>  true :＝ , false:≠</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //bool Equal(HySID csID);

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ情報インスタンスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelPropertyInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデルプロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetModelPropertyInfo(McPropertyInfoRoot csInfo);

        /// <summary><para>method outline:</para>
        /// <para>モデル初期情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelInitialInfo(csInfo)</para>
        /// </example>
        /// <param name="csInfo">モデル初期情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetModelInitialInfo(McPropertyInfoRoot csInfo);

        /// <summary><para>method outline:</para>
        /// <para>要素データＩＤを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementDataID(csID)</para>
        /// </example>
        /// <param name="csID">要素データＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetElementDataID(HySID csID);

        /// <summary><para>method outline:</para>
        /// <para>要素名称を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElementName(csElementName)</para>
        /// </example>
        /// <param name="csElementName">要素名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetElementName(HySString csElementName);

        ///// <summary><para>method outline:</para>
        ///// <para>要素名称を取得する</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>HySString csElementName = GetElementName()</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>要素名称</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //HySString GetElementName();

        /// <summary><para>method outline:</para>
        /// <para>モデル管理画面設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelCtlScreen( csScreen ) </para>
        /// </example>
        /// <param name="csScreen">モデル管理画面</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetModelCtlScreen(HySScreen csScreen);

        /// <summary><para>method outline:</para>
        /// <para>画面消去報告</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClosedForm( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void ClosedForm();
    }
}
