﻿// <summary>ソースコード：ＨＹＭＣＯプロパティスクリーンファクトリ集合体抽象クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Viewer;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public interface PROPERTY_SCREEN_FACTORY_CREATOR : McRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        McPropertyScreenFactoryBase CreateFactory();
    }
}

namespace CommonMP.HYMCO.Interface.Viewer
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO用 プロパティスクリーンファクトリ抽象クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    abstract public class McPropertyScreenFactoryBase : HySFactoryMono, HySScreenFactory //HySFactorySet, HySScreenFactory
    {
        /// <summary> 業務種別識別子  </summary>
        protected HySKind m_csSimKind = McDefine.SIMULATOR_KIND;
             
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McScreenFactoryBase csFctry = new McScreenFactoryBase()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyScreenFactoryBase()
        {
            m_csDataID = this.CreateFactoryID();
        }
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySID CreateFactoryID();

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            //m_csSimKind = csSimKindID;
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csElmID,csModelKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csElmID">モデル要素識別子</param>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>プロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csElmID, HySKind csModelKind)
        {
            HySScreen csRtnScreen = this.CreatePropertyScreen(csModelKind);
            if (csRtnScreen != null)
            {
                csRtnScreen.SetSimKind(csSimulatorKind);    // 種別識別子設定
                csRtnScreen.SetID(csElmID);           // データ識別子設定
            }
            //else
            //{
            //    //csRtnScreen = this.CreateModelDataGeneratorScreen(csModelKind);
            //    //if (csRtnScreen != null)
            //    //{
            //    //    csRtnScreen.SetSimKind(csSimulatorKind);
            //    //}
            //}

            return csRtnScreen;
        }
               
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind);

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ================= start of モデルデータ半自動作成ツール用メソッド ============================
        // モデルデータ半自動作成ツール（モデルジェネレーター）を作成する開発者は下記メソッド群を
        // オーバーライド実装して下さい。

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報リスト提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルジェネレーター固有画面情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorScreenList()
        {
            // 親クラスは何もしない
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlGen = CreateModelDataGeneratorScreen(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelDataGeneratorScreen CreateModelDataGeneratorScreen(HySKind csModelKind)
        {
            // 親クラスは何もしない
            return null;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル固有のモデルジェネレータ用必要情報選択画面スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelGeneratorDataSelectScreen csMdlGen = CreateModelDataGeneratorSelectScreen(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelGeneratorDataSelectScreen モデル固有のモデルジェネレータ用必要情報選択画面スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデルジェネレータが必要とする情報を選択する画面
        /// CommonMPシステムが提供する汎用画面では、機能不足の場合本メソッドをオーバーライドして固有の画面を作成する</para>
        /// </remarks>
        public virtual McModelGeneratorDataSelectScreen CreateModelDataGeneratorSelectScreen(HySKind csModelKind)
        {
            // 親クラスは何もしない
            return null;
        }


        // ================= end  of モデルデータ半自動作成ツール用メソッド ============================
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    }
}
