﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary>
    /// 日本社会
    /// </summary>
    [Serializable]
    public class MzEcJapanSocietyCalInfo : MzCashflowModelElementCalInfo
    {
        //------------ CO2排出権売買用 ------------------
        /// <summary> 手持ちのCO2排出権量  [ｔ] </summary>
        public double m_CO2_Emission_Credit = 0;
        /// <summary>CO2排出権単位価格 　　万円/ton  </summary>
        public double m_CO2_Emission_Credit_UnitCost = 100;
        /// <summary> CO2排出権 売買用キャッシュ 億円 </summary>
        public double m_CO2_Credit_DealingChash = 0;
        /// <summary> CO2排出権 発注用用キャッシュ 億円 </summary>
        public double m_CO2_Credit_NextChash = 0;
        /// <summary> CO2排出権：供給能力 　　億円 </summary>
        public double m_CO2_Emission_Capability = 0;

        //------------ バイオ燃料：物品売買用 ------------------
        /// <summary>バイオ燃料：次回購入予定額 　　億円 </summary>
        public double m_d2ndFuelNextDealingChash = 0;
        /// <summary> バイオ燃料の量  [ｔ] 生産したもの:売るもの</summary>
        public double m_d2ndFuelStock = 0;
        /// <summary>バイオ燃料：購買用意金 　　億円 </summary>
        public double m_d2ndFuelDealingChash = 0;
        /// <summary>バイオ燃料：小売り価格 　　万円／小売り単位 </summary>
        public double m_d2ndFuelUnitCost = 150.0 * 1000.0 / 10000.0;
        /// <summary> バイオ燃料：供給能力 　　億円 </summary>
        public double m_d2ndFuelFeedCapability = 0;

        //------------ 魚食品：物品売買用 ------------------
        /// <summary> 購入魚食品：  [ｔ]  製品を生産するために使用するもの</summary>
        public double m_dFishFoods = 0;
        /// <summary> 購入魚食品：単価</summary>
        public double m_dFishFoodUnitCost = 1500;
        /// <summary>魚食品：次回購入予定額 　　億円 </summary>
        public double m_dFishFoodNextDealingChash = 0;
        /// <summary>魚食品：購買用意金 　　億円 </summary>
        public double m_dFishFoodDealingChash = 0;
        /// <summary> 魚食品：供給能力 　　億円 </summary>
        public double m_dFishFeedCapability = 0;

        //------------ 納税用 ------------------
        /// <summary> 納収入額 億円 </summary>
        public double m_TaxIncom = 0;
        /// <summary> 次回納税申告額 億円 </summary>
        public double m_TaxDeclaration = 0;
        /// <summary> 利益申告　億円 </summary>
        public double m_Tax_Capability = 0;
        /// <summary>　納税請求額 億円　</summary>
        public double m_Tax_Ordert = 0;
        /// <summary>　次回納税までの時間　:日</summary>
        public double m_NextTax_Day = 180;

        //------------ 雇用 ------------------
        /// <summary>　賃金支払い額　億円 </summary>
        public double m_EmploymentPay = 0;
        /// <summary>　雇用数　:人・日</summary>
        public double m_NextEmploymentPeople = 0;
        /// <summary>　賃金単価　:万円／（人・日）</summary>
        public double m_NextEmploymentUnitCost = 0;
        /// <summary>　応募してきた雇用数　:人・日</summary>
        public double m_EmploymentApplication = 0;

        public MzEcJapanSocietyCalInfo()
        {

        }

        public override void Clear()
        {
            base.Clear();

        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzEcJapanSocietyCalInfo csRtn = new MzEcJapanSocietyCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzEcJapanSocietyCalInfo csOrgDt = (MzEcJapanSocietyCalInfo)csOrgInfo;

            return true;
        }
    }
}
