﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;


namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary>
    /// バイオ燃料生産工場
    /// </summary>
    [Serializable]
    public class MzHmnBiofuelFactoryCalInfo : MzCashflowModelElementCalInfo
    {
        /// <summary> 各レイヤーからの漁獲量 </summary>
        public double[] m_CatchFishMass = new double[3];

        /// <summary> 卸売り対象漁量 </summary>
        public double[] m_SellFishMass = new double[3];

        //------------ 卸売り対象魚：物品売買用 ------------------

        /// <summary>魚：購入・小売り価格 　　万円／小売り単位 </summary>
        //public double m_dFishNowUnitCost = 0;
        /// <summary>魚：購買用意金 　　億円 </summary>
        public double m_dFishNowDealingChash = 0;
        /// <summary>魚：次回購入予定額 　　億円 </summary>
        public double m_dFishNextDealingChash = 0;
        /// <summary> 魚：供給能力 　　億円 </summary>
        public double m_dFishFeedCapability = 0;


        public MzHmnBiofuelFactoryCalInfo()
        {
            this.Clear();
        }

        public override void Clear()
        {
            base.Clear();
            for (int ll = 0; ll < 3; ll++)
            {
                m_CatchFishMass[ll] = 0.0;
                m_SellFishMass[ll] = 0.0;
            }
            //m_dFishNowUnitCost = 0.0;
            m_dFishNowDealingChash = 0.0;
            m_dFishNextDealingChash = 0.0;
            m_dFishFeedCapability = 0.0;
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzHmnBiofuelFactoryCalInfo csRtn = new MzHmnBiofuelFactoryCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzHmnBiofuelFactoryCalInfo csOrgDt = (MzHmnBiofuelFactoryCalInfo)csOrgInfo;

            for (int ll = 0; ll < 3; ll++)
            {
                m_CatchFishMass[ll] = csOrgDt.m_CatchFishMass[ll];
                m_SellFishMass[ll] = csOrgDt.m_SellFishMass[ll];
            }
            //m_dFishNowUnitCost = csOrgDt.m_dFishNowUnitCost;
            m_dFishNowDealingChash = csOrgDt.m_dFishNowDealingChash;
            m_dFishNextDealingChash = csOrgDt.m_dFishNextDealingChash;
            m_dFishFeedCapability = csOrgDt.m_dFishFeedCapability;
            return true;
        }
 
    }
}
