﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    public class MzOcnECHmnAction : MzCashflowModelElement
    {
        /// <summary> 演算データ（キャスト用） </summary>
        protected MzOcnECHmnActionCalInfo m_csHmnActInf = null; // 便利の為、キャスト用に定義しておく


        /// <summary>
        /// 人間の行為
        /// </summary>
        /// <returns></returns>
        protected override long HumanAction()
        {
            //double dT = m_csDltTime.GetTime() / (3600.0 * 24.0);
            double dACT_Day = m_csOcCashInf.m_HmnActTimeSpan / (3600.0 * 24.0);

            //m_csOcCashInf.m_EstimatedCost の計算がされていない
            //利益や、変動コストを計算していない
            // コストを引く
            double dDriftCost = m_csOcCashInf.m_Payment * 0.9;  // 仮
            m_csOcCashInf.CalConstCost(dACT_Day, dDriftCost);

            // 売り手側の計算
            m_csOcCashInf.SellerCalClaimedPayment();

            SendDEBUG();
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            base.SetProperty(csCellMdlPropertyInfo);

            // 使用しやすいようにキャストしておく
            m_csHmnActInf = (MzOcnECHmnActionCalInfo)m_csCalInfo;

            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
            }
            return true;
        }

    }
}
