﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    [Serializable]
    public class MzOcnResearchCO2CalInfo : MzOcnECHmnActionCalInfo
    {
        // 集計用(１日当たりの放出／吸収量計算)の経過時間：日単位
        /// <summary>集計経過時間：sec 単位</summary>
        public double m_DaySec = 0;
        // 集計用
        /// <summary>集計値</summary>
        public double m_SumO2Emission = 0.0;
        public double m_SumCO2Emission = 0.0;
        public double m_SumCO2Absorption = 0.0;

        /// <summary>平均値</summary>
        public double m_meanO2Emission = 0.0;
        public double m_meanCO2Emission = 0.0;
        public double m_meanCO2Absorption = 0.0;

        public MzOcnResearchCO2CalInfo()
        {
            Clear();
        }

        public override void Clear()
        {
            base.Clear();
            m_SumO2Emission = 0.0;
            m_SumCO2Emission = 0.0;
            m_SumCO2Absorption = 0.0;

            m_meanO2Emission = 0.0;
            m_meanCO2Emission = 0.0;
            m_meanCO2Absorption = 0.0;
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOcnResearchCO2CalInfo csRtn = new MzOcnResearchCO2CalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOcnResearchCO2CalInfo csOrgDt = (MzOcnResearchCO2CalInfo)csOrgInfo;
            m_SumO2Emission = csOrgDt.m_SumO2Emission;
            m_SumCO2Emission = csOrgDt.m_SumCO2Emission;
            m_SumCO2Absorption = csOrgDt.m_SumCO2Absorption;

            m_meanO2Emission = csOrgDt.m_meanO2Emission;
            m_meanCO2Emission = csOrgDt.m_meanCO2Emission;
            m_meanCO2Absorption = csOrgDt.m_meanCO2Absorption;
            return true;
        }

    }
}
