﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para>大気モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public  class MzOceanAtmosphereCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary>CO2排出</summary>
        public double m_CO2Emission = 0.0;

        /// <summary>要求O2</summary>
        public double m_ReqedO2 = 0.0;
        /// <summary>供給可能なO2</summary>
        public double m_AvailableO2 = 0.0;


        // 海面での　O2,CO2　＋は海面から大気へ放出、－は大気から海面への溶け込み
        public double m_SurfaceO2FromSea = 0.0;
        public double m_SurfaceCO2FromSea = 0.0;
        public double m_Dissolve_O2intoSea = 0.0;
        public double m_Dissolve_CO2intoSea = 0.0;
        public double m_O2inSea = 16.0;
        public double m_CO2inSea = 2.0;

        // 海面上の定常　O2,CO2量　g/m3
        static public double S_O2 = 0;
        static public double S_CO2 = 0;


        // 集計用(１日当たりの放出／吸収量計算)の経過時間：日単位
        /// <summary>集計経過時間：sec 単位</summary>
        public double m_DaySec = 0;
        // 集計用
        /// <summary>集計値</summary>
        public double m_SumO2Emission = 0.0;
        public double m_SumCO2Emission = 0.0;
        public double m_SumCO2Absorption = 0.0;

        /// <summary>平均値</summary>
        public double m_meanO2Emission = 0.0;
        public double m_meanCO2Emission = 0.0;
        public double m_meanCO2Absorption = 0.0;

        public MzOceanAtmosphereCalInfo()
        {
            MzOceanAtmosphereCalInfo.S_O2 = MzOceanModelElement.GetDisolveO2(20);
            MzOceanAtmosphereCalInfo.S_CO2 = MzOceanModelElement.GetDisolveCO2(20);
        }

        public override void Clear()
        {
            base.Clear();

            m_CO2Emission = 0;
            m_ReqedO2 = 0;
            m_AvailableO2 = 0;

            m_SurfaceO2FromSea = 0.0;
            m_SurfaceCO2FromSea = 0.0;
            m_Dissolve_O2intoSea = 0.0;
            m_Dissolve_CO2intoSea = 0.0;

            m_DaySec = 0;
            m_SumO2Emission = 0.0;
            m_SumCO2Emission = 0.0;
            m_SumCO2Absorption = 0.0;
            m_meanO2Emission = 0.0;
            m_meanCO2Emission = 0.0;
            m_meanCO2Absorption = 0.0;
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanAtmosphereCalInfo csRtn = new MzOceanAtmosphereCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);

            MzOceanAtmosphereCalInfo csOrgDt = (MzOceanAtmosphereCalInfo)csOrgInfo;

            m_CO2Emission = csOrgDt.m_CO2Emission;
            m_ReqedO2 = csOrgDt.m_ReqedO2;
            m_AvailableO2 = csOrgDt.m_AvailableO2;

            m_SurfaceCO2FromSea = csOrgDt.m_SurfaceCO2FromSea;
            m_SurfaceO2FromSea = csOrgDt.m_SurfaceO2FromSea;
            m_Dissolve_CO2intoSea = csOrgDt.m_Dissolve_CO2intoSea;
            m_Dissolve_O2intoSea = csOrgDt.m_Dissolve_O2intoSea;

            m_DaySec = csOrgDt.m_DaySec;

            m_SumO2Emission = csOrgDt.m_SumO2Emission;
            m_SumCO2Emission = csOrgDt.m_SumCO2Emission;
            m_SumCO2Absorption = csOrgDt.m_SumCO2Absorption;
            m_meanO2Emission = csOrgDt.m_meanO2Emission;
            m_meanCO2Emission = csOrgDt.m_meanCO2Emission;
            m_meanCO2Absorption = csOrgDt.m_meanCO2Absorption;
            return true;
        }

    }
}
