﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para>細菌（Bacterias)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public  class MzOceanBacteriasCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary> 分解時の（窒素）発生係数[g / g] </summary>
        public double m_DkK_N = 16.0E-6;
        /// <summary> 分解時の（リン）発生係数[g / g] </summary>
        public double m_DkK_P = 3.0E-6;
        /// <summary> 分解時の（Si）発生係数[g / g] </summary>
        public double m_DkK_Si = 1.0E-8;
        /// <summary> 分解時の（Fe）発生係数[g / g] </summary>
        public double m_DkK_Fe = 1.0E-8;

        /// <summary>★：自身の質量 g/m3</summary>
        public double[] m_PrvTotalSelfMass = null;

        //----チェック用-----
        /// <summary> 総入力 </summary>
        public double d_TotalIN = 0.0;
        /// <summary> 総出力(<1mm) </summary>
        public double d_TotalOUT = 0.0;
        public double d_Discompose = 0.0;
        /// <summary> 総デトリタス量 </summary>
        public double d_PreTotalMass = 0.0;
        public double d_NowTotalMass = 0.0;
        //-------------------

        public MzOceanBacteriasCalInfo()
        {
            m_dEexcretionSize = 0.5;
            m_dEatK = 0.4;
            m_dEexcretionRatio = 0.6;
            m_dMaxProliferation = 8.0;
            m_dEatK = 0.2;
        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);
            m_PrvTotalSelfMass = new double[iLayerNum];
            for(int ll=0;ll<m_lLayerNumber;ll++)
            {
                m_PrvTotalSelfMass[ll] = 0.0;
            }
        }
        public override void Clear()
        {
            base.Clear();
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                m_PrvTotalSelfMass[ll] = 0.0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanBacteriasCalInfo csRtn = new MzOceanBacteriasCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOceanBacteriasCalInfo csOrgDt = (MzOceanBacteriasCalInfo)csOrgInfo;

            this.m_DkK_N = csOrgDt.m_DkK_N;
            this.m_DkK_P = csOrgDt.m_DkK_P;
            this.m_DkK_Si = csOrgDt.m_DkK_Si;
            this.m_DkK_Fe = csOrgDt.m_DkK_Fe;

            this.d_TotalIN = csOrgDt.d_TotalIN;
            this.d_TotalOUT = csOrgDt.d_TotalOUT;
            this.d_PreTotalMass = csOrgDt.d_PreTotalMass;
            this.d_NowTotalMass = csOrgDt.d_NowTotalMass;
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                this.m_PrvTotalSelfMass[ll] = csOrgDt.m_PrvTotalSelfMass[ll];
            }
            return true;
        }

    }
}
