﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para>細菌（Bacterias)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class MzOceanPhytoplanktonsCalInfo : MzOceanModelElementCalInfo
    {
        //----- (光合成)成長に関する係数 ------
        /// <summary> 最大成長速度(1日当たり） </summary>
        public double m_dVMax = 5.0;

        /// <summary> 光要因係数 </summary>
        public double m_dL1K = 1.0;
        /// <summary> 温度要因係数 </summary>
        public double m_dT2K = 1.0;
        /// <summary> 塩濃度要因係数 </summary>
        public double m_dS3K = 1.0;

        /// <summary> 肥料成分（リン）要因係数 </summary>
        public double m_dP0 = 1.0;
        public double m_dPmin = 0.1;
        /// <summary>  肥料成分（窒素）要因係数 </summary>
        public double m_dN0 = 1.0;
        public double m_dNmin = 0.1;
        /// <summary>  肥料成分（Fe）要因係数 </summary>
        public double m_dFe0 = 1.0;
        public double m_dFemin = 0.1;
        /// <summary>  肥料成分（Si）要因係数 </summary>
        public double m_dSi0 = 1.0;
        public double m_dSimin = 0.1;

        // 空気1モルの体積＝22.4 L, 空気1mol=約28.8g
        // 海面(表面)の酸素溶解量：200μmol/Kg
        //   O2  8.11 mg/l    8.11g/m3
        //   OO2 0.033 mol/l  1.452 g/m3
        /// <summary>  吸収するCO2係数 </summary>
        public double m_dKCO2 = 44E-6 * 1E3;
        /// <summary>  排出するO2係数 </summary>
        public double m_dKO2 = 32E-6 * 1E3;
        /// <summary>  吸収するN係数 </summary>
        public double m_dKfN = 14E-6 * 1E3;
        /// <summary>  吸収するP係数 </summary>
        public double m_dKfP = 3.0E-6 * 1E3;
        /// <summary>  吸収するSi係数 </summary>
        public double m_dKfSi = 1.0E-6 * 1E3;
        /// <summary>  吸収するFe係数 </summary>
        public double m_dKfFe = 1.0E-6 * 1E3;

        //---- 呼吸に関する係数 -----
        public double m_dVSv = 0.5;
        public double d_AbsO2 = 4.0;
        public double d_AbsCO2 = 4.0;
        //---- 消費量係数 -----
        public double d_KConsume = 0.5;
        /// <summary>枯死率</summary>
        public double d_KWithered = 0.1;

        ///// <summary>要求するO2</summary>
        //public double[] m_ReqO2 = null;
        ///// <summary>O2</summary>
        //public double[] m_O2 = null;
        ///// <summary>CO2</summary>
        //public double[] m_CO2 = null;
        ///// <summary>その他ガス１</summary>
        //public double[] m_Gass1 = null;
        ///// <summary>その他ガス２</summary>
        //public double[] m_Gass2 = null;

        //-------　要求元素　-----------
        /// <summary>要求CO2</summary>
        public double[] m_ReqCO2 = null;
        public double[] m_O2Prduct = null;

        //-------　要求元素　-----------
        /// <summary>窒素</summary>
        public double[] m_ReqN = null;
        /// <summary>リン量</summary>
        public double[] m_ReqP = null;
        /// <summary>珪素量</summary>
        public double[] m_ReqSi = null;
        /// <summary>鉄量</summary>
        public double[] m_ReqFe = null;


        public MzOceanPhytoplanktonsCalInfo()
        {
            m_CapturedRatio = 0.05;
        }

        public override void Clear()
        {
            base.Clear();
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                m_ReqCO2[ll] = 0.0;
                m_O2Prduct[ll] = 0.0;

                m_ReqN[ll] = 0.0;
                m_ReqP[ll] = 0.0;
                m_ReqSi[ll] = 0.0;
                m_ReqFe[ll] = 0.0;
            }
        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);
            m_ReqCO2 = new double[m_lLayerNumber];
            m_O2Prduct = new double[m_lLayerNumber];

            m_ReqN = new double[m_lLayerNumber];
            m_ReqP = new double[m_lLayerNumber];
            m_ReqSi = new double[m_lLayerNumber];
            m_ReqFe = new double[m_lLayerNumber];
            for(int ll=0;ll<m_lLayerNumber;ll++)
            {
                m_ReqCO2[ll]=0.0;
                m_O2Prduct[ll] = 0.0;

                m_ReqN[ll] = 0.0;
                m_ReqP[ll] = 0.0;
                m_ReqSi[ll] = 0.0;
                m_ReqFe[ll] = 0.0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanPhytoplanktonsCalInfo csRtn = new MzOceanPhytoplanktonsCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOceanPhytoplanktonsCalInfo csOrgDt = (MzOceanPhytoplanktonsCalInfo)csOrgInfo;
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                this.m_ReqCO2[ll] = csOrgDt.m_ReqCO2[ll];
                this.m_O2Prduct[ll] = csOrgDt.m_O2Prduct[ll];

                this.m_ReqN[ll] = csOrgDt.m_ReqN[ll];
                this.m_ReqP[ll] = csOrgDt.m_ReqP[ll];
                this.m_ReqSi[ll] = csOrgDt.m_ReqSi[ll];
                this.m_ReqFe[ll] = csOrgDt.m_ReqFe[ll];
            }
            return true;
        }

    }
}
