﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.Interface.Viewer;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary>
    /// 伝送情報パターンファクトリ
    /// </summary>
    public class MzFlowObjBaseFactory
    {
        static McCellModelPropertyInfo csRtnCellPrptyDt = null;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="objID"></param>
        /// <param name="csModelKind"></param>
        /// <param name="sName"></param>
        /// <returns></returns>
        static public McTranInfoPattern CreateFlow(HySID objID, HySObjectKind csModelKind, string sName = "")
        {
            csRtnCellPrptyDt = new McCellModelPropertyInfo(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, csModelKind);

            McTranInfoPattern csTrnPtn = null;
            //HySID csFwdObjID = new HySID("F)_" + objID.ToString());
            //HySID csBckObjID = new HySID("B)_" + objID.ToString());

            if (objID == MzOceanBaseDefine.PREDATION)
            {   // 捕食

                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                                 "捕食／被捕食", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "捕食(捕食量) ", "被捕食(必要量) ");

                // Downstream
                {
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(5);
                    {
                        csCellChara.SetDataKind(0, "捕食した有機物", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "捕食した有機物中の炭素量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "捕食した無機物", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(3, "現在の全有機物量（資源量）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(4, "捕食物の密度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/cm3"); // ｇ/(立方ｍ)
                    }
                    csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                // Upstream
                {
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "要求する有機物量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // 
                    }
                    csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.BREATHING)
            {   // 呼吸
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                                 "呼吸（酸素消費）", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "使用酸素量 ", "排気量 ");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "Ｏ2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // μモル/(立方ｍ)
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "要求Ｏ2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // μモル/(立方ｍ)
                            csCellChara.SetDataKind(1, "排出ＣＯ2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // μモル/(立方ｍ)
                            csCellChara.SetDataKind(2, "その他の排出ガス：１", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(3, "その他の排出ガス：２", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.PHOTOSYNTHESIS)
            {   // 光合成
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                              "光合成による養分使用", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "使用養分 ", "要求養分 ");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "消費：N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(1, "消費：P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(2, "消費：Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(3, "消費：Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "要求：N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(1, "要求：P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(2, "要求：Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(3, "要求：Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.CO2_ABSORPTION)
            {   // 光合成
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                              "光合成CO2吸収", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "ＣＯ2吸収 ", "Ｏ2排出 ");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "ＣＯ2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            //csCellChara.SetDataKind(1, "ＣＯ2濃度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "PPM");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "Ｏ2 排出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(1, "ＣＯ2 要求量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }

            else if (objID == MzOceanBaseDefine.GASS_DISSOLVE)
            {   // 各種ガス大気からの吸収／大気への放出

                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                                 "大気－海：気体吸収／放出", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "大気からの吸収", "大気への放出");

                // Downstream
                {
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "O2：海水へ溶け込む", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "CO2：海水へ溶け込む", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "その他(CH4等)：海水へ溶け込む", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                    }
                    csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                // Upstream
                {
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(5);
                    {
                        csCellChara.SetDataKind(0, "O2：海水から放出", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "CO2：海水から放出", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "現在の溶け込み量：O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(3, "現在の溶け込み量：CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(4, "その他(CH4等)：海水から放出", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2"); // ｇ/(立方ｍ)
                    }
                    csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                csTrnPtn = csMutualTrnPtn;
            }
            //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            /*        
            else if (objID == McOceanBaseDefine.O2_EMISSION)
            {   // 光合成Ｏ２排出
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "光合成Ｏ2排出 " + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "Ｏ2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "μMol/m3"); // μモル/(立方ｍ)
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            */
            else if (objID == MzOceanBaseDefine.HUMAN_FERTILIZER)
            {   // 人間の施肥
                // 海 洋 生 物 中 の リ ン,窒 素,炭 素 の  比 は1:15:120で あ る と さ れ て いる
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "人間の施肥" + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6);
                    {
                        csCellChara.SetDataKind(0, "N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(3, "Si_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(4, "Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(5, "Fe_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); // ｇ/(立方ｍ)
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.EC_HUMAN_FERTILIZER)
            {   // 人間の施肥
                // 海 洋 生 物 中 の リ ン,窒 素,炭 素 の  比 は1:15:120で あ る と さ れ て いる
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "人間の施肥" + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6);
                    {
                        csCellChara.SetDataKind(0, "N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "ｔ"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "ｔ"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "ｔ"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(3, "Si_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(4, "Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "ｔ"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(5, "Fe_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); // ｇ/(立方ｍ)
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.BCT_FERTILIZER)
            {   // 海洋肥料
                // 海 洋 生 物 中 の リ ン,窒 素,炭 素 の  比 は1:15:120で あ る と さ れ て いる
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "有機物分解による肥料要素生成 " + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
                    {
                        csCellChara.SetDataKind(0, "N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(1, "P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(2, "Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(3, "Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.EXCRETION_DEATH)
            {   // 排泄
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "死:Death 又は、排泄：excretion" + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(8);
                    {
                        csCellChara.SetDataKind(0, "排泄物：有機物", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");  
                        csCellChara.SetDataKind(1, "排泄物：有機物中の炭素量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");  
                        csCellChara.SetDataKind(2, "排泄物：平均サイズ", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); 
                        csCellChara.SetDataKind(3, "排泄物：密度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/cm3"); 
                        csCellChara.SetDataKind(4, "死体：有機物", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");  
                        csCellChara.SetDataKind(5, "死体：有機物中の炭素量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");  
                        csCellChara.SetDataKind(6, "死体：平均サイズ", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "mm"); 
                        csCellChara.SetDataKind(7, "死体：密度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/cm3");  
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.DECOMPOSE)
            {   // 分解・消化
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                 "分解・腐敗：decompose", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "分解イベント受信", "分解イベント送信");

                // Downstream
                {
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "分解量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                    }
                    csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                // Upstream
                {
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "必要原料", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // 
                    }
                    csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.INFECTION)
            {   // 感染
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                              "感染：infection", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "感染率", "感染対象の存在量");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "死亡率", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "0-1:比率");
                            csCellChara.SetDataKind(1, "感染期間", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "日");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "感染のしやすさ", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "0-1:比率");
                            csCellChara.SetDataKind(1, "その生物全体数", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(2, "対象感染数", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            //else if (objID == McOceanBaseDefine.DEATH)
            //{   // 死
            //    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
            //            objID,
            //            McTranInfoDefine.D1_CELL_SERIAL,
            //            "死：Death " + sName) as McTranInfoPattern;
            //    {
            //        // セル内変数設定
            //        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //        {
            //            csCellChara.SetDataKind(0, "有機物", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            csCellChara.SetDataKind(1, "有機物中の炭素量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            csCellChara.SetDataKind(2, "平均サイズ", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "m"); // ｇ/(立方ｍ)
            //            csCellChara.SetDataKind(3, "密度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/cm3"); // ｇ/(立方ｍ)
            //        }
            //        csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //    }
            //}
            else if (objID == MzOceanBaseDefine.PARTICULATES)
            {   // 粒状物
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "粒状 有機／無機物量 [g/m3] " + sName) as McTranInfoPattern;
                {
                    int iAdd = 1;
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(iAdd + MzOceanBaseDefine.iPARTICLE_SIZE_NUM);
                    {
                        csCellChara.SetDataKind(0, "密度", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/cm3"); // 

                        csCellChara.SetDataKind(iAdd + 0, "粒状物量0.1[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 1, "粒状物量0.2[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 2, "粒状物量0.5[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 3, "粒状物量1[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 4, "粒状物量2[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 5, "粒状物量5[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 6, "粒状物量10[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 7, "粒状物量20[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 8, "粒状物量50[μm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 9, "粒状物量0.1[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 10, "粒状物量0.2[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 11, "粒状物量0.5[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 12, "粒状物量1[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 13, "粒状物量2[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 14, "粒状物量5[mm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 15, "粒状物量1[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 16, "粒状物量2[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 17, "粒状物量5[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 18, "粒状物量10[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 19, "粒状物量20[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 20, "粒状物量50[cm]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        csCellChara.SetDataKind(iAdd + 21, "粒状物量1[m]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.CO2_EMISSION)
            {   // CO2排出(人間行為)
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                              "CO2排出(人間行為)", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "ＣＯ2排出量", "Ｏ2使用量");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "ＣＯ2排出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                            csCellChara.SetDataKind(1, "Ｏ2 要求量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "Ｏ2 使用量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3");
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            else if (objID == MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION)
            {   // C02排出調査
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "CO2吸収・排出調査情報" + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "CO2吸収量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3/Day");
                        csCellChara.SetDataKind(1, "総合CO2吸収量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3/Day");
                        csCellChara.SetDataKind(2, "O2排出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3/Day");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            else if (objID == MzOceanBaseDefine.CHASH)
            {   // キャッシュフロー
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                              "キャッシュフロー", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "支払い ", "請求 ");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "発注額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "支払額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(6);
                        {
                            csCellChara.SetDataKind(0, "請求額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "見積額（次回）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(2, "生産への寄与率(0.0～1.0)", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"0～1"); // 
                            csCellChara.SetDataKind(3, "調査・サービス等の結果１", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"任意単位"); // 
                            csCellChara.SetDataKind(4, "調査・サービス等の結果２", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"任意単位"); // 
                            csCellChara.SetDataKind(5, "調査・サービス等の結果３", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"任意単位"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.DEALING)
            {   // 売買
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                         "売買", objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "製品等", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "納品（物品／成果）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "現在単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/取引単位"); //
                            csCellChara.SetDataKind(2, "共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.PRODUCT)
            {   // 材料：material
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                         "生産品：Product" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "生産品", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(5);
                        {
                            csCellChara.SetDataKind(0, "主）生産品", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(1, "現在単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/取引単位"); //
                            csCellChara.SetDataKind(2, "共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"ｔ"); //
                            csCellChara.SetDataKind(3, "副）生産品１：", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(4, "副）生産品２：", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.PRODUCT_FISH)
            {   // 材料：material
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                         "漁業関係生産品：Product" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "漁業関係生産品", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(5);
                        {
                            csCellChara.SetDataKind(0, "生産品１：（魚捕獲）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(1, "生産品２：（魚捕獲）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(2, "生産品３：（魚捕獲）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(3, "現在単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/取引単位"); //
                            csCellChara.SetDataKind(4, "共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"ｔ"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.PRODUCT_BIO_FUEL)
            {   // バイオ燃料
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                    "バイオ燃料" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "バイオ燃料", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "バイオ燃料", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(1, "現在単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/取引単位"); //
                            csCellChara.SetDataKind(2, "共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"ｔ"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.PRODUCT_FOOD)
            {   // 食品
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                 "食品" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "食品", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "食品", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
                            csCellChara.SetDataKind(1, "現在単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/取引単位"); //
                            csCellChara.SetDataKind(2, "共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"ｔ"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.CO2_EMISSION_CREDIT)
            {   // CO2排出権
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                  "CO2排出権" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "CO2排出権", "支払い");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "CO2排出権", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "権利数[t]");
                            csCellChara.SetDataKind(1, "CO2排出権単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円/取引単位"); //
                            csCellChara.SetDataKind(2, "CO2排出権共有能力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"[t]"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "購入代金／費用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "発注（次回購入予定）", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.SCINVESTMENT)
            {   // 投資
            }
            else if (objID == MzOceanBaseDefine.SC_EMPLOYMENT)
            {   // 雇用
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                    "雇用" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "雇用", "賃金");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "賃金支払い額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "次の雇用数", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "人・日");
                            csCellChara.SetDataKind(2, "次の賃金単価", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"万円/人/日"); // 
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "応募雇用", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"人・日"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            else if (objID == MzOceanBaseDefine.SC_TAX)
            {   // 税金
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                 "税金" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "税金支払い", "税金請求");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "税金支払額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
                            csCellChara.SetDataKind(1, "税金支払申告額：性善説に基づく", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); //
                            csCellChara.SetDataKind(2, "利益申告", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); //
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "税金請求額", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"億円"); // 
                            csCellChara.SetDataKind(1, "支払い期日：請求日からX日後", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"日"); // 
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            else if (objID == MzOceanBaseDefine.COMMON_DATA)
            {   // 共通データ
                McMutualTranInfoPattern csMutualTrnPtn = McExpansionModelFactory.CreateMutualTranInfo(
                         "共通データ" + sName, objID, McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL, "順方向伝搬", "逆方向伝搬");
                {
                    // Downstream
                    McTranInfoPattern csDownTrnPtn = csMutualTrnPtn.GetDwnPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csDownTrnPtn.CreateCellDataCharacteristic(8);
                        {
                            csCellChara.SetDataKind(0, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(1, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(2, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(3, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(4, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(5, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(6, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(7, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                        }
                        csDownTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csDownTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    // Upstream
                    McTranInfoPattern csUppTrnPtn = csMutualTrnPtn.GetUpPattern();
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csUppTrnPtn.CreateCellDataCharacteristic(8);
                        {
                            csCellChara.SetDataKind(0, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(1, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(2, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(3, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(4, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(5, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(6, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                            csCellChara.SetDataKind(7, "Data_0", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, @"arbitrarily");
                        }
                        csUppTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csUppTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                }
                csTrnPtn = csMutualTrnPtn;
            }
            //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            else if (objID == MzOceanBaseDefine.DEBUG_OUT)
            {   // ディバッグ用のIN/OUT
                csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        objID,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "ﾃﾞｨﾊﾞｯｸﾞ用ＣＳＶ出力" + sName) as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "任意Data", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意単位");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
            }
            //else if (objID == McOceanBaseDefine.DEBUG_IN2)
            //{   // ディバッグ用のIN/OUT
            //    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
            //            objID,
            //            McTranInfoDefine.D2_CELL_SERIAL,
            //            "ﾃﾞｨﾊﾞｯｸﾞ用ＣＳＶ出力" + sName) as McTranInfoPattern;
            //    {
            //        // セル内変数設定
            //        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
            //        {
            //            csCellChara.SetDataKind(0, "任意Data", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意単位");
            //        }
            //        csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //    }
            //}

            //else if (objID == McOceanBaseDefine.CHASH)
            //{   // 
            // else if( objID == )


            return csTrnPtn;
        }
    }

}
