﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary>
    /// 肥料工場
    /// </summary>
    [Serializable]
    public  class MzHmnFertilizerFactoryCalInfo : MzCashflowModelElementCalInfo
    {
        // ―――肥料の量分布――――
        /// <summary> 無機物粒子  </summary>
        public double m_Si_Size = 2.0;   // SiO2  サイズμｍ
        public double m_Fe_Size = 2.0;   // Fe2O　サイズμｍ
        public double m_IOPMass_Si = 1.0E-2;  // 量 ton
        public double m_IOPMass_Fe = 1.0E-2;  // 量 ton

        /// <summary> P量 ton </summary>
        public double m_N_Fertilize = 1.0E-4;
        /// <summary> N量 ton </summary>
        public double m_P_Fertilize = 15.0E-4;

        // 肥料含有量
        public double m_SI = 1.0; // 成分　ｔ
        public double m_FE = 1.0; // 成分　ｔ
        public double m_N = 1.0; // 成分　ｔ
        public double m_P = 1.0; // 成分　ｔ

       public MzHmnFertilizerFactoryCalInfo()
        {

        }

        public override void Clear()
        {
            base.Clear();
            m_IOPMass_Si = 0.0;
            m_IOPMass_Fe = 0.0;
            m_N_Fertilize = 0.0;
            m_P_Fertilize = 0.0;
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzHmnFertilizerFactoryCalInfo csRtn = new MzHmnFertilizerFactoryCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzHmnFertilizerFactoryCalInfo csOrgDt = (MzHmnFertilizerFactoryCalInfo)csOrgInfo;

            this.m_IOPMass_Si = csOrgDt.m_IOPMass_Si;
            this.m_IOPMass_Fe = csOrgDt.m_IOPMass_Fe;
            this.m_N_Fertilize = csOrgDt.m_N_Fertilize;
            this.m_P_Fertilize = csOrgDt.m_P_Fertilize;

            return true;
        }

    }
}
