﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;


namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary><para>class outline:</para>
    /// <para> 海洋開発事業</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2022/4/29][新規作成]</para>
    /// </remarks>
    public class MzHmnOceanDvlpCo : MzCashflowModelElement
    {
        /// <summary> 演算データ（キャスト用） </summary>
        MzHmnOceanDvlpCoCalInfo m_csOcnDvlpCoInf = null;

        // 捕獲した魚を買う：購買者として
        protected McPatternRdvSndTranInfoPair m_csRcvBuyFishCnnct = new McPatternRdvSndTranInfoPair();    
        // 魚を食品としてとして売る：
        protected McPatternRdvSndTranInfoPair m_csSndFishFoodCnnct = new McPatternRdvSndTranInfoPair();

        // バイオ燃料の売買：仲買
        protected McPatternRdvSndTranInfoPair m_csBuyerBioFuelCnnct = new McPatternRdvSndTranInfoPair();
        // バイオ燃料の売買：小売り
        protected McPatternRdvSndTranInfoPair m_csSellerBioFuelCnnct = new McPatternRdvSndTranInfoPair();

        // CO2調査
        protected McPatternRdvSndTranInfoPair m_csRcvResearchCO2Cnnct = new McPatternRdvSndTranInfoPair();
        // CO2排出権
        protected McPatternRdvSndTranInfoPair m_csSndCO2CreditCnnct = new McPatternRdvSndTranInfoPair();
        // 税金
        protected McPatternRdvSndTranInfoPair m_csSndTaxCnnct = new McPatternRdvSndTranInfoPair();
        // 雇用
        protected McPatternRdvSndTranInfoPair m_csSndEmploymentCnnct = new McPatternRdvSndTranInfoPair();

        //---- ワーク
        protected double m_dWorkDay = 0;

        //=======================
        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReceiveDataConnection(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool CheckReceiveDataConnection(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            // チェック処理を入れる
            bool bRtn = base.CheckReceiveDataConnection(ref csErrorInf, lInputDataNum, csInputCellData);

            McPatternRdvSndTranInfoPair m_csDumyCnnct = new McPatternRdvSndTranInfoPair();
            // 漁獲 を買う
            (m_csRcvBuyFishCnnct, m_csDumyCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.PRODUCT_FISH);
            // 魚食品売る
            (m_csDumyCnnct, m_csSndFishFoodCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.PRODUCT_FOOD);

            // バイオ燃料売買
            (m_csBuyerBioFuelCnnct, m_csSellerBioFuelCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.PRODUCT_BIO_FUEL);

            // CO2吸収調査結果
            m_csRcvResearchCO2Cnnct = this.PrepareRcvPattern(MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION);

            // CO2排出権出荷
            (m_csDumyCnnct, m_csSndCO2CreditCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.CO2_EMISSION_CREDIT);

            // 税金
            (m_csDumyCnnct, m_csSndTaxCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.SC_TAX);
            // 雇用
            (m_csDumyCnnct, m_csSndEmploymentCnnct) = this.PrepareRcvSndPattern(MzOceanBaseDefine.SC_EMPLOYMENT);

            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary>
        /// 受信
        /// </summary>
        protected override void ReceiveData()
        {
            base.ReceiveData();

            {
                BuyerFishReceive();
                FishSellerReceive();
                ReceiveResearchCO2();
                CO2CreditSellerReceive();
                TaxPaymentReceive();
                EmploymentReceive();
            }

            return;
        }

        /// <summary>
        /// 送信例
        /// </summary>
        protected override void SendData()
        {
                SendDEBUG();
           if (m_ActionFlg == true)
            {

                BuyerFishSend();
                FishSellerSend();
                CO2CreditSellerSend();
                TaxPaymentSend();
                EmploymentSend();
            }
            base.SendData();

            return;
        }
        //---------------------------------

        /// <summary>
        /// 魚受け取り：買い手（卸売）
        /// </summary>
        protected virtual void BuyerFishReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csRcvBuyFishCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csRcvBuyFishCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    m_csOcnDvlpCoInf.m_CatchFishMass[0] += csCell[0].m_dData[0];
                    m_csOcnDvlpCoInf.m_CatchFishMass[1] += csCell[0].m_dData[1];
                    m_csOcnDvlpCoInf.m_CatchFishMass[2] += csCell[0].m_dData[2];
                    dSum += csCell[0].m_dData[0] + 1.0E-16;
                    m_csRcvBuyFishCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[0] + 1.0E-16;
                    if (csCell[0].m_dData[3] > 0.0)
                    {
                        m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost = csCell[0].m_dData[3];
                        m_csOcnDvlpCoInf.m_dFeedCapability = csCell[0].m_dData[4];
                    }
                }
            }
            // 分配係数設定
            for (int i = 0; i < m_csRcvBuyFishCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csRcvBuyFishCnnct.m_dSendRatioData[i][0] = m_csRcvBuyFishCnnct.m_dRcvRatioData[i][0] / dSum;
            }
            // 発注分は入荷の為減らす
            m_csOcnDvlpCoInf.m_dFishNextDealingChash -= dSum * m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost;
            // 製品積み上げ
            m_csOcnDvlpCoInf.m_dFishMaterials += dSum;
            // m_csOcnDvlpCoInf.m_dFishFeedCapability = m_csOcnDvlpCoInf.m_dFeedCapability;
        }
        /// <summary>
        /// 魚代金支払い：買い手（卸売）
        /// </summary>
        protected virtual void BuyerFishSend()
        {
            for (int i = 0; i < m_csRcvBuyFishCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csRcvBuyFishCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_dFishDealingChash * m_csRcvBuyFishCnnct.m_dSendRatioData[i][0];
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_dFishNextDealingChash * m_csRcvBuyFishCnnct.m_dSendRatioData[i][0];
            }
        }

        /// <summary>
        /// 製品としての魚代金受け取り：売り手
        /// </summary>
        protected virtual void FishSellerReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csSndFishFoodCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csSndFishFoodCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    m_csOcnDvlpCoInf.m_Chash += csCell[0].m_dData[0];
                    m_csOcnDvlpCoInf.m_dFishNextOrdert += csCell[0].m_dData[1];
                    dSum += csCell[0].m_dData[1] + 1E-16;
                    m_csSndFishFoodCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[1] + 1E-16;
                    // 現在支払われた納入金ではなく、次回購入予定である事に注意
                }
            }
            // 分配係数設定（現在支払われた納入金ではなく、次回購入予定である事に注意）
            for (int i = 0; i < m_csSndFishFoodCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csSndFishFoodCnnct.m_dSendRatioData[i][0] = m_csSndFishFoodCnnct.m_dRcvRatioData[i][0] / dSum;
            }
        }
        /// <summary>
        /// 漁を原料として売る
        /// </summary>
        protected virtual void FishSellerSend()
        {
            // 予め通知された購入額に応じて納入
            for (int i = 0; i < m_csSndFishFoodCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSndFishFoodCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_ddFishProduct * m_csSndFishFoodCnnct.m_dSendRatioData[i][0];
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_dFishNowUnitCost;
                csSndDt[0].m_dData[2] = m_csOcnDvlpCoInf.m_dFishFeedCapability;
            }
        }
        //---------------------------------

        /// <summary>
        /// バイオ燃料受け取り：買い手（卸売）
        /// </summary>
        protected virtual void BuyerBioFuelReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csBuyerBioFuelCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csBuyerBioFuelCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    m_csOcnDvlpCoInf.m_d2ndFuelMaterials += csCell[0].m_dData[0];
                    dSum += csCell[0].m_dData[0] + 1.0E-16;
                    m_csBuyerBioFuelCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[0] + 1.0E-16;
                    if (csCell[0].m_dData[1] > 0.0)
                    {
                        m_csOcnDvlpCoInf.m_d2ndFuelMaterialsUnitCost = csCell[0].m_dData[1];
                        m_csOcnDvlpCoInf.m_d2ndFuelFeedCapability = csCell[0].m_dData[2];
                    }
                }
            }
            // 分配係数設定
            for (int i = 0; i < m_csBuyerBioFuelCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csBuyerBioFuelCnnct.m_dSendRatioData[i][0] = m_csBuyerBioFuelCnnct.m_dRcvRatioData[i][0] / dSum;
            }
            // 発注分は入荷の為減らす
            m_csOcnDvlpCoInf.m_d2ndFuelNextDealingChash -= dSum * m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost;
        }
        /// <summary>
        /// バイオ燃料代金支払い：買い手（卸売）
        /// </summary>
        protected virtual void BuyerBioFuelSend()
        {
            for (int i = 0; i < m_csBuyerBioFuelCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csBuyerBioFuelCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_d2ndFuelDealingChash * m_csBuyerBioFuelCnnct.m_dSendRatioData[i][0];
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_d2ndFuelNextDealingChash * m_csBuyerBioFuelCnnct.m_dSendRatioData[i][0];
            }
        }

        /// <summary>
        /// 製品としてのバイオ燃料代金受け取り：売り手
        /// </summary>
        protected virtual void SellerBioFuelReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csSellerBioFuelCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csSellerBioFuelCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    m_csOcnDvlpCoInf.m_Chash += csCell[0].m_dData[0];
                    m_csOcnDvlpCoInf.m_d2ndFuelNextOrdert += csCell[0].m_dData[1];
                    dSum += csCell[0].m_dData[1] + 1E-16;
                    m_csSellerBioFuelCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[1] + 1E-16;
                    // 現在支払われた納入金ではなく、次回購入予定である事に注意
                }
            }
            // 分配係数設定（現在支払われた納入金ではなく、次回購入予定である事に注意）
            for (int i = 0; i < m_csSellerBioFuelCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csSellerBioFuelCnnct.m_dSendRatioData[i][0] = m_csSellerBioFuelCnnct.m_dRcvRatioData[i][0] / dSum;
            }
        }
        /// <summary>
        /// バイオ燃料を売る
        /// </summary>
        protected virtual void SellerBioFuelSend()
        {
            // 予め通知された購入額に応じて納入
            for (int i = 0; i < m_csSellerBioFuelCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSellerBioFuelCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_d2ndFuelStock * m_csSellerBioFuelCnnct.m_dSendRatioData[i][0];
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_d2ndFuelUnitCost;
                csSndDt[0].m_dData[2] = m_csOcnDvlpCoInf.m_d2ndFuelFeedCapability;
            }
        }

        //------------------------------------
        /// <summary>
        ///　CO2調査
        /// </summary>
        protected virtual void ReceiveResearchCO2()
        {
            m_csOcnDvlpCoInf.m_meanTtlCO2Absorption = 0;
            m_csOcnDvlpCoInf.m_meanTtlCO2Emission = 0;
            m_csOcnDvlpCoInf.m_meanTtlO2Emission = 0.0;
            for (int i = 0; i < m_csRcvResearchCO2Cnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csRcvResearchCO2Cnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    // CO2
                    m_csOcnDvlpCoInf.m_meanTtlCO2Absorption += csCell[0].m_dData[0];
                    m_csOcnDvlpCoInf.m_meanTtlCO2Emission += csCell[0].m_dData[1];
                    // O2
                    m_csOcnDvlpCoInf.m_meanTtlO2Emission += csCell[0].m_dData[2];
                }
            }
        }

        //------------------------------------
        /// <summary>
        /// CO2排出権代金受け取り：売り手
        /// </summary>
        protected virtual void CO2CreditSellerReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csSndCO2CreditCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csSndCO2CreditCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    m_csOcnDvlpCoInf.m_Chash += csCell[0].m_dData[0];  // "購入代金／費用"
                    m_csOcnDvlpCoInf.m_CO2_Emission_Ordert += csCell[0].m_dData[1];  //"発注（次回購入予定）"
                    dSum += csCell[0].m_dData[1] + 1E-16;
                    m_csSndCO2CreditCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[1] + 1E-16;
                    // 現在支払われた納入金ではなく、次回購入予定である事に注意
                }
            }
            // 分配係数設定（現在支払われた納入金ではなく、次回購入予定である事に注意）
            for (int i = 0; i < m_csSndCO2CreditCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csSndCO2CreditCnnct.m_dSendRatioData[i][0] = m_csSndCO2CreditCnnct.m_dRcvRatioData[i][0] / dSum;
            }
        }
        /// <summary>
        /// CO2排出権を売る
        /// </summary>
        protected virtual void CO2CreditSellerSend()
        {
            // 予め通知された購入額に応じて納入
            for (int i = 0; i < m_csSndCO2CreditCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSndCO2CreditCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_CO2_Emission_Credit * m_csSndCO2CreditCnnct.m_dSendRatioData[i][0];  //"CO2排出権"
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_CO2_Emission_Credit_UnitCost; // "CO2排出権単価"
                csSndDt[0].m_dData[2] = m_csOcnDvlpCoInf.m_CO2_Emission_Capability;  // "CO2排出権共有能力"
            }
        }

        //------------------------------------
        /// <summary>
        /// 納税請求受け取り：納税者
        /// </summary>
        protected virtual void TaxPaymentReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csSndTaxCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csSndTaxCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    if (csCell[0].m_dData[1] > 0.0)
                    {   //""支払い期日：請求日からX日後が設定されているならば
                        m_csOcnDvlpCoInf.m_Tax_Ordert += csCell[0].m_dData[0];  // "税金請求額"
                        dSum += csCell[0].m_dData[0] + 1E-16;
                        m_csSndTaxCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[0] + 1E-16;

                        m_csOcnDvlpCoInf.m_NextTax_Day = csCell[0].m_dData[1];  //""支払い期日：請求日からX日後""
                    }
                }
            }
            // 分配係数設定（現在支払われた納入金ではなく、次回購入予定である事に注意）
            for (int i = 0; i < m_csSndTaxCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csSndTaxCnnct.m_dSendRatioData[i][0] = m_csSndTaxCnnct.m_dRcvRatioData[i][0] / dSum;
            }
        }
        /// <summary>
        /// 納税：納税者
        /// </summary>
        protected virtual void TaxPaymentSend()
        {
            if (m_csOcnDvlpCoInf.m_TaxPayment < 0.0) { return;  }
           
            for (int i = 0; i < m_csSndTaxCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSndTaxCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_TaxPayment * m_csSndTaxCnnct.m_dSendRatioData[i][0];  //"税金支払額"
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_TaxDeclaration * m_csSndTaxCnnct.m_dSendRatioData[i][0]; // "税金支払申告額：性善説に基づく"
                csSndDt[0].m_dData[2] = m_csOcnDvlpCoInf.m_Tax_Capability;  // "利益申告"
            }
        }

        //------------------------------------
        /// <summary>
        /// 雇用
        /// </summary>
        protected virtual void EmploymentReceive()
        {
            double dSum = 0.0;
            for (int i = 0; i < m_csSndEmploymentCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csSndEmploymentCnnct.m_csRcvInfArry[i].GetInterpolatedCellD1();
                if (csCell != null)
                {
                    if (csCell[0].m_dData[0] > 0.0)
                    {
                        m_csOcnDvlpCoInf.m_EmploymentApplication = csCell[0].m_dData[0];  // "応募数"
                        dSum += csCell[0].m_dData[0] + 1E-16;
                        m_csSndEmploymentCnnct.m_dRcvRatioData[i][0] = csCell[0].m_dData[0] + 1E-16;
                    }
                }
            }
            // 分配係数設定（現在支払われた納入金ではなく、次回購入予定である事に注意）
            for (int i = 0; i < m_csSndEmploymentCnnct.m_RcvInfNum; i++)
            {
                // 分配比計算
                m_csSndEmploymentCnnct.m_dSendRatioData[i][0] = m_csSndEmploymentCnnct.m_dRcvRatioData[i][0] / dSum;
            }
        }
        /// <summary>
        /// 雇用
        /// </summary>
        protected virtual void EmploymentSend()
        {
            if (m_csOcnDvlpCoInf.m_EmploymentPay < 0.0) { return; }

            for (int i = 0; i < m_csSndEmploymentCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSndEmploymentCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                csSndDt[0].m_dData[0] = m_csOcnDvlpCoInf.m_EmploymentPay * m_csSndEmploymentCnnct.m_dSendRatioData[i][0];  //"賃金支払い額"
                csSndDt[0].m_dData[1] = m_csOcnDvlpCoInf.m_NextEmploymentPeople; // 雇用数　:人・日
                csSndDt[0].m_dData[2] = m_csOcnDvlpCoInf.m_NextEmploymentUnitCost; // 賃金単価　:万円／（人・日）
            }
        }
        //------------------------------------
        protected override void SendDEBUG()
        {
            for (int i = 0; i < m_csDebugSendCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csDebugSendCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csCell == null) { continue; }
                csCell[0].m_dData[0] = m_csOcnDvlpCoInf.m_Chash;
                csCell[0].m_dData[1] = m_csOcnDvlpCoInf.m_CO2_Emission_Credit;
                csCell[0].m_dData[2] = m_csOcnDvlpCoInf.m_CO2_Emission_Capability;
                csCell[0].m_dData[3] = m_csOcnDvlpCoInf.m_CO2_Credit_DealingChash;
                csCell[0].m_dData[4] = m_csOcnDvlpCoInf.m_d2ndFuelStock;
                csCell[0].m_dData[5] = m_csOcnDvlpCoInf.m_ddFishProduct;
                csCell[0].m_dData[6] = m_csOcnDvlpCoInf.m_dDealingChash;
                csCell[0].m_dData[7] = m_csOcnDvlpCoInf.m_meanTtlCO2Emission;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            base.Initialize(ref csInitialData, lInputDataNum, ref csInputCellData);
            McInitialInfo csInDt = csInitialData as McInitialInfo;
            if (csInDt != null)
            {   // 初期化情報有り
                double dT = m_csDltTime.GetTime() / (3600.0 * 24.0);
                m_csOcnDvlpCoInf.Clear();
                m_dWorkDay = 0;

                csInDt.GetInfo("m_d2ndFuelUnitCost", ref m_csOcnDvlpCoInf.m_d2ndFuelUnitCost);
                // 単位変換　(\/L) →　億円/t
                m_csOcnDvlpCoInf.m_d2ndFuelUnitCost = m_csOcnDvlpCoInf.m_d2ndFuelUnitCost * 1E3 / 1E8;

                csInDt.GetInfo("m_d2ndFuelMaterialsUnitCost", ref m_csOcnDvlpCoInf.m_d2ndFuelMaterialsUnitCost);
                // 単位変換　(\/L) →　億円/t
                m_csOcnDvlpCoInf.m_d2ndFuelMaterialsUnitCost = m_csOcnDvlpCoInf.m_d2ndFuelMaterialsUnitCost * 1E3 / 1E8;

                csInDt.GetInfo("m_dFishMaterialsUnitCost", ref m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost);
                // 単位変換　万円/t →　億円/t
                m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost = m_csOcnDvlpCoInf.m_dFishMaterialsUnitCost / 1E4;
                
                csInDt.GetInfo("m_dFishNowUnitCost", ref m_csOcnDvlpCoInf.m_dFishNowUnitCost);
                // 単位変換　万円/t →　億円/t
                m_csOcnDvlpCoInf.m_dFishNowUnitCost = m_csOcnDvlpCoInf.m_dFishNowUnitCost / 1E4;

                csInDt.GetInfo("m_CO2_Emission_Credit_UnitCost", ref m_csOcnDvlpCoInf.m_CO2_Emission_Credit_UnitCost);
                // 単位変換　万円/t →　億円/t
                m_csOcnDvlpCoInf.m_CO2_Emission_Credit_UnitCost = m_csOcnDvlpCoInf.m_CO2_Emission_Credit_UnitCost / 1E4;

                csInDt.GetInfo("m_Benefit", ref m_csOcnDvlpCoInf.m_Benefit);
                csInDt.GetInfo("m_NextTax_Day", ref m_csOcnDvlpCoInf.m_NextTax_Day);
                csInDt.GetInfo("m_EmploymentPeriod", ref m_csOcnDvlpCoInf.m_EmploymentPeriod);

                csInDt.GetInfo("m_NextEmploymentUnitCost", ref m_csOcnDvlpCoInf.m_NextEmploymentUnitCost);
                // 単位変換　万円 →　億円
                m_csOcnDvlpCoInf.m_NextEmploymentUnitCost = m_csOcnDvlpCoInf.m_NextEmploymentUnitCost / 1E4;
            }
            m_ActionFlg = false;
            return true;
        }

        /// <summary>
        /// 人間の行為
        /// </summary>
        /// <returns></returns>
        protected override long HumanAction()
        {
            double dT = m_csDltTime.GetTime() / (3600.0 * 24.0);
            double dACT_Day = m_csOcCashInf.m_HmnActTimeSpan / (3600.0 * 24.0);

            // --------------- 魚関係売買 -------
            // 漁船から魚を買い、市場へ売る
            // 漁船からの購入量は市場からの受注分
            m_csOcnDvlpCoInf.m_dFishDealingChash = m_csOcnDvlpCoInf.m_dFishNextOrdert;
            // 漁船からの購入額分のキャッシュを持っておく
            m_csOcnDvlpCoInf.m_Chash -= m_csOcnDvlpCoInf.m_dFishDealingChash;
            // 売り側へ加工
            m_csOcnDvlpCoInf.m_ddFishProduct += m_csOcnDvlpCoInf.m_dFishMaterials;
            m_csOcnDvlpCoInf.m_dFishMaterials = 0.0;

            // 売り用の製品があるため、注残を減らす
            m_csOcnDvlpCoInf.m_dFishNextOrdert -= m_csOcnDvlpCoInf.m_ddFishProduct * m_csOcnDvlpCoInf.m_dFishNowUnitCost;

            // --------------- バイオ燃料関係売買 -------
            // バイオ燃料工場から買い、市場に売る
            // バイオ燃料工場からの購入量は市場からの受注分
            m_csOcnDvlpCoInf.m_d2ndFuelDealingChash = m_csOcnDvlpCoInf.m_d2ndFuelNextOrdert;
            // バイオ燃料工場らの購入額分のキャッシュを持っておく
            m_csOcnDvlpCoInf.m_Chash -= m_csOcnDvlpCoInf.m_d2ndFuelDealingChash;
            // 売り側へ加工
            m_csOcnDvlpCoInf.m_d2ndFuelStock += m_csOcnDvlpCoInf.m_d2ndFuelMaterials;
            m_csOcnDvlpCoInf.m_d2ndFuelMaterials = 0.0;
            // 売り用の製品があるため、注残を減らす
            m_csOcnDvlpCoInf.m_d2ndFuelNextOrdert -= m_csOcnDvlpCoInf.m_d2ndFuelStock * m_csOcnDvlpCoInf.m_dFishNowUnitCost;

            //--------------- CO2排出権量の算出 ----------
            // g/m2 から ton/100Km□ に変換
            m_csOcnDvlpCoInf.m_meanTtlO2Emission = m_csOcnDvlpCoInf.m_meanTtlO2Emission / 1E6 * MzOceanModelElementCalInfo.m_dFace;
            m_csOcnDvlpCoInf.m_meanTtlCO2Emission = m_csOcnDvlpCoInf.m_meanTtlCO2Emission / 1E6 * MzOceanModelElementCalInfo.m_dFace;
            m_csOcnDvlpCoInf.m_meanTtlCO2Absorption = m_csOcnDvlpCoInf.m_meanTtlCO2Absorption / 1E6 * MzOceanModelElementCalInfo.m_dFace;

            //--------------- 排出権計算 ----------
            // 排出権計算
            m_csOcnDvlpCoInf.m_CO2_Emission_Credit = 0.0;
            if (m_csOcnDvlpCoInf.m_meanTtlCO2Emission < 0.0 && m_csOcnDvlpCoInf.m_meanTtlCO2Absorption > 0.0)
            {   // CO2 を吸収している
                // 符号を反転して加算
                m_csOcnDvlpCoInf.m_CO2_Emission_Capability = -1.0 * m_csOcnDvlpCoInf.m_meanTtlCO2Emission;
                if (m_csOcnDvlpCoInf.m_CO2_Emission_Capability > m_csOcnDvlpCoInf.m_CO2_Emission_Ordert)
                {
                    m_csOcnDvlpCoInf.m_CO2_Emission_Credit = m_csOcnDvlpCoInf.m_CO2_Emission_Ordert;
                }
                else
                {
                    m_csOcnDvlpCoInf.m_CO2_Emission_Credit = m_csOcnDvlpCoInf.m_CO2_Emission_Capability;
                }
                //m_csOcnDvlpCoInf.m_CO2_Credit_DealingChash = m_csOcnDvlpCoInf.m_CO2_Emission_Credit * m_csOcnDvlpCoInf.m_CO2_Emission_Credit_UnitCost ;
                // ↑は送信の時計算する
            }

            //------------------------------------------------
            // 税
            m_csOcnDvlpCoInf.m_TaxPayment = -1E-20;
            m_csOcnDvlpCoInf.m_NextTax_Day -= dACT_Day;
            if (m_csOcnDvlpCoInf.m_Tax_Ordert > 0.0 && m_csOcnDvlpCoInf.m_NextTax_Day <= 0.0)
            {
                m_csOcnDvlpCoInf.m_TaxPayment = m_csOcnDvlpCoInf.m_Tax_Ordert;
                m_csOcnDvlpCoInf.m_Chash -= m_csOcnDvlpCoInf.m_TaxPayment;
                m_csOcnDvlpCoInf.m_Tax_Ordert = -1E-20;
                //
                // 仮：次回の申告額を計算　、　＆　利益等を設定
                m_csOcnDvlpCoInf.m_Tax_Capability = m_csOcnDvlpCoInf.m_Benefit;
                m_csOcnDvlpCoInf.m_TaxDeclaration = m_csOcnDvlpCoInf.m_Benefit * 0.01; // 優遇税制
            }

            //------------------------------------------------
            // 雇用
            m_csOcnDvlpCoInf.m_EmploymentPay = -1E-20;
            m_dWorkDay += dACT_Day;
            if (m_dWorkDay >= m_csOcnDvlpCoInf.m_EmploymentPeriod)
            {
                m_dWorkDay = 0;
                m_csOcnDvlpCoInf.m_EmploymentPay = m_csOcnDvlpCoInf.m_NextEmploymentPeople * m_csOcnDvlpCoInf.m_NextEmploymentUnitCost;
                // 次の雇用等計算
            }

            //利益や、変動コストを計算
            // コストを引く
            double dDriftCost = 0;  // 仮
            m_csOcCashInf.CalConstCost(dACT_Day, dDriftCost);

            ////  製造業に対する発注等
            ////m_csOcCashInf.ProductBuyerCalDealling(10);

            // 非製造業に対する発注等
            m_csOcCashInf.BuyerCalClaimedPayment();

            return 0;
        }

        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            bool bRtn = base.SetProperty(csCellMdlPropertyInfo);

            // 使用しやすいようにキャストしておく
            m_csOcnDvlpCoInf = (MzHmnOceanDvlpCoCalInfo)m_csCalInfo;
            // 14400
            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                double dT = m_csDltTime.GetTime() / (3600.0 * 24.0);

            }

            return true;
        }
  

    }
}
