﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary>
    /// 海洋開発事業
    /// </summary>
    [Serializable]
    public class MzHmnOceanDvlpCoCalInfo : MzCashflowModelElementCalInfo
    {
        /// <summary> 各レイヤーからの漁獲量 </summary>
        public double[] m_CatchFishMass = new double[3];

        /// <summary> 卸売り対象漁量 </summary>
        public double[] m_SellFishMass = new double[3];

        //------------ バイオ燃料：物品売買用 ------------------

        /// <summary> バイオ燃料・原料  [ｔ]  製品を生産するために使用するもの</summary>
        public double m_d2ndFuelMaterials = 0;
        /// <summary> バイオ燃料・原料単価</summary>
        public double m_d2ndFuelMaterialsUnitCost = 0;
        /// <summary>バイオ燃料：次回購入予定額 　　億円 </summary>
        public double m_d2ndFuelNextDealingChash = 0;
        /// <summary> バイオ燃料の量  [ｔ] 生産したもの:売るもの</summary>
        public double m_d2ndFuelStock = 0;
        /// <summary>バイオ燃料：購買用意金 　　億円 </summary>
        public double m_d2ndFuelDealingChash = 0;
        /// <summary>バイオ燃料：小売り価格 　　万円／小売り単位 </summary>
        public double m_d2ndFuelUnitCost = 0;
        /// <summary>バイオ燃料：受注額：億円 自分が売り手の時</summary>
        public double m_d2ndFuelNextOrdert = 0;
        /// <summary> バイオ燃料：供給能力 　　億円 </summary>
        public double m_d2ndFuelFeedCapability = 0;

        //------------ 魚食品：物品売買用 ------------------
        /// <summary> 購入魚：  [ｔ]  製品を生産するために使用するもの</summary>
        public double m_dFishMaterials = 0;
        /// <summary> 購入魚：単価</summary>
        public double m_dFishMaterialsUnitCost = 0;
        /// <summary>魚：次回購入予定額 　　億円 </summary>
        public double m_dFishNextDealingChash = 0;
        /// <summary> 製品の量  [ｔ] 生産したもの:売るもの</summary>
        public double m_ddFishProduct = 0;
        /// <summary>魚：購買用意金 　　億円 </summary>
        public double m_dFishDealingChash = 0;
        /// <summary>魚：小売り価格 　　万円／小売り単位 </summary>
        public double m_dFishNowUnitCost = 0;
        /// <summary>魚：受注額：億円 自分が売り手の時</summary>
        public double m_dFishNextOrdert = 0;
        /// <summary> 魚：供給能力 　　億円 </summary>
        public double m_dFishFeedCapability = 0;


        //------------ CO2排出権売買用 ------------------
        /// <summary> CO2排出権 売買用キャッシュ 億円 </summary>
        public double m_CO2_Credit_DealingChash = 0;
        /// <summary> 手持ちのCO2排出権量  [ｔ] </summary>
        public double m_CO2_Emission_Credit = 0;
        /// <summary>CO2排出権単位価格 　　万円/ton  </summary>
        public double m_CO2_Emission_Credit_UnitCost = 100;
        /// <summary>CO2排出権：受注額：億円 自分が売り手の時</summary>
        public double m_CO2_Emission_Ordert = 0;
        /// <summary> CO2排出権：供給能力 　　億円 </summary>
        public double m_CO2_Emission_Capability = 0;

        //------------ 納税用 ------------------
        /// <summary> 納税額 億円 </summary>
        public double m_TaxPayment = 0;
        /// <summary> 次回納税申告額 億円 </summary>
        public double m_TaxDeclaration = 0;
        /// <summary> 利益申告　億円 </summary>
        public double m_Tax_Capability = 0;
        /// <summary>　納税請求額　</summary>
        public double m_Tax_Ordert = 0;
        /// <summary>　次回納税までの時間　:日</summary>
        public double m_NextTax_Day = 0;

        //------------ 雇用 ------------------
        /// <summary>　賃金支払い額　億円 </summary>
        public double m_EmploymentPay = 0;
        /// <summary>　雇用数　:人・日</summary>
        public double m_NextEmploymentPeople = 0;
        /// <summary>　賃金単価　:万円／（人・日）</summary>
        public double m_NextEmploymentUnitCost = 0;
        /// <summary>　応募してきた雇用数　:人・日</summary>
        public double m_EmploymentApplication = 0;
        /// <summary>　賃金支払い間隔 ：日</summary>
        public double m_EmploymentPeriod = 30;

        //------------ CO2調査 ------------------
        /// <summary>平均値 ton/100Km□</summary>
        public double m_meanTtlO2Emission = 0.0;
        public double m_meanTtlCO2Emission = 0.0;
        public double m_meanTtlCO2Absorption = 0.0;

        public MzHmnOceanDvlpCoCalInfo()
        {
            Clear();
        }

        public override void Clear()
        {
            base.Clear();
            for (int i = 0; i < m_CatchFishMass.Length; i++)
            {
                m_CatchFishMass[i] =0;
                m_SellFishMass[i] = 0;
            }

            m_d2ndFuelMaterials = 0;
            m_d2ndFuelNextDealingChash = 0;
            m_d2ndFuelStock = 0;
            m_d2ndFuelDealingChash = 0;
            m_d2ndFuelNextOrdert = 0;
            m_d2ndFuelFeedCapability = 0;

            m_dFishMaterials = 0;
            m_dFishNextDealingChash = 0;
            m_ddFishProduct = 0;
            m_dFishDealingChash = 0;
            m_dFishNextOrdert = 0;
            m_dFishFeedCapability = 0;

            m_CO2_Credit_DealingChash = 0;
            m_CO2_Emission_Credit = 0;
            m_CO2_Emission_Ordert = 0;
            m_CO2_Emission_Capability = 0;

            m_NextEmploymentPeople = 0;
            m_EmploymentPay = 0;
            m_EmploymentApplication = 0;

            m_meanTtlO2Emission = 0.0;
            m_meanTtlCO2Emission = 0.0;
            m_meanTtlCO2Absorption = 0.0;

        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzHmnOceanDvlpCoCalInfo csRtn = new MzHmnOceanDvlpCoCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzHmnOceanDvlpCoCalInfo csOrgDt = (MzHmnOceanDvlpCoCalInfo)csOrgInfo;

            for(int i=0;i< m_CatchFishMass.Length; i++)
            {
                m_CatchFishMass[i] = csOrgDt.m_CatchFishMass[i];
                m_SellFishMass[i] = csOrgDt.m_SellFishMass[i];
            }
            m_d2ndFuelMaterials = csOrgDt.m_d2ndFuelMaterials;
            m_d2ndFuelMaterialsUnitCost = csOrgDt.m_d2ndFuelMaterialsUnitCost;
            m_d2ndFuelNextDealingChash = csOrgDt.m_d2ndFuelNextDealingChash;
            m_d2ndFuelStock = csOrgDt.m_d2ndFuelStock;
            m_d2ndFuelDealingChash = csOrgDt.m_d2ndFuelDealingChash;
            m_d2ndFuelUnitCost = csOrgDt.m_d2ndFuelUnitCost;
            m_d2ndFuelNextOrdert = csOrgDt.m_d2ndFuelNextOrdert;
            m_d2ndFuelFeedCapability = csOrgDt.m_d2ndFuelFeedCapability;

            m_dFishMaterials = csOrgDt.m_dFishMaterials;
            m_dFishMaterialsUnitCost = csOrgDt.m_dFishMaterialsUnitCost;
            m_dFishNextDealingChash = csOrgDt.m_dFishNextDealingChash;
            m_ddFishProduct = csOrgDt.m_ddFishProduct;
            m_dFishDealingChash = csOrgDt.m_dFishDealingChash;
            m_dFishNowUnitCost = csOrgDt.m_dFishNowUnitCost;
            m_dFishNextOrdert = csOrgDt.m_dFishNextOrdert;
            m_dFishFeedCapability = csOrgDt.m_dFishFeedCapability;

            m_CO2_Credit_DealingChash = csOrgDt.m_CO2_Credit_DealingChash;
            m_CO2_Emission_Credit = csOrgDt.m_CO2_Emission_Credit;
            m_CO2_Emission_Credit_UnitCost = csOrgDt.m_CO2_Emission_Credit_UnitCost;
            m_CO2_Emission_Ordert = csOrgDt.m_CO2_Emission_Ordert;
            m_CO2_Emission_Capability = csOrgDt.m_CO2_Emission_Capability;

            m_TaxPayment = csOrgDt.m_TaxPayment;
            m_TaxDeclaration = csOrgDt.m_TaxDeclaration;
            m_Tax_Capability = csOrgDt.m_Tax_Capability;
            m_Tax_Ordert = csOrgDt.m_Tax_Ordert;
            m_EmploymentApplication = csOrgDt.m_EmploymentApplication;
            m_NextTax_Day = csOrgDt.m_NextTax_Day;

            m_NextEmploymentPeople = csOrgDt.m_NextEmploymentPeople;
            m_NextEmploymentUnitCost = csOrgDt.m_NextEmploymentUnitCost;
            m_EmploymentPay = csOrgDt.m_EmploymentPay;
            m_EmploymentPeriod = csOrgDt.m_EmploymentPeriod;

            m_meanTtlO2Emission = csOrgDt.m_meanTtlO2Emission;
            m_meanTtlCO2Emission = csOrgDt.m_meanTtlO2Emission;
            m_meanTtlCO2Absorption = csOrgDt.m_meanTtlO2Emission;

            return true;
        }

    }
}
