﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYSSOP.CoreImpl.HSController;


using CommonMP.HYMCO.Ocean.McOceanBaseModel;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>海洋モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2021/12/31][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.Ocean.McOceanSampleTest.MzTestOceanSmplFactory();
        }
   
    }

}


namespace CommonMP.HYMCO.Ocean.McOceanSampleTest
{

    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    public class MzTestOceanSmplFactory : McBasicModelFactoryBase  // MzOceanModelBaseFactory
    {

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSampleModelFactory csFactory = new McSampleModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public MzTestOceanSmplFactory()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ★　CommonMPで使用する全ファクトリーでユニークな名称とする
            return MzTestOceanDefine.OCEANBASE_TEST_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            // 引数で与えられたモデル種別識別子に対応するモデルを生成する
            if (csModelKind == MzTestOceanDefine.T_XXX_MODEL_KIND)
            {
                csCalModel = new MzOceanXXXMdl();
            }
            else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            {
                csCalModel = new MzTestNutrient();
            }
            else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            {
                csCalModel = new MzTestDissolveGass();
            }
            else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            {
                csCalModel = new MzTestZpoplanktons();
            }
            else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            {
                csCalModel = new MzTestDetritus();
            }

            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            // 引数で与えられたモデル種別識別子に対応する算中データを生成する
            if (csModelKind == MzTestOceanDefine.T_XXX_MODEL_KIND)
            {
                csCalInfoData = new MzOceanXXXMdlCalInfo();
            }
            else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            {
                csCalInfoData = new MzTestNutrientCalInfo();
            }
            else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            {
                csCalInfoData = new MzTestDissolveGassCalInfo();
            }
            else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            {
                csCalInfoData = new MzTestZpoplanktonsCalInfo();
            }
            else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            {
                csCalInfoData = new MzTestDetritusCalInfo();
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //　共通設定:  計算　δT設定
            csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間

            // 引数で与えられたモデル種別識別子に対応するプロパティ値を設定する
            if (csModelKind == MzTestOceanDefine.T_XXX_MODEL_KIND)
            {   // 自作モデル

                //csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
                //csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.0025);

                //// 層設定
                //this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
                // 受信可能なパターン
                {
                    /*
                    // 呼吸
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

                    // 捕食
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                    */
                }
                // 送信パターンの設定
                {
                    /*
                    // 被捕食(漁獲)
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

                    // 排泄 or 死
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====
                    */
                }
            }
            else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            {   // 栄養素（Nutrient) クラス

                csRtnCellPrptyDt.AddInfoType("m_Density_Si", "SiO2密度  [g/cm^3]", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_Density_Si", 2.65);
                csRtnCellPrptyDt.AddInfoType("m_Dissolve_Si", "SiO2溶解度係数", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_Dissolve_Si", 30.0E-3);
                csRtnCellPrptyDt.AddInfoType("m_Density_Fe", "Fe2O密度  [g/cm^3]", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_Density_Fe", 5.24);
                csRtnCellPrptyDt.AddInfoType("m_Dissolve_Fe", "Fe2O溶融係数", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_Dissolve_Fe", 30.0E-3);

                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

                // 受信可能なパターン
                {
                    //  海洋肥料
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BCT_FERTILIZER, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                    //  人間による施肥
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.HUMAN_FERTILIZER, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加

                }
                // 送信パターンの設定
                {
                    //  光合成
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PHOTOSYNTHESIS, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "m_N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "m_P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(2, "m_Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(3, "m_Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====
                }
            }
            else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            {   // ガス（Gas)クラス

                csRtnCellPrptyDt.AddInfoType("O2_L0", "真光層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L0", 1.0);
                csRtnCellPrptyDt.AddInfoType("O2_L1", "透光層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L1", 0.01E-2);
                csRtnCellPrptyDt.AddInfoType("O2_L2", "中深層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L2", 0.01E-2);
                csRtnCellPrptyDt.AddInfoType("O2_L3", "漸深層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L3", 0.025E-1);
                csRtnCellPrptyDt.AddInfoType("O2_L4", "深海層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L4", 0.05E-1);
                csRtnCellPrptyDt.AddInfoType("O2_L5", "海底へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("O2_L5", 0.025E-2);

                csRtnCellPrptyDt.AddInfoType("CO2_L0", "真光層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("CO2_L0", 1.0);
                csRtnCellPrptyDt.AddInfoType("CO2_L1", "透光層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("CO2_L1", 0.01E-2);
                csRtnCellPrptyDt.AddInfoType("CO2_L2", "中深層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("CO2_L2", 0.01E-2);
                csRtnCellPrptyDt.AddInfoType("CO2_L3", "漸深層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("OC2_L3", 0.025E-1);
                csRtnCellPrptyDt.AddInfoType("CO2_L4", "深海層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("CO2_L4", 0.05E-1);
                csRtnCellPrptyDt.AddInfoType("CO2_L5", "海底へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("CO2_L5", 0.025E-2);

                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

                // 受信可能なパターン
                {
                    //  大気からの溶け込み
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.GASS_DISSOLVE, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 光合成によるCO2吸収
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_ABSORPTION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

                    // 呼吸
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 受信可能パターンの追加

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "海中溶融O2量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "海中溶融CO2量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(2, "O2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(3, "CO2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====
                }
            }
            else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            {   // デトリタス（Detritus)クラス
                csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "被捕獲：確率", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.4);

                csRtnCellPrptyDt.AddInfoType("m_AggregationRatio10", "凝集率(<10μm)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_AggregationRatio10", 0.05);
                csRtnCellPrptyDt.AddInfoType("m_AggregationRatio100", "凝集率(<100μm)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_AggregationRatio100", 0.025);
                csRtnCellPrptyDt.AddInfoType("m_AggregationRatio1000", "凝集率(<1mm)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_AggregationRatio1000", 0.01);

                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
                // 受信可能なパターン
                {
                    // 排泄 or  死 
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 送信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 被捕食
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加                                                                  

                    //// 海洋肥料
                    //csTrnPtn = McFlowObjFactory.CreateFlow(McOceanBaseDefine.FERTILIZER, csModelKind);
                    //csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
                        {
                            csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(2, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(3, "m_C", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====
                }
            }
            else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            {   // 動物プランクトン（Zpoplankton)クラス
                // 代謝関係
                //this.SetMetabolism(ref csRtnCellPrptyDt, 0.5, (0.05 * 0.05 * 0.05 * 1.02), 1.02, 0.5, 0.02, 1.03);
                //this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 1.5);
                //this.SetEexcretion(ref csRtnCellPrptyDt, 0.65, 0.4);
                //this.SetDeath(ref csRtnCellPrptyDt, 0.001);
                csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.05);

                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
                // 受信可能なパターン
                {
                    // 呼吸
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

                    // 捕食
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 被捕食
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

                    // 排泄 or 死
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====
                }
            }

            return csRtnCellPrptyDt;
        }
        /// <summary>
        /// 層設定
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="iLayerNum"></param>
        /// <param name="dDepth"></param>
        /// <param name="dFace"></param>
        protected virtual void SetLayer(ref McCellModelPropertyInfo csPrptyDt,
            int iLayerNum, double dDepth) //, double dFace)
        {
            //csPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間

            csPrptyDt.AddInfoType("m_lLayerNumber", "モデル内鉛直方向分割数", McDefine.ValKind.LONG);
            csPrptyDt.SetInfo("m_lLayerNumber", iLayerNum);
            csPrptyDt.AddInfoType("m_dDepth", "海洋深度 [m]", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dDepth", dDepth);
            //csPrptyDt.AddInfoType("m_dFace", "セルの広さ[Km2]", McDefine.ValKind.DOUBLE);
            //csPrptyDt.SetInfo("m_dFace", dFace);
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

            // 引数で与えられたモデル種別識別子に対応する初期設定値を設定する
            if (csModelKind == MzTestOceanDefine.T_XXX_MODEL_KIND)
            {   // 自作モデル
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            {   // 栄養素
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                //this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
                csRtnDt.AddInfoType("N_TotalMass_L0", "海面表層：N_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("N_TotalMass_L0", 48.2E-6);
                csRtnDt.AddInfoType("N_TotalMass_L1", "真光層：N_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("N_TotalMass_L1", 48.2E-6);
                csRtnDt.AddInfoType("P_TotalMass_L0", "海面表層：P_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("P_TotalMass_L0", 3.48E-6);
                csRtnDt.AddInfoType("P_TotalMass_L1", "真光層：P_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("P_TotalMass_L1", 3.48E-6);
                csRtnDt.AddInfoType("Si_TotalMass_L0", "海面表層：Si_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Si_TotalMass_L0", 8.2E-6);
                csRtnDt.AddInfoType("Si_TotalMass_L1", "真光層：Si_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Si_TotalMass_L1", 2.2E-6);
                csRtnDt.AddInfoType("Fe_TotalMass_L0", "海面表層：Fe_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Fe_TotalMass_L0", 8.2E-6);
                csRtnDt.AddInfoType("Fe_TotalMass_L1", "真光層：Fe_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Fe_TotalMass_L1", 2.2E-6);
            }
            else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                //this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
                csRtnDt.AddInfoType("O2_TotalMass_L0", "海面表層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L0", 8.11);
                csRtnDt.AddInfoType("O2_TotalMass_L1", "真光層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L1", 2.0);
                csRtnDt.AddInfoType("O2_TotalMass_L2", "透光層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L2", 5.0);
                csRtnDt.AddInfoType("O2_TotalMass_L3", "中深層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L3", 5.0);
                csRtnDt.AddInfoType("O2_TotalMass_L4", "漸深層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L4", 6.0);
                csRtnDt.AddInfoType("O2_TotalMass_L5", "深海層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L5", 6.0);
                csRtnDt.AddInfoType("O2_TotalMass_L6", "海底：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("O2_TotalMass_L6", 6.0);

                csRtnDt.AddInfoType("CO2_TotalMass_L0", "海面表層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L0", 1.452);
                csRtnDt.AddInfoType("CO2_TotalMass_L1", "真光層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L1", 2.0);
                csRtnDt.AddInfoType("CO2_TotalMass_L2", "透光層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L2", 3.0);
                csRtnDt.AddInfoType("CO2_TotalMass_L3", "中深層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L3", 3.0);
                csRtnDt.AddInfoType("CO2_TotalMass_L4", "漸深層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L4", 4.0);
                csRtnDt.AddInfoType("CO2_TotalMass_L5", "深海層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L5", 4.0);
                csRtnDt.AddInfoType("CO2_TotalMass_L6", "海底：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("CO2_TotalMass_L6", 4.0);

            }

            else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            }
            else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            {    // デトリタス
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                this.SetInitMass(ref csRtnDt, 1E-2, 1E-9, 1E-9, 0, 0, 0, 0);
                csRtnDt.AddInfoType("m_dDtrtsSize", "デトリタスサイズ[mm]", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dDtrtsSize", 30.0E-3);
                csRtnDt.AddInfoType("m_dDcty", "密度", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dDcty", 1.2);
            }
            //else
            //{ }
            return csRtnDt;
        }
        /// <summary>
        /// 初期の数量を設定
        /// </summary>
        /// <param name="csIniDt"></param>
        /// <param name="d0"></param>
        /// <param name="d1"></param>
        /// <param name="d2"></param>
        /// <param name="d3"></param>
        /// <param name="d4"></param>
        /// <param name="d5"></param>
        /// <param name="d6"></param>
        protected virtual void SetInitMass(ref McInitialInfo csIniDt,
            double d0, double d1, double d2, double d3, double d4, double d5, double d6)
        {
            csIniDt.AddInfoType("TotalMass_L0", "海面表層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L0", d0);
            csIniDt.AddInfoType("TotalMass_L1", "真光層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L1", d1);
            csIniDt.AddInfoType("TotalMass_L2", "透光層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L2", d2);
            csIniDt.AddInfoType("TotalMass_L3", "中深層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L3", d3);
            csIniDt.AddInfoType("TotalMass_L4", "漸深層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L4", d4);
            csIniDt.AddInfoType("TotalMass_L5", "深海層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L5", d5);
            csIniDt.AddInfoType("TotalMass_L6", "海底：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L6", d6);

        }

        static HySString TEST = new HySString("(ﾃｽﾄ用)");

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供：ライブラリ管理画面へ表示する情報のリストを作成する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            // ライブラリ管理画面へ表示する情報のリストを作成する

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzTestOceanDefine.T_XXX_MODEL_KIND, // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzTestOceanDefine.T_XXX_MODEL_NAME  // モデルの識別子
                                           );
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("型紙：簡単な解説");
            csModelInfo.SetCreatorInf("制作者名");
            csModelInfo.SetIconName(@"Ocean\Nekton02");  // アイコン名
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル詳細解説書PDF

            //m_csCalModelInforList.AddLast(csModelInfo);   // <-- リリース時には、このコメントを外す（ライブラリ寛喜画面に表示する）


            // ―――　別のモデル　―――
            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.FERTILIZER_KIND, // モデルの識別子
                    TEST + MzOceanBaseDefine.FERTILIZER_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("栄養素（Nutrient) ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\Nutrient");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);
       
            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.DISSOLVE_GAS_KIND, // モデルの識別子
                    TEST + MzOceanBaseDefine.DISSOLVE_GAS_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("溶融ガス(主にO2,CO2)");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\dissolveGas");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.ZOOPLANKTONS_KIND, // モデルの識別子
                    TEST + MzOceanBaseDefine.ZOOPLANKTONS_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("動物プランクトン（Zpoplankton)");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\Zpoplankton02");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.DETRITUS_KIND, // モデルの識別子
                    TEST + MzOceanBaseDefine.DETRITUS_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("デトリタス（Detritus)  死骸、糞等 ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\Detritus02");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            //--

            // ―――　――――――　―――
            return m_csCalModelInforList;
        }
  
    }    // end of class

}
