using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>伝送データ取り扱い例モデル用データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class TranInfoInOutSampleCalInfo : McCalInfo
    {
 
        // ======= テスト用ワークデータ ========
        /// <summary>テスト用ワークデータ</summary>
        public double dTtlCnt = 0.0; // for test

        // ======= テスト用　送受信情報　========
        /// <summary> １次元配列変数</summary>
        public HySCellData[] csD1CellData = null;
        /// <summary> １次元配列変数</summary>
        public HySCellData[,] csD2CellData = null;
        /// <summary> １次元配列変数</summary>
        public HySCellData[, ,] csD3CellData = null;

        /// <summary>データの次元数</summary>
        public long m_lDimNum = 0;
        /// <summary>配列数：Ｄｉｍ１ </summary>
        public long m_lDim1 = 0;
        /// <summary>配列数：Ｄｉｍ２ </summary>
        public long m_lDim2 = 0;
        /// <summary>配列数：Ｄｉｍ３ </summary>
        public long m_lDim3 = 0;
        /// <summary>配列数：経度 </summary>
        public long m_lDimLon = 0;
        /// <summary>配列数：緯度 </summary>
        public long m_lDimLat = 0;
        /// <summary>配列数：高度 </summary>
        public long m_lDimAlt = 0;

        /// <summary>セル内の変数の数</summary>
        public long m_lDataDimInCell=0;

        // ===== GIS1次元情報 ========
        /// <summary>距離配列[m] 最初のセルの始点からの距離</summary>
        public double[] m_dDistance = null;
        /// <summary>セルの始点／終点の緯度「度」　セル数よりも１点多くなることに注意</summary>
        public double[] m_dCellLat = null;
        /// <summary>セルの始点／終点の経度「度」　セル数よりも１点多くなることに注意</summary>
        public double[] m_dCellLon = null;
        /// <summary>代表点の緯度「度」</summary>
        public double[] m_dSpecificLat = null;
        /// <summary>代表点の経度「度」</summary>
        public double[] m_dSpecificLon = null;

       // ===== GIS関連情報 ========
        // 受信データ側
        /// <summary>左下（緯度） </summary>
        public double dRcvSWLat = 0.0;
        /// <summary>左下（経度） </summary>
        public double dRcvSWLon = 0.0;
        /// <summary>右上（緯度） </summary>
        public double dRcvNELat = 0.0;
        /// <summary>右上（緯度） </summary>
        public double dRcvNELon = 0.0;
        /// <summary>上側高度 </summary>
        public double dRcvUpAlt = 0.0;
        /// <summary>下側高度 </summary>
        public double dRcvLwAlt = 0.0;

        // 送信データ側
        /// <summary>左下（緯度） </summary>
        public double dSndSWLat = 35.0;
        /// <summary>左下（経度） </summary>
        public double dSndSWLon = 135.0;
        /// <summary>右上（緯度） </summary>
        public double dSndNELat = 36.0;
        /// <summary>右上（緯度） </summary>
        public double dSndNELon = 136.0;
        /// <summary>上側高度 </summary>
        public double dSndUpAlt = 150.0;
        /// <summary>下側高度 </summary>
        public double dSndLwAlt = 10.0;
        // GIS パターン
        /// <summary> ２次元配列変数（GISセル内ﾊﾟﾀｰﾝ情報の場合）</summary>
        public long[,] lGISPttnD2 = null;
        /// <summary> ３次元配列変数（GISセル内ﾊﾟﾀｰﾝ情報の場合）</summary>
        public long[, ,] lGISPttnD3 = null;

        /// <summary>GISデータ種別 </summary>
        public HySGeoMesh.MESH_DATA_KIND m_lKind;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            TranInfoInOutSampleCalInfo csRtn = new TranInfoInOutSampleCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }  
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            TranInfoInOutSampleCalInfo csOrdDt = csOrgInfo as TranInfoInOutSampleCalInfo;
            if (csOrdDt != null)
            {
                // To Do
                // 此処に、追加したメンバーをコピーする処理を入れます。 
            }
            return true;
        }
    }
}
