using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;


namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>伝送データ取り扱い例モデルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class TranInfoInOutSampletModel : McForecastModelBase
    {
        /// <summary>自計算データ</summary>
        TranInfoInOutSampleCalInfo m_csCalData = null;

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;
            for (long lLp = 0; lLp < lInputDataNum; lLp++)
            {   // 入力する伝送データ数分繰り返します。


                // ★★★★★★ start of 入力パターンに応じて何らかの処理を行いたい場合の例
                HySID csInputPtnID = csInputCellData[lLp].GetReceivePatternID();
                if (csInputPtnID.Equals(new HySID("SINGLE_CELL_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D1_CELL_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D2_CELL_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D3_CELL_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D1_GIS_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D2_GIS_MESH_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D3_GIS_MESH_SERIAL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D1_CELL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D2_CELL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D3_CELL_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D1_GIS_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D2_GIS_MESH_IN")) == true)
                {
                }
                else if (csInputPtnID.Equals(new HySID("D3_GIS_MESH_IN")) == true)
                {
                }  
                // ★★★★★★ end   of 入力パターンに応じて何らかの処理を行いたい場合の例

                // ★★★★★★  start of 伝送データの種別に応じて何らかの処理を行いたい場合の例 ★★★★★★
                // == 伝送データのセル配列及びセル内の変数の数を取得する例 =====
                m_csCalData.m_lDimNum = csInputCellData[lLp].GetDimension(ref m_csCalData.m_lDim1, ref m_csCalData.m_lDim2, ref m_csCalData.m_lDim3, ref m_csCalData.m_lDataDimInCell);

                if (McTranInfoDefine.D1_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D2_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D3_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_GIS.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS1次元情報である場合に　距離情報、セル位置情報、代表点の位置情報を取得する例 （中身は空）======
                    // 将来拡張用
                    //m_csCalData.m_dDistance = csInputCellData[lLp].GetCellDistance();
                    //m_csCalData.m_dCellLat = csInputCellData[lLp].GetCellLatitude();
                    //m_csCalData.m_dCellLon = csInputCellData[lLp].GetCellLongitude();
                    //m_csCalData.m_dSpecificLat = csInputCellData[lLp].GetSpecificLatitude();
                    //m_csCalData.m_dSpecificLon = csInputCellData[lLp].GetSpecificLongitude();
                    //m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    //csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                }
                else if (McTranInfoDefine.D2_GIS_MESH.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS系である場合に　GIS系の情報を取得する例 ======
                    m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                }
                else if (McTranInfoDefine.D3_GIS_MESH.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS系である場合に　GIS系の情報を取得する例 ======
                    m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                    csInputCellData[lLp].GetAltitude(ref m_csCalData.dRcvUpAlt, ref m_csCalData.dRcvLwAlt);
                }
                else if (McTranInfoDefine.SINGLE_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D2_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D3_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_GIS_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS1次元情報(時系列)である場合に　距離情報、セル位置情報、代表点の位置情報を取得する例 （中身は空）======
                    // 将来拡張用
                    //m_csCalData.m_dDistance = csInputCellData[lLp].GetCellDistance();
                    //m_csCalData.m_dCellLat = csInputCellData[lLp].GetCellLatitude();
                    //m_csCalData.m_dCellLon = csInputCellData[lLp].GetCellLongitude();
                    //m_csCalData.m_dSpecificLat = csInputCellData[lLp].GetSpecificLatitude();
                    //m_csCalData.m_dSpecificLon = csInputCellData[lLp].GetSpecificLongitude();
                    //m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    //csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                }
                else if (McTranInfoDefine.D2_GIS_MESH_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS系である場合に　GIS系の情報を取得する例 ======
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    // メッシュの４隅の緯度、経度を取得する
                    csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                }
                else if (McTranInfoDefine.D3_GIS_MESH_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // == 伝送データがGIS系である場合に　GIS系の情報を取得する例 ======
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csInputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    // メッシュの４隅の緯度、経度を取得する
                    csInputCellData[lLp].GetLocation(ref m_csCalData.dRcvSWLat, ref m_csCalData.dRcvSWLon, ref m_csCalData.dRcvNELat, ref m_csCalData.dRcvNELon);
                    // メッシュの高度を取得する
                    csInputCellData[lLp].GetAltitude(ref m_csCalData.dRcvUpAlt, ref m_csCalData.dRcvLwAlt);
                }                 
                // ★★★★★★ end of 伝送データの種別に応じて何らかの処理を行いたい場合の例

            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;
            for (long lLp = 0; lLp < lOutputDataNum; lLp++)
            {   // 出力する伝送データ数分繰り返します。

                // ★★★★★★ start of 出力パターンに応じて何らかの処理を行いたい場合の例
                HySID csOutPtnID = csOutputCellData[lLp].GetSendPatternID();
                if (csOutPtnID.Equals(new HySID("SINGLE_CELL_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D1_CELL_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D2_CELL_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D3_CELL_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D1_GIS_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D2_GIS_MESH_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D3_GIS_MESH_SERIAL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D1_CELL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D2_CELL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D3_CELL_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D1_GIS_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D2_GIS_MESH_Out")) == true)
                {
                }
                else if (csOutPtnID.Equals(new HySID("D3_GIS_MESH_Out")) == true)
                {
                }
                // ★★★★★★ end   of 出力パターンに応じて何らかの処理を行いたい場合の例

                // ★★★★★★  start of 伝送データの種別に応じて何らかの処理を行いたい場合の例 ★★★★★★
                m_csCalData.m_lDimNum = csOutputCellData[lLp].GetDimension(ref m_csCalData.m_lDim1, ref m_csCalData.m_lDim2, ref m_csCalData.m_lDim3, ref m_csCalData.m_lDataDimInCell);

                HySObjectKind csCellType = csOutputCellData[lLp].GetTranInfoKind();
                if (McTranInfoDefine.D1_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D2_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D3_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_GIS.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 入力要素等、出力のみしか持たない場合は、ReceiveConnectionCheckが動作しないため、配列を生成して設定する。
                    m_csCalData.m_dDistance = new double[m_csCalData.m_lDim1];
                    m_csCalData.m_dCellLat = new double[m_csCalData.m_lDim1 + 1];
                    m_csCalData.m_dCellLon = new double[m_csCalData.m_lDim1 + 1];
                    m_csCalData.m_dSpecificLat = new double[m_csCalData.m_lDim1];
                    m_csCalData.m_dSpecificLon = new double[m_csCalData.m_lDim1];
                }
                else if (McTranInfoDefine.D2_GIS_MESH.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {   // ２次元メッシュの場合
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csOutputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);

                    // メッシュの４隅の緯度、経度を設定する
                    csOutputCellData[lLp].SetLocation(m_csCalData.dSndSWLat, m_csCalData.dSndSWLon, m_csCalData.dSndNELat, m_csCalData.dSndNELon);
                }
                else if (McTranInfoDefine.D3_GIS_MESH.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {   // ３次元メッシュの場合
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csOutputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);
                    
                    // メッシュの４隅の緯度、経度を設定する
                    csOutputCellData[lLp].SetLocation(m_csCalData.dSndSWLat, m_csCalData.dSndSWLon, m_csCalData.dSndNELat, m_csCalData.dSndNELon);
                    // メッシュの高度を設定する
                    csOutputCellData[lLp].SetAltitude(m_csCalData.dSndUpAlt, m_csCalData.dSndLwAlt);
                }
                else if (McTranInfoDefine.SINGLE_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D2_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D3_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                }
                else if (McTranInfoDefine.D1_GIS_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 入力要素等、出力のみしか持たない場合は、ReceiveConnectionCheckが動作しないため、配列を生成して設定する。
                    m_csCalData.m_dDistance = new double[m_csCalData.m_lDim1];
                    m_csCalData.m_dCellLat = new double[m_csCalData.m_lDim1 + 1];
                    m_csCalData.m_dCellLon = new double[m_csCalData.m_lDim1 + 1];
                    m_csCalData.m_dSpecificLat = new double[m_csCalData.m_lDim1];
                    m_csCalData.m_dSpecificLon = new double[m_csCalData.m_lDim1];
                }
                else if (McTranInfoDefine.D2_GIS_MESH_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {   // ２次元メッシュ時系列の場合
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csOutputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);
                    // メッシュの４隅の緯度、経度を設定する
                    csOutputCellData[lLp].SetLocation(m_csCalData.dSndSWLat, m_csCalData.dSndSWLon, m_csCalData.dSndNELat, m_csCalData.dSndNELon);
                }
                else if (McTranInfoDefine.D3_GIS_MESH_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {   // ３次元メッシュ時系列の場合
                    // メッシュの配列数取得
                    m_csCalData.m_lDimNum = csOutputCellData[lLp].GetGISMeshDimension(ref m_csCalData.m_lKind, ref m_csCalData.m_lDimLon, ref m_csCalData.m_lDimLat, ref m_csCalData.m_lDimAlt, ref m_csCalData.m_lDataDimInCell);
                    // メッシュの４隅の緯度、経度を設定する
                    csOutputCellData[lLp].SetLocation(m_csCalData.dSndSWLat, m_csCalData.dSndSWLon, m_csCalData.dSndNELat, m_csCalData.dSndNELon);
                    // メッシュの高度を設定する
                    csOutputCellData[lLp].SetAltitude(m_csCalData.dSndUpAlt, m_csCalData.dSndLwAlt);
                }
                // ★★★★★★ end of 伝送データの種別に応じて何らかの処理を行いたい場合の例

            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // 引数で与えられたデータを　キャストしています。
            McInitialInfo csInDt = csInitialData as McInitialInfo;

            if (csInDt != null)
            {
                // サンプルコーディングです。　不要ならば削除してください。
                //csInDt.GetInfo("m_dData", ref m_csMyInf.m_dData);
                // To Do
                // 演算データ等で初期化が必要な情報に対して、引数で与えられた初期化情報の内容を読み取って、設定していきます。
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>OnlineInitialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>bool</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool OnlineInitialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            // To Do
            // モデルの係数等、必要な情報に対して、引数で与えられたプロパティ情報の内容を読み取って、設定していきます。
            // 但し、実行中に変更して困る情報は設定しないで下さい。
            return true;
        }
        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputCellData)</para>
        /// </example>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long Calculate(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoTestModel", "Calculate", "in");
            HySCellData[]    csD1RcvCellData = null;
            HySCellData[,]   csD2RcvCellData = null;
            HySCellData[, ,] csD3RcvCellData = null;

            long lQIdx = 0; // 受信するデータの　セル内の変数の０番目は　流量
            long lHIdx = 1; // 受信するデータの　セル内の変数の１番目は　水位


            double dQTopTotalIn = 0.0; // 総合流入量
            double dHIn = 0.0; // 水位
            HySCellData csCell = null;
            for (long lLp = 0; lLp < lInputDataNum; lLp++)
            {   // 出力する伝送データ数分繰り返します。

                HySObjectKind csCellType = csInputCellData[lLp].GetTranInfoKind(); // 伝送データ種別の取得例
                McTranInfo csTrnInf = csInputCellData[lLp].GetTranInfo();  // 伝送データ本体の取得例
               
                // 伝送データの型式
                if (McTranInfoDefine.D1_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   // セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    // セル全体を取得する場合の使用例
                    csD1RcvCellData = csInputCellData[lLp].GetInterpolatedCellD1();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        dQTopTotalIn += csInputCellData[lLp].Data(csD1RcvCellData[l1], lQIdx);//セル内の流量値を取得
                    }
                }
                else if (McTranInfoDefine.D2_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0,0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   // セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    // セル全体を取得する場合の使用例
                    csD2RcvCellData = csInputCellData[lLp].GetInterpolatedCellD2();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            dQTopTotalIn += csInputCellData[lLp].Data(csD2RcvCellData[l1, l2], lQIdx);//セル内の流量値を取得
                        }
                    }
                }
                else if (McTranInfoDefine.D3_CELL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0,0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   // セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    // セル全体を取得する場合の使用例
                    csD3RcvCellData = csInputCellData[lLp].GetInterpolatedCellD3();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                dQTopTotalIn += csInputCellData[lLp].Data(csD3RcvCellData[l1, l2, l3], lQIdx);//セル内の流量値を取得
                            }
                        }
                    }
                }// ↓　GIS1次元情報伝送データ新規作成のため追加　↓
                else if (McTranInfoDefine.D1_GIS.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 将来拡張用
                    //// 特定のセルの情報だけを取得する場合の使用例
                    //csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    //dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    //dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    //// セル全体を取得する場合の使用例
                    //csD1RcvCellData = csInputCellData[lLp].GetInterpolatedCellD1();
                    //for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    //{
                    //    dQTopTotalIn += csInputCellData[lLp].Data(csD1RcvCellData[l1], lQIdx);//セル内の流量値を取得
                    //}
                    //// == 距離情報、セル位置情報、代表点の位置情報を取得する例 ======
                    //m_csCalData.m_dDistance = csInputCellData[lLp].GetCellDistance();
                    //m_csCalData.m_dCellLat = csInputCellData[lLp].GetCellLatitude();
                    //m_csCalData.m_dCellLon = csInputCellData[lLp].GetCellLongitude();
                    //m_csCalData.m_dSpecificLat = csInputCellData[lLp].GetSpecificLatitude();
                    //m_csCalData.m_dSpecificLon = csInputCellData[lLp].GetSpecificLongitude();
                    //// 距離情報、セル位置情報、代表点位置情報の使用例
                    //for (long l1 = 0; l1 < m_csCalData.m_dDistance.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点から、1番目のセル終点までの距離情報取得　y = m_csCalData.m_dDistance[0];
                    //    // 例：1番目のセル始点から、2番目のセル終点までの距離情報取得　y = m_csCalData.m_dDistance[1];
                    //    double dDistance = m_csCalData.m_dDistance[l1];
                    //    // 例：1番目のセル始点から、1番目のセル終点までの距離情報設定　dDistance[0] = x;
                    //    // 例：1番目のセル始点から、2番目のセル終点までの距離情報設定　dDistance[1] = x;
                    //    m_csCalData.m_dDistance[l1] = dDistance + 1.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dCellLat.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点の緯度情報取得　y = dCellLat[0];
                    //    double dCellLat = m_csCalData.m_dCellLat[l1];
                    //    // 例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;
                    //    // 例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;
                    //    m_csCalData.m_dCellLat[l1] = dCellLat + 5.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dCellLon.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点の緯度情報取得　y = dCellLat[0];
                    //    double dCellLon = m_csCalData.m_dCellLon[l1];
                    //    // 例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;
                    //    // 例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;
                    //    m_csCalData.m_dCellLon[l1] = dCellLon + 10.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dSpecificLat.LongLength; l1++)
                    //{
                    //    // 例：1番目のセルデータの緯度情報取得　y = dSpecificLat[0];
                    //    double dSpecificLat = m_csCalData.m_dSpecificLat[l1];
                    //    // 例：1番目のセルデータの緯度情報設定　dSpecificLat[0] = x;
                    //    m_csCalData.m_dSpecificLat[l1] = dSpecificLat + 5.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dSpecificLon.LongLength; l1++)
                    //{
                    //    // 例：1番目のセルデータの経度情報取得　y = dSpecificLat[0];
                    //    double dSpecificLon = m_csCalData.m_dSpecificLon[l1];
                    //    // 例：1番目のセルデータの経度情報設定　dSpecificLat[0] = x;
                    //    m_csCalData.m_dSpecificLon[l1] = dSpecificLon + 10.0;
                    //}
                }
                else if (McTranInfoDefine.D2_GIS_MESH.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    // セル全体を取得する場合の使用例
                    csD2RcvCellData = csInputCellData[lLp].GetInterpolatedCellD2();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            dQTopTotalIn += csInputCellData[lLp].Data(csD2RcvCellData[l1, l2], lQIdx);//セル内の流量値を取得
                        }
                    }
                }
                else if (McTranInfoDefine.D3_GIS_MESH.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0, 0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // セル全体を取得する場合の使用例
                    csD3RcvCellData = csInputCellData[lLp].GetInterpolatedCellD3();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                dQTopTotalIn += csInputCellData[lLp].Data(csD3RcvCellData[l1, l2, l3], lQIdx);//セル内の流量値を取得
                            }
                        }
                    }
                }
                // == ★★★　時系列列データの場合 ★★★　==
                else if (McTranInfoDefine.SINGLE_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    //csInputCellData[lLp].SetLastTime(); <--- 最新時刻の情報が欲しい場合
                    //HySTime  csTime = HySCalendar.CreateTime(2009,11,23,13,10,23); // 2009/11/23 13:10:23
                    //csInputCellData[lLp].SetCurrentTime(csTime); <--- 指定時刻の情報が欲しい場合
                    //   通常　親クラス側で　csInputCellData[lLp].SetCurrentTime(this.m_csSimTime); が行われている為、現在のシミュレーション時刻の設定を明示的に行う必要はない
                    
                    // ========================================================================================================================
                    // === ↓↓　====== この処理は　計算には必要無いが、ディバッガで止めて動作を調べる場合の為に入れておく（通常の計算処理では不用）
                    McTranInfoPatternPropertyIF csRecvPtn = csInputCellData[lLp].GetReceiveTranInfoPattern(); // 受信パターン取得
                    HySDataCharacteristicInCell csCharactor = csRecvPtn.GetCellDataCharacteristic(); // 受信パターンとしてはどのような情報を取得しているかを示す情報
                    long lDtNum = csCharactor.GetDataNumber();
                    for (long lCellDt = 0; lCellDt < lDtNum; lCellDt++)
                    {
                        string csLabel = ""; string csUnit = "";
                        csCharactor.GetDataKind(lCellDt, ref csLabel, ref csUnit);
                    }
                    // === ↑↑　====== この処理は　計算には必要無いが、ディバッガで止めて動作を調べる場合の為に入れておく（通常の計算処理では不用）
                    // ========================================================================================================================

                    // 本伝送データは特別で、セルは１つのみ
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                }
                else if (McTranInfoDefine.D1_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // セル全体を取得する場合の使用例
                    csD1RcvCellData = csInputCellData[lLp].GetInterpolatedCellD1();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        dQTopTotalIn += csInputCellData[lLp].Data(csD1RcvCellData[l1], lQIdx);//セル内の流量値を取得
                    }
                }
                else if (McTranInfoDefine.D2_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                   
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // セル全体を取得する場合の使用例
                    csD2RcvCellData = csInputCellData[lLp].GetInterpolatedCellD2();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            dQTopTotalIn += csInputCellData[lLp].Data(csD2RcvCellData[l1, l2], lQIdx);//セル内の流量値を取得
                        }
                    }
                }
                else if (McTranInfoDefine.D3_CELL_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0, 0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    
                    // セル全体を取得する場合の使用例
                    csD3RcvCellData = csInputCellData[lLp].GetInterpolatedCellD3();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                dQTopTotalIn += csInputCellData[lLp].Data(csD3RcvCellData[l1, l2, l3], lQIdx);//セル内の流量値を取得
                            }
                        }
                    }
                }// ↓　GIS1次元情報時系列伝送データ新規作成のため追加　↓
                else if (McTranInfoDefine.D1_GIS_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 将来拡張用
                    //// 特定のセルの情報だけを取得する場合の使用例
                    //csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    //dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    //dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    ////// セル全体を取得する場合の使用例
                    ////csD1RcvCellData = csInputCellData[lLp].GetInterpolatedCellD1();
                    ////for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    ////{
                    ////    dQTopTotalIn += csInputCellData[lLp].Data(csD1RcvCellData[l1], lQIdx);//セル内の流量値を取得
                    ////}
                    //// == 距離情報、セル位置情報、代表点の位置情報を取得する例 ======
                    //m_csCalData.m_dDistance = csInputCellData[lLp].GetCellDistance();
                    //m_csCalData.m_dCellLat = csInputCellData[lLp].GetCellLatitude();
                    //m_csCalData.m_dCellLon = csInputCellData[lLp].GetCellLongitude();
                    //m_csCalData.m_dSpecificLat = csInputCellData[lLp].GetSpecificLatitude();
                    //m_csCalData.m_dSpecificLon = csInputCellData[lLp].GetSpecificLongitude();
                    //// 距離情報、セル位置情報、代表点位置情報の使用例
                    //for (long l1 = 0; l1 < m_csCalData.m_dDistance.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点から、1番目のセル終点までの距離情報取得　y = m_csCalData.m_dDistance[0];
                    //    // 例：1番目のセル始点から、2番目のセル終点までの距離情報取得　y = m_csCalData.m_dDistance[1];
                    //    double dDistance = m_csCalData.m_dDistance[l1];
                    //    // 例：1番目のセル始点から、1番目のセル終点までの距離情報設定　dDistance[0] = x;
                    //    // 例：1番目のセル始点から、2番目のセル終点までの距離情報設定　dDistance[1] = x;
                    //    m_csCalData.m_dDistance[l1] = dDistance + 1.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dCellLat.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点の緯度情報取得　y = dCellLat[0];
                    //    double dCellLat = m_csCalData.m_dCellLat[l1];
                    //    // 例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;
                    //    // 例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;
                    //    m_csCalData.m_dCellLat[l1] = dCellLat + 5.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dCellLon.LongLength; l1++)
                    //{
                    //    // 例：1番目のセル始点の緯度情報取得　y = dCellLat[0];
                    //    double dCellLon = m_csCalData.m_dCellLon[l1];
                    //    // 例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;
                    //    // 例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;
                    //    m_csCalData.m_dCellLon[l1] = dCellLon + 10.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dSpecificLat.LongLength; l1++)
                    //{
                    //    // 例：1番目のセルデータの緯度情報取得　y = dSpecificLat[0];
                    //    double dSpecificLat = m_csCalData.m_dSpecificLat[l1];
                    //    // 例：1番目のセルデータの緯度情報設定　dSpecificLat[0] = x;
                    //    m_csCalData.m_dSpecificLat[l1] = dSpecificLat + 5.0;
                    //}
                    //for (long l1 = 0; l1 < m_csCalData.m_dSpecificLon.LongLength; l1++)
                    //{
                    //    // 例：1番目のセルデータの経度情報取得　y = dSpecificLat[0];
                    //    double dSpecificLon = m_csCalData.m_dSpecificLon[l1];
                    //    // 例：1番目のセルデータの経度情報設定　dSpecificLat[0] = x;
                    //    m_csCalData.m_dSpecificLon[l1] = dSpecificLon + 10.0;
                    //}
                }
                else if (McTranInfoDefine.D2_GIS_MESH_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(1, 2); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // セル全体を取得する場合の使用例
                    csD2RcvCellData = csInputCellData[lLp].GetInterpolatedCellD2();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            dQTopTotalIn += csInputCellData[lLp].Data(csD2RcvCellData[l1, l2], lQIdx); //セル内の流量値を取得
                        }
                    }

                }
                else if (McTranInfoDefine.D3_GIS_MESH_SERIAL.Equals(csInputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 特定のセルの情報だけを取得する場合の使用例
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0, 0, 0); // セル配列の０番目のセルを取得
                    dQTopTotalIn += csInputCellData[lLp].Data(csCell, lQIdx);   //セル内の流量値を取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // セル全体を取得する場合の使用例
                    csD3RcvCellData = csInputCellData[lLp].GetInterpolatedCellD3();
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                dQTopTotalIn += csInputCellData[lLp].Data(csD3RcvCellData[l1, l2, l3], lQIdx);//セル内の流量値を取得
                            }
                        }
                    }
                }
            }
            if (lInputDataNum > 0)
            {
                McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoInOutSampletModel", "Calculate", "InputData = " + dQTopTotalIn.ToString());
            }
            //McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoTestModel", "Calculate", "out");
            return 0;
        }


        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoTestModel", "DataFusion", "in");
            m_csCalData.dTtlCnt += 1.0;

            HySCellData[] csSndCellData = null;
            HySCellData[,] csSndCellData2 = null;
            HySCellData[,,] csSndCellData3 = null;
            //long[,]  lGISPttnD2 = null;
            //long[,,] lGISPttnD3 = null;

            for (long lLp = 0; lLp < lOutputDataNum; lLp++)
            {   // 出力する伝送データ数分繰り返します。

                HySObjectKind csCellType = csOutputCellData[lLp].GetTranInfoKind(); // 伝送データ種別の取得例
                McTranInfo csTrnInf = csOutputCellData[lLp].GetTranInfo();  // 伝送データ本体の取得例

                if (McTranInfoDefine.D1_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();
                    // 特定のセルだけ設定する例
                    csSndCellData[0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData[0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData[0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    // セル全体を設定する例
                    double dSndDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        csSndCellData[l1].m_dData[0] = l1 + m_csCalData.dTtlCnt;
                        csSndCellData[l1].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1));
                        csSndCellData[l1].m_dData[2] = dSndDt; dSndDt += 1.0;
                    }
                }
                else if (McTranInfoDefine.D2_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData2 = csOutputCellData[lLp].PrepareSendCellD2();
                    // 特定のセルだけ設定する例
                    csSndCellData2[0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData2[0, 0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData2[0, 0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    // セル全体に設定を行う場合
                    double dSdnDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            csSndCellData2[l1, l2].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                            csSndCellData2[l1, l2].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2) );
                            csSndCellData2[l1, l2].m_dData[2] = dSdnDt; dSdnDt += 1.0;
                        }
                    }
                }
                else if (McTranInfoDefine.D3_CELL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData3 = csOutputCellData[lLp].PrepareSendCellD3();
                    // 特定のセルだけ設定する例
                    csSndCellData3[0, 0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData3[0, 0, 0].m_dData[1] = m_csCalData.dTtlCnt * 9.0;
                    csSndCellData3[0, 0, 0].m_dData[2] = m_csCalData.dTtlCnt * 81.0;
                    // セル全体に設定を行う場合
                    double dSdnDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                csSndCellData3[l1, l2, l3].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                                csSndCellData3[l1, l2, l3].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2 + (double)l3));
                                csSndCellData3[l1, l2, l3].m_dData[2] = dSdnDt; dSdnDt+=1.0;
                            }
                        }
                    }
                }// ↓　GIS1次元情報伝送データ新規作成のため追加　↓
                else if (McTranInfoDefine.D1_GIS.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 将来拡張用
                    //csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();
                    //// 特定のセルだけ設定する例
                    //csSndCellData[0].m_dData[0] = m_csCalData.dTtlCnt;
                    //csSndCellData[0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    //csSndCellData[0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    //// セル全体を設定する例
                    //double dSndDt = 0;
                    //for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    //{
                    //    csSndCellData[l1].m_dData[0] = l1 + m_csCalData.dTtlCnt;
                    //    csSndCellData[l1].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1));
                    //    csSndCellData[l1].m_dData[2] = dSndDt; dSndDt += 1.0;
                    //}
                    //// 距離情報、セル位置情報、代表点の位置情報を設定する例
                    //csOutputCellData[lLp].SetCellDistance(m_csCalData.m_dDistance);
                    //csOutputCellData[lLp].SetCellLatitude(m_csCalData.m_dCellLat);
                    //csOutputCellData[lLp].SetCellLongitude(m_csCalData.m_dCellLon);
                    //csOutputCellData[lLp].SetSpecificLatitude(m_csCalData.m_dSpecificLat);
                    //csOutputCellData[lLp].SetSpecificLongitude(m_csCalData.m_dSpecificLon);
                    ////lGISPttnD2 = csOutputCellData[lLp].PrepareSendGISPatternD2();
                }
                else if (McTranInfoDefine.D2_GIS_MESH.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData2 = csOutputCellData[lLp].PrepareSendCellD2();
                    // 特定のセルだけ設定する例
                    csSndCellData2[0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData2[0, 0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData2[0, 0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    // セル全体に設定を行う場合
                    double dSdnDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDimLon; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDimLat; l2++)
                        {
                            csSndCellData2[l1, l2].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                            csSndCellData2[l1, l2].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2));
                            csSndCellData2[l1, l2].m_dData[2] = dSdnDt; dSdnDt+=1.0;
                        }
                    }
                    //lGISPttnD2 = csOutputCellData[lLp].PrepareSendGISPatternD2();
                }
                else if (McTranInfoDefine.D3_GIS_MESH.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData3 = csOutputCellData[lLp].PrepareSendCellD3();
                    // 特定のセルだけ設定する例
                    csSndCellData3[0, 0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData3[0, 0, 0].m_dData[1] = m_csCalData.dTtlCnt * 9.0;
                    csSndCellData3[0, 0, 0].m_dData[2] = m_csCalData.dTtlCnt * 81.0;
                    // セル全体に設定を行う場合
                    double dSdnDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDimLon; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDimLat; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDimAlt; l3++)
                            {
                                csSndCellData3[l1, l2, l3].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                                csSndCellData3[l1, l2, l3].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2 + (double)l3));
                                csSndCellData3[l1, l2, l3].m_dData[2] = dSdnDt; dSdnDt += 1.0;
                            }
                        }
                    }
                    //lGISPttnD3 = csOutputCellData[lLp].PrepareSendGISPatternD3();
                }
                // == ★★★　時系列列データの場合 ★★★　==
                else if (McTranInfoDefine.SINGLE_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    //HySTime  csTime = HySCalendar.CreateTime(2009,11,23,13,10,23); // 2009/11/23 13:10:23
                    // csOutputCellData[lLp].SetCurrentTime(csTime); // <-- 特定の時刻のデータを送信したい場合
                    // 通常は　親クラス側で、下記の通り 現在のシミュレーション時刻に設定されている このため、通常は上記時刻の設定の必要は無い
                    //                  m_OutputCellData[lLp].SetCurrentTime(this.m_csSimTime);

                    csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();
                    // 本伝送データは特別で、セルは１つのみ
                    csSndCellData[0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData[0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData[0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                }
                else if (McTranInfoDefine.D1_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();
                    // 特定のセルだけ設定する例
                    csSndCellData[0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData[0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData[0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    // セル全体を設定する例
                    double dSndDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        csSndCellData[l1].m_dData[0] = l1 + m_csCalData.dTtlCnt;
                        csSndCellData[l1].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1));
                        csSndCellData[l1].m_dData[2] = dSndDt; dSndDt += 1.0;
                    }
                }
                else if (McTranInfoDefine.D2_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData2 = csOutputCellData[lLp].PrepareSendCellD2();
                    // 特定のセルだけ設定する例
                    csSndCellData2[0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData2[0, 0].m_dData[1] = m_csCalData.dTtlCnt * 9.0;
                    csSndCellData2[0, 0].m_dData[2] = m_csCalData.dTtlCnt * 81.0;
                    // セル全体を設定する例
                    double dSndDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            csSndCellData2[l1, l2].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                            csSndCellData2[l1, l2].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2));
                            csSndCellData2[l1, l2].m_dData[2] = dSndDt; dSndDt += 1.0;
                        }
                    }

                }
                else if (McTranInfoDefine.D3_CELL_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData3 = csOutputCellData[lLp].PrepareSendCellD3();
                    // 特定のセルだけ設定する例
                    csSndCellData3[0, 0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData3[0, 0, 0].m_dData[1] = m_csCalData.dTtlCnt * 9.0;
                    csSndCellData3[0, 0, 0].m_dData[2] = m_csCalData.dTtlCnt * 81.0;
                    // セル全体に設定を行う場合
                    double dSndDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDim2; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDim3; l3++)
                            {
                                csSndCellData3[l1, l2, l3].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                                csSndCellData3[l1, l2, l3].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2 + (double)l3));
                                csSndCellData3[l1, l2, l3].m_dData[2] = dSndDt; dSndDt+=1.0;
                            }
                        }
                    }
                }// ↓　GIS1次元情報時系列伝送データ新規作成のため追加　↓
                else if (McTranInfoDefine.D1_GIS_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    // 将来拡張用
                    //csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();
                    //// 特定のセルだけ設定する例
                    //csSndCellData[0].m_dData[0] = m_csCalData.dTtlCnt;
                    //csSndCellData[0].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    //csSndCellData[0].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    ////// セル全体を設定する例
                    ////double dSndDt = 0;
                    ////for (long l1 = 0; l1 < m_csCalData.m_lDim1; l1++)
                    ////{
                    ////    csSndCellData[l1].m_dData[0] = l1 + m_csCalData.dTtlCnt;
                    ////    csSndCellData[l1].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1));
                    ////    csSndCellData[l1].m_dData[2] = dSndDt; dSndDt += 1.0;
                    ////}
                    //// 距離情報、セル位置情報、代表点の位置情報を設定する例
                    //csOutputCellData[lLp].SetCellDistance(m_csCalData.m_dDistance);
                    //csOutputCellData[lLp].SetCellLatitude(m_csCalData.m_dCellLat);
                    //csOutputCellData[lLp].SetCellLongitude(m_csCalData.m_dCellLon);
                    //csOutputCellData[lLp].SetSpecificLatitude(m_csCalData.m_dSpecificLat);
                    //csOutputCellData[lLp].SetSpecificLongitude(m_csCalData.m_dSpecificLon);
                }
                else if (McTranInfoDefine.D2_GIS_MESH_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData2 = csOutputCellData[lLp].PrepareSendCellD2();
                    // 特定のセルだけ設定する例
                    csSndCellData2[1, 2].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData2[1, 2].m_dData[1] = m_csCalData.dTtlCnt * 2.0;
                    csSndCellData2[1, 2].m_dData[2] = m_csCalData.dTtlCnt * 3.0;
                    // セル全体に設定を行う場合
                    double dSndDt = 0;
                    for (long l1 = 0; l1 < m_csCalData.m_lDimLon; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDimLat; l2++)
                        {
                            csSndCellData2[l1, l2].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                            csSndCellData2[l1, l2].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2));
                            csSndCellData2[l1, l2].m_dData[2] = dSndDt; dSndDt+=1.0;
                        }
                    }
                    //lGISPttnD2 = csOutputCellData[lLp].PrepareSendGISPatternD2();
                }
                else if (McTranInfoDefine.D3_GIS_MESH_SERIAL.Equals(csOutputCellData[lLp].GetTranInfoKind()) == true)
                {
                    csSndCellData3 = csOutputCellData[lLp].PrepareSendCellD3();
                    // 特定のセルだけ設定する例
                    csSndCellData3[0, 0, 0].m_dData[0] = m_csCalData.dTtlCnt;
                    csSndCellData3[0, 0, 0].m_dData[1] = m_csCalData.dTtlCnt * 9.0;
                    csSndCellData3[0, 0, 0].m_dData[2] = m_csCalData.dTtlCnt * 81.0;
                    // セル全体に設定を行う場合
                    double dSndDt = 0; 
                    for (long l1 = 0; l1 < m_csCalData.m_lDimLon; l1++)
                    {
                        for (long l2 = 0; l2 < m_csCalData.m_lDimLat; l2++)
                        {
                            for (long l3 = 0; l3 < m_csCalData.m_lDimAlt; l3++)
                            {
                                csSndCellData3[l1, l2, l3].m_dData[0] = l1 + l2 + m_csCalData.dTtlCnt;
                                csSndCellData3[l1, l2, l3].m_dData[1] = (m_csCalData.dTtlCnt + 1.0) * 2.0 * Math.Cos(3.14 / 180.0 * ((double)l1 + (double)l2 + (double)l3));
                                csSndCellData3[l1, l2, l3].m_dData[2] = dSndDt; dSndDt += 1.0;
                            }
                        }
                    }
                    //lGISPttnD3 = csOutputCellData[lLp].PrepareSendGISPatternD3();
                }

            }

            if (lOutputDataNum > 0)
            {
                McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoInOutSampletModel", "DataFusion", "OutputData = " + m_csCalData.dTtlCnt.ToString());
            }
            //McLog.DebugOut(GetSimulationTime(), GetID(), "TranInfoTestModel", "DataFusion", "out");
            return 0;
        }


        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            bool bRtn = true;
            // 使用しやすいようにキャストしておく
            m_csCalData = (TranInfoInOutSampleCalInfo)m_csCalInfo;

            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                // 演算ステップ時刻設定
                this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());

                // To Do
                // モデルの係数等、必要な情報に対して、引数で与えられたプロパティ情報の内容を読み取って、設定していきます。
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        public override bool SetOnlineProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                // 演算ステップ時刻設定
                this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());

                // To Do
                // モデルの係数等、必要な情報に対して、引数で与えられたプロパティ情報の内容を読み取って、設定していきます。
                // 但し、実行中に変更して困る情報は設定しないで下さい。
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算開始時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadyCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool ReadyCalculation()
        {
            // ToDo
            // 計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // メソッド自身を削除してください
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算中断時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SuspendCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool SuspendCalculation()
        {
            // ToDo
            // オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // メソッド自身を削除してください
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CompleteCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool CompleteCalculation()
        {
            // ToDo
            // 計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // メソッド自身を削除してください
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算用刻み時間を自動的に変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ChangeDeltaTimeAutomatically()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ChangeDeltaTimeAutomatically()
        {
            // ToDo
            // 演算中条件によって　自身のδTを(this.m_csDltTime) を変更するメソッドです。
            // 不要ならば、本メソッドをオーバーライドする必要はありません。
            // メソッド自身を削除してください
        }
    }
}
