﻿// <summary>ソースコード：テストCSVファイル出力データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Tool;


namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestOutFileInfo : McCalInfo
    {
        /// <summary> 最終入力時刻 </summary>
        public HySTime m_csLastINTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csLastOutTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> データ一時保管 </summary>
        public LinkedList<McTestOutRecord> m_csDataList = new LinkedList<McTestOutRecord>();
        /// <summary>データ次元数 </summary>
        public long m_lDimNum = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim1 = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim2 = 0;
        /// <summary> 配列数 </summary>
        public long m_lDtDim3 = 0;
        /// <summary> ファイル出力時間間隔 </summary>
        public HySTime m_csOutTimeLag = new HySTime(2, 0, 0);
        /// <summary> ファイル出力するデータのセル内インデックス（０相対） </summary>
        public long m_lOutDataIdx = 0; // <-- ０固定

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McTestOutFileInfo csRtn = new McTestOutFileInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McTestOutFileInfo csOrgDt = (McTestOutFileInfo)csOrgInfo;

            this.m_csLastINTime = csOrgDt.m_csLastINTime.Clone();
            this.m_csLastOutTime = csOrgDt.m_csLastOutTime.Clone();
            
            this.m_csDataList.Clear();
            int iDtNum = csOrgDt.m_csDataList.Count;
            LinkedListNode<McTestOutRecord> csNd = null;
            McTestOutRecord csDt = null;
            csNd = csOrgDt.m_csDataList.First;
            for (int iP = 0; iP < iDtNum; iP++)
            {
                csDt = csNd.Value;
                this.m_csDataList.AddLast(csDt.Clone());
                csNd = csNd.Next;
            }

            this.m_lDtDim1 = csOrgDt.m_lDtDim1; 
            this.m_csOutTimeLag = csOrgDt.m_csOutTimeLag.Clone();
            this.m_lOutDataIdx = csOrgDt.m_lOutDataIdx;

            return true;
        }
    }
    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestOutRecord : HySDataRoot
    {
        /// <summary> 最終出力時刻 </summary>
        public HySTime m_csTime=null;
        /// <summary> データ一時保管 </summary>
        public double[] m_dDT=null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutRecord csRd = McTestOutRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McTestOutRecord()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutRecord csRd = McTestOutRecord( lDim ) </para>
        /// </example>
        /// <param name="lDim">１レコードのデータ数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutRecord(long lDim)
        {
            m_dDT = new double[lDim];
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutRecord csRd = McTestOutRecord( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutRecord(McTestOutRecord csOrg)
        {
            m_dDT = new double[csOrg.m_dDT.Length];
            for (long lP = 0; lP < csOrg.m_dDT.Length; lP++)
            {
                m_dDT[lP] = csOrg.m_dDT[lP];
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        virtual public McTestOutRecord Clone()
        {
            return new McTestOutRecord(this);
        }
    }
    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestOutD2Record : McTestOutRecord
    {
        /// <summary> データ一時保管 </summary>
        public double[,] m_dD2DT;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutD2Record csRd = McTestOutD2Record( lDim1,lDim2 ) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutD2Record(long lDim1, long lDim2)
        {
            m_dD2DT = new double[lDim1,lDim2];
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutRecord csRd = McTestOutRecord( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutD2Record(McTestOutD2Record csOrg)
        {
            long lDim1=csOrg.m_dD2DT.GetLength(0);
            long lDim2=csOrg.m_dD2DT.GetLength(1);

            for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                {
                    m_dD2DT[iLp1, iLp2] = csOrg.m_dD2DT[iLp1, iLp2];
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McTestOutRecord Clone()
        {
            return new McTestOutD2Record(this);
        }
    }
    /// <summary><para>class outline:</para>
    /// <para>テスト用ＣＳＶファイル出力用レコード</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestOutD3Record : McTestOutRecord
    {
        /// <summary> データ一時保管 </summary>
        public double[,,] m_dD3DT;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutD3Record csRd = McTestOutD3Record( lDim1,lDim2,lDim3 ) </para>
        /// </example>
        /// <param name="lDim1">第１配列数</param>
        /// <param name="lDim2">第２配列数</param>
        /// <param name="lDim3">第３配列数</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutD3Record(long lDim1, long lDim2, long lDim3)
        {
            m_dD3DT = new double[lDim1, lDim2, lDim3];
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTestOutRecord csRd = McTestOutRecord( csOrg ) </para>
        /// </example>
        /// <param name="csOrg">元データ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestOutD3Record(McTestOutD3Record csOrg)
        {
            long lDim1 = csOrg.m_dD3DT.GetLength(0);
            long lDim2 = csOrg.m_dD3DT.GetLength(1);
            long lDim3 = csOrg.m_dD3DT.GetLength(2);

            for (int iLp1 = 0; iLp1 < lDim1; iLp1++)
            {
                for (int iLp2 = 0; iLp2 < lDim2; iLp2++)
                {
                    for (int iLp3 = 0; iLp3 < lDim3; iLp3++)
                    {
                        m_dD3DT[iLp1, iLp2,iLp3] = csOrg.m_dD3DT[iLp1, iLp2,iLp3];
                    }
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        override public McTestOutRecord Clone()
        {
            return new McTestOutD3Record(this);
        }
    }
}
