// <summary>ソースコード：要素演算データクラス型紙</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>水文モデル演算中データクラス型紙</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class SampleCodeHydrologicalCalInfo : McCalInfo
    {
        /// <summary> テスト内部データ：例です。　不要ならば削除してください </summary>
        public double m_dData=-99.9;
        /// <summary>最後に伝送した演算時刻：例です。　不要ならば削除してください </summary>
        public HySTime m_csLastSendTime = new HySTime(0);

        // To Do
        //  必要な情報を追加します。


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            SampleCodeHydrologicalCalInfo csRtn = new SampleCodeHydrologicalCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            SampleCodeHydrologicalCalInfo csOrdDt = csOrgInfo as SampleCodeHydrologicalCalInfo;
            if( csOrdDt != null )
            {
                this.m_dData = csOrdDt.m_dData;
                this.m_csLastSendTime.SetTime(csOrdDt.m_csLastSendTime);
                // To Do
                // 此処に、追加したメンバーをコピーする処理を入れます。
            }
            return true;
        }

    }
}
