﻿//
//
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯデフォルト提供モデル共通定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McModelSampleDefine
    {
        //****************************
        //===== サンプル用定義 ========
        //****************************
        /// <summary>モデルファクトリ</summary>
        public static readonly HySID SAMPLE_MODEL_LIB = new HySID("Example.ModelSample.Fctry");
        ///// <summary>モデルプロパティ設定画面用ファクトリクラス（独自画面作成時に必要）</summary>
        //public static HySID PROPERTY_SCREEN_FACTORY_LIB_ID = new HySID("Example.ModelPrptyScrnFactory");

        /// <summary>サンプル河道（KinematicWabe)モデル種別</summary>
        public static readonly HySObjectKind KINEMATIC_WAVE_KIND = new HySObjectKind("KinematicWave_Sample");
        /// <summary>サンプル河道（KinematicWabe)モデル名称</summary>
        public static readonly HySString KINEMATIC_WAVE_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_KINEMATIC_WAVE_NAME);//"コーディングサンプル：KinematicWaveモデル"

        /// <summary>テスト用流域モデル種別</summary>
        public static readonly HySObjectKind BASIN = new HySObjectKind("MCTest.BasinKind");
        /// <summary>テスト用流域モデル名称</summary>
        public static readonly HySString BASIN_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_BASIN_NAME);//"テスト用流域流量発生モデル"

        /// <summary>テストファイル出力モデル種別</summary>
        public static readonly HySObjectKind TEST_FILE_OUT_KIND = new HySObjectKind("MCSample.McTestOutFileModel");
        /// <summary>テストファイル出力モデル名称</summary>
        public static readonly HySString TEST_FILE_OUT_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_TEST_FILE_OUT_NAME);//"テスト用ファイル出力"

        /// <summary>テストファイル入力モデル種別</summary>
        public static readonly HySObjectKind TEST_FILE_IN_KIND = new HySObjectKind("MCSample.McTestInFileModel");
        /// <summary>テストファイル入力モデル名称</summary>
        public static readonly HySString TEST_FILE_IN_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_TEST_FILE_IN_NAME);//"テスト用ファイル入力"
        /// <summary>テストファイル入力（２次元ＣＳＶファイル：時系列）モデル種別</summary>
        public static readonly HySObjectKind TEST_2DCSV_FILE_IN_KIND = new HySObjectKind("MCSample.McTestReadD2CSVFileModel");
        /// <summary>テストファイル入力（２次元ＣＳＶファイル：時系列）モデル名称</summary>
        public static readonly HySString TEST_2DCSV_FILE_IN_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_TEST_2DCSV_FILE_IN_NAME);//"テスト用２次元ＣＳＶ時系列ファイル入力"

        /// <summary>水文系モデル型紙モデル種別</summary>
        public static readonly HySObjectKind CODE_SAMPLE_HYDROLOGICAL_MODEL_KIND = new HySObjectKind("SampleHydrologicalModel");
        /// <summary>水文系モデル型紙モデル名称</summary>
        public static readonly HySString CODE_SAMPLE_HYDROLOGICAL_MODEL_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_CODE_SAMPLE_HYDROLOGICAL_MODEL_NAME);//"コーディング例：水文系モデル"
        /// <summary>水理系モデル型紙モデル種別</summary>
        public static readonly HySObjectKind CODE_SAMPLE_HYDRAULICS_MODEL_KIND = new HySObjectKind("SampleHydraulicsModel");
        /// <summary>水理系モデル型紙モデル名称</summary>
        public static readonly HySString CODE_SAMPLE_HYDRAULICS_MODEL_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_CODE_SAMPLE_HYDRAULICS_MODEL_NAME);//"コーディング例：水理系モデル"
        /// <summary>水理系モデル型紙モデル種別</summary>
        public static readonly HySObjectKind CODE_SAMPLE_MODEL_KIND = new HySObjectKind("SampleSpecialModel");
        /// <summary>水理系モデル型紙モデル名称</summary>
        public static readonly HySString CODE_SAMPLE_MODEL_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_CODE_SAMPLE_MODEL_NAME);//"コーディングサンプル：独自モデル"

        /// <summary>テスト用伝送データ種別</summary>
        public static readonly HySObjectKind TEST_TRANINFO_KIND = new HySObjectKind("McDebugTest.McTestTranInfo");
        /// <summary>テスト用伝送データ名称</summary>
        public static readonly HySString TEST_TRANINFO_NAME = new HySString(Properties.McModelSamplePrjResources.MODEL_TEST_TRANINFO_NAME);//"コーディングサンプル：伝送データ取り扱い例"

        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // KinematicWave_Sample用
        // ===============================
        /// <summary>上流端入力</summary>
        public static readonly HySID IN_PATTERN_TOP = new HySID("TopIn");
        /// <summary>支流からの横流入 </summary>
        public static readonly HySID IN_PATTERN_LATERAL = new HySID("Lateral");
        /// <summary>下流端出力</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM = new HySID("BottomOut");
        /// <summary>全セル内容出力</summary>
        public static readonly HySID OUT_PATTERN_ALL = new HySID("AllCellOut");
        /// <summary>任意</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY = new HySID("ANY");
        /// <summary>任意</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_ONE = new HySID("ANY_ONE");
        /// <summary>任意</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_D2 = new HySID("ANY_D2");
    }
}
