﻿// <summary>ソースコード：ＨＹＭＣＯサンプルモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>サンプルモデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSampleModelFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSampleModelFactory csFactory = new McSampleModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSampleModelFactory( )
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McModelSampleDefine.SAMPLE_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                //csCalModel = new McPrimitiveKinematicWave();
                csCalModel = new McSampleKinematicWave();
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csCalModel = new McTestBasin();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csCalModel = new McTestOutFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csCalModel = new McTestINFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csCalModel = new McTestReadD2CSVFileModel();
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalModel = new SampleCodeModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csCalModel = new TranInfoInOutSampletModel();
            }
            else
            {
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                //csCalInfoData = new McPrimitiveKinematicWaveCalInfo();
                csCalInfoData = new McSampleKinematicWaveCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csCalInfoData = new McTestBasinCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csCalInfoData = new McTestOutFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csCalInfoData = new McTestINFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csCalInfoData = new McTestReadD2CSVFileInfo();
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalInfoData = new SampleCodelCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csCalInfoData = new TranInfoInOutSampleCalInfo();
            }
            else
            {
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {   // サンプル河道（KinematicWabe)モデル
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime((double)48 * 3600 / 2400); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", Properties.McModelSamplePrjResources.MODEL_PROPERTY_CELL_PARTITION, McDefine.ValKind.LONG);    //"モデル内セル分割数+1"
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 51);
                csRtnCellPrptyDt.AddInfoType("m_dRough", Properties.McModelSamplePrjResources.MODEL_PROPERTY_ROUGH, McDefine.ValKind.DOUBLE);   //"粗度"
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", Properties.McModelSamplePrjResources.MODEL_PROPERTY_WIDE_INFLOW, McDefine.ValKind.DOUBLE); //"河床勾配"
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", Properties.McModelSamplePrjResources.MODEL_PROPERTY_RIVER_LENGTH, McDefine.ValKind.DOUBLE);   //"河道長"
                csRtnCellPrptyDt.SetInfo("m_dLength", 100000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", Properties.McModelSamplePrjResources.MODEL_PROPERTY_RIVER_WIDTH, McDefine.ValKind.DOUBLE); //"川幅"
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);

                csRtnCellPrptyDt.AddInfoType("m_inLQ", Properties.McModelSamplePrjResources.MODEL_PROPERTY_WIDE_INFLOW, McDefine.ValKind.LONG); //"横流入させる分割セル番号(0相対）上流から"
                csRtnCellPrptyDt.SetInfo("m_inLQ", 20);

                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_PATTERN_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_IN_PATTERN_TOP) as McTranInfoPattern;    //"上流端流入"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量 "流量"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_PATTERN_LATERAL,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_IN_PATTERN_LATERAL) as McTranInfoPattern;    //"支流からの横流入"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量 "流量"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_OUT_PATTERN_BOTTOM) as McTranInfoPattern;    //"下流端出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");  //"流量"
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m"); //"水位"
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec"); //"流速"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_OUT_PATTERN_ALL) as McTranInfoPattern;   //"セル全体出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");  //"流量"
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m"); //"水位"
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec"); //"流速"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {   // テスト用流量発生クラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(72); // δT設定 秒

                csRtnCellPrptyDt.AddInfoType("m_dWidth", Properties.McModelSamplePrjResources.MODEL_PROPERTY_RIVER_WIDTH, McDefine.ValKind.DOUBLE); //"川幅"
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQb", Properties.McModelSamplePrjResources.MODEL_PROPERTY_QUANTITY_OF_WATER_FLOW_B, McDefine.ValKind.DOUBLE);   //"流量ｂ"
                csRtnCellPrptyDt.SetInfo("m_dQb", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQp", Properties.McModelSamplePrjResources.MODEL_PROPERTY_QUANTITY_OF_WATER_FLOW_P, McDefine.ValKind.DOUBLE);   //"流量ｐ"
                csRtnCellPrptyDt.SetInfo("m_dQp", 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCp", Properties.McModelSamplePrjResources.MODEL_PROPERTY_C, McDefine.ValKind.DOUBLE);  //"ｃ"
                csRtnCellPrptyDt.SetInfo("m_dCp", 10.0);

                //csRtnCellPrptyDt.AddInfoType("OutDataKindNum", "出力データの種別数", McDefine.ValKind.LONG);
                //csRtnCellPrptyDt.SetInfo("OutDataKindNum", 1);
                //csRtnCellPrptyDt.AddInfoType("OutDataKind", "出力データ種別", McDefine.ValKind.STRING);
                //csRtnCellPrptyDt.SetInfo("OutDataKind", "流量：ｍ３／ｓｅｃ");

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_OUTFLOW_PATTERN_BOTTOM) as McTranInfoPattern;    //"下流端流出"
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");  //"流量"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {   // テスト用ＣＳＶファイル出力データクラス

                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.RemoveInfoType(McModelPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                csRtnCellPrptyDt.AddInfoType("m_csOutFileNameWithPath", Properties.McModelSamplePrjResources.MODEL_PROPERTY_OUTPUT_FILE, McDefine.ValKind.STRING);  //"出力ファイル名（パス付き）"
                csRtnCellPrptyDt.SetInfo("m_csOutFileNameWithPath", "..\\temp\\TestFileOut.csv");
                //csRtnCellPrptyDt.AddInfoType("m_lOutDataIdx", "出力するセル内データ位置（０相対）", McDefine.ValKind.LONG);
                //csRtnCellPrptyDt.SetInfo("m_lOutDataIdx", 0);

                // 受信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_PATTERN) as McTranInfoPattern;   //"任意入力"
                    {

                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");  //"任意入力"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_ONE,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_PATTERN) as McTranInfoPattern;   //"任意入力"
                    {

                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");  //"任意入力"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_PATTERN) as McTranInfoPattern;   //"任意入力"
                    {

                        //csTrnPtn.SetDim(50); // セルの配列（２次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_INPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");  //"任意入力"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {   // テスト用ＣＳＶファイル入力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", Properties.McModelSamplePrjResources.MODEL_PROPERTY_INPUT_FILE, McDefine.ValKind.STRING);    //"入力ファイル名（パス付き）"
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "..\\ModelData\\Sample\\TestFileIn.csv");
                csRtnCellPrptyDt.AddInfoType("m_lSeriesNum", Properties.McModelSamplePrjResources.MODEL_PROPERTY_SERIES_NUM, McDefine.ValKind.LONG);    //"入力ﾃﾞｰﾀ系列数(時刻部は除く) ある時刻に複数の情報がある場合に設定が必要"
                csRtnCellPrptyDt.SetInfo("m_lSeriesNum", 1);
                csRtnCellPrptyDt.AddInfoType("m_lOutDataIdx", Properties.McModelSamplePrjResources.MODEL_PROPERTY_OUT_DATA_INDEX, McDefine.ValKind.LONG);   //"出力系列番号(0相対) ある時刻に複数の情報がありかつ、ﾎﾟｲﾝﾄ時系列伝送ﾃﾞｰﾀに出力する時必要"
                csRtnCellPrptyDt.SetInfo("m_lOutDataIdx", 0);
                csRtnCellPrptyDt.RemoveInfoType(McModelPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_ONE,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_PATTERN) as McTranInfoPattern;  //"任意出力"
                    {
                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, Properties.McModelSamplePrjResources.MODEL_ANY_VALUE); //"任意出力" "任意"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_PATTERN) as McTranInfoPattern;  //"任意出力"
                    {
                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, Properties.McModelSamplePrjResources.MODEL_ANY_VALUE); //"任意出力" "任意"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", Properties.McModelSamplePrjResources.MODEL_PROPERTY_INPUT_FILE, McDefine.ValKind.STRING);    //"入力ファイル名（パス付き）"
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "..\\ModelData\\Sample\\TestDim2FileIn.csv");
                csRtnCellPrptyDt.AddInfoType("m_lDim1", Properties.McModelSamplePrjResources.MODEL_PROPERTY_INPUT_DATA_1, McDefine.ValKind.LONG);   //"入力データの配列１"
                csRtnCellPrptyDt.SetInfo("m_lDim1", 16);
                csRtnCellPrptyDt.AddInfoType("m_lDim2", Properties.McModelSamplePrjResources.MODEL_PROPERTY_INPUT_DATA_2, McDefine.ValKind.LONG);   //"入力データの配列２"
                csRtnCellPrptyDt.SetInfo("m_lDim2", 16);
                csRtnCellPrptyDt.RemoveInfoType(McModelPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_PATTERN) as McTranInfoPattern;  //"任意出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_ARBITRARY_OUTPUT_INFORMATION, HySDataKindDefine.ANY_VALUE, Properties.McModelSamplePrjResources.MODEL_ANY_VALUE); //"任意出力" "任意"
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csRtnCellPrptyDt = new SampleCodePropertyData(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)90); // δT設定 90秒
                // 受信パターンの設定
                {
                    // 受信パターンその１
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineIN"), McTranInfoDefine.D1_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_SERIAL_IN) as McTranInfoPattern;  //"１次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("AreaIN"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_IN) as McTranInfoPattern;    //"２次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_SCALOR_RAIN_FALL, HySDataKindDefine.SCALOR_RAIN_FALL, "mm/Hour");      // Index0 には、雨量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 送信パターンその１
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineOut"), McTranInfoDefine.D1_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_SERIAL_OUT) as McTranInfoPattern;    //"１次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(5); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_LENGTH, HySDataKindDefine.VECTOR_L_VELOCITY, "m/sec");         // Index2 には、流速（縦断方向)が入る
                            csCellChara.SetDataKind(3, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_WIDTH, HySDataKindDefine.VECTOR_W_VELOCITY, "m/sec");         // Index3 には、流速（横断方向)が入る
                            csCellChara.SetDataKind(4, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_DEPTH, HySDataKindDefine.VECTOR_D_VELOCITY, "m/sec");         // Index4 には、流速（深さ方向)が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("AreaOut"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_OUT) as McTranInfoPattern;  //"２次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_SCALOR_RAIN_FALL, HySDataKindDefine.SCALOR_RAIN_FALL, "mm/Hour");                 // Index0 には、雨量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index1 には、流量が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index2 には、水位が入る
                            csCellChara.SetDataKind(3, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_LENGTH, HySDataKindDefine.VECTOR_L_VELOCITY, "m/sec");         // Index3 には、流速（縦断方向)が入る
                            csCellChara.SetDataKind(4, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_WIDTH, HySDataKindDefine.VECTOR_W_VELOCITY, "m/sec");         // Index4 には、流速（横断方向)が入る
                            csCellChara.SetDataKind(5, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY_DEPTH, HySDataKindDefine.VECTOR_D_VELOCITY, "m/sec");         // Index5 には、流速（深さ方向)が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("Rain"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_OUT_SCALOR_RAIN_FALL) as McTranInfoPattern;    //"雨量のみ出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_SCALOR_RAIN_FALL, HySDataKindDefine.SCALOR_RAIN_FALL, "mm/Hour");                 // Index0 には、雨量が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("Rain"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_WATER_LEVEL) as McTranInfoPattern; //"水位のみ出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index2 には、水位が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)60); // δT設定 60秒

                // 受信パターンの設定
                {
                    // 受信パターンその０
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("SINGLE_CELL_SERIAL_IN"), McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_SINGLE_CELL_SERIAL_IN_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:０次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_SERIAL_IN"), McTranInfoDefine.D1_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_SERIAL_IN_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:１次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_SERIAL_IN"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_IN_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:２次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_SERIAL_IN"), McTranInfoDefine.D3_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D3_CELL_SERIAL_IN_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:３次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその４－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_SERIAL_IN"), McTranInfoDefine.D1_GIS_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_GIS_MESH_SERIAL_IN_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿1次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_SERIAL_IN"), McTranInfoDefine.D2_GIS_MESH_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_GIS_MESH_SERIAL_IN_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿２次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその５
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_SERIAL_IN"), McTranInfoDefine.D3_GIS_MESH_SERIAL, Properties.McModelSamplePrjResources.MODEL_D3_GIS_MESH_SERIAL_IN_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿３次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    //　非時系列
                    
                    // 受信パターンその６
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_IN"), McTranInfoDefine.D1_CELL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_IN_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列１次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその７
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_IN"), McTranInfoDefine.D2_CELL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_IN_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列２次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその８
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_IN"), McTranInfoDefine.D3_CELL, Properties.McModelSamplePrjResources.MODEL_D3_CELL_IN_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列３次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその９－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_IN"), McTranInfoDefine.D1_GIS, Properties.McModelSamplePrjResources.MODEL_D1_GIS_MESH_IN_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿1次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその９
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_IN"), McTranInfoDefine.D2_GIS_MESH, Properties.McModelSamplePrjResources.MODEL_D2_GIS_MESH_IN_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿２次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその１０
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_IN"), McTranInfoDefine.D3_GIS_MESH, Properties.McModelSamplePrjResources.MODEL_D3_GIS_MESH_IN_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿３次元入力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                }
                // 送信パターンの設定
                {
                    // 送信パターンその０
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("SINGLE_CELL_SERIAL_Out"), McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_SINGLE_CELL_SERIAL_OUT_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:０次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_SERIAL_Out"), McTranInfoDefine.D1_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_SERIAL_OUT_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:１次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_SERIAL_Out"), McTranInfoDefine.D2_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_SERIAL_OUT_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:２次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_SERIAL_Out"), McTranInfoDefine.D3_CELL_SERIAL, Properties.McModelSamplePrjResources.MODEL_D3_CELL_SERIAL_OUT_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:３次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_SERIAL_Out"), McTranInfoDefine.D1_GIS_SERIAL, Properties.McModelSamplePrjResources.MODEL_D1_GIS_MESH_SERIAL_OUT_EXAMPLE) as McTranInfoPattern; //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿1次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_SERIAL_Out"), McTranInfoDefine.D2_GIS_MESH_SERIAL, Properties.McModelSamplePrjResources.MODEL_D2_GIS_MESH_SERIAL_OUT_EXAMPLE) as McTranInfoPattern;   //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿２次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその５
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_SERIAL_Out"), McTranInfoDefine.D3_GIS_MESH_SERIAL, Properties.McModelSamplePrjResources.MODEL_D3_GIS_MESH_SERIAL_IN_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:ＧＩＳ＿３次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 非時系列
                    // 送信パターンその６
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_Out"), McTranInfoDefine.D1_CELL, Properties.McModelSamplePrjResources.MODEL_D1_CELL_OUT_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列１次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその７
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_Out"), McTranInfoDefine.D2_CELL, Properties.McModelSamplePrjResources.MODEL_D2_CELL_OUT_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列２次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその８
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_Out"), McTranInfoDefine.D3_CELL, Properties.McModelSamplePrjResources.MODEL_D3_CELL_OUT_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列３次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその９－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_Out"), McTranInfoDefine.D1_GIS, Properties.McModelSamplePrjResources.MODEL_D1_GIS_MESH_OUT_EXAMPLE) as McTranInfoPattern;  //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿１次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその９
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_Out"), McTranInfoDefine.D2_GIS_MESH, Properties.McModelSamplePrjResources.MODEL_D2_GIS_MESH_OUT_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿２次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその１０
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_Out"), McTranInfoDefine.D3_GIS_MESH, Properties.McModelSamplePrjResources.MODEL_D3_GIS_MESH_OUT_EXAMPLE) as McTranInfoPattern;    //"ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿３次元出力"
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, Properties.McModelSamplePrjResources.MODEL_WATER_LEVEL, HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, Properties.McModelSamplePrjResources.MODEL_SCALAR_VELOCITY, HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else
            {
                // Do nothing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("H_Initial", Properties.McModelSamplePrjResources.MODEL_INITIAL_WATER_LEVEL, McDefine.ValKind.DOUBLE);  //"初期水位"
                csRtnDt.SetInfo("H_Initial", 1.0);
                csRtnDt.AddInfoType("Q_Initial", Properties.McModelSamplePrjResources.MODEL_INITIAL_QUANTITY_OF_WATER_FLOW, McDefine.ValKind.DOUBLE);   //"初期流量"
                csRtnDt.SetInfo("Q_Initial", 0.1);
                csRtnDt.AddInfoType("V_Initial", Properties.McModelSamplePrjResources.MODEL_INITIAL_SCALAR_VELOCITY, McDefine.ValKind.DOUBLE);  //"初期流速"
                csRtnDt.SetInfo("V_Initial", 0.1);
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("m_dOutQ0", Properties.McModelSamplePrjResources.MODEL_QUANTITY_OF_WATER_FLOW_INITIAL_VALUE, McDefine.ValKind.DOUBLE);  //"流量初期値"
                csRtnDt.SetInfo("m_dOutQ0", 0.01);
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("OUTTIME_LAG", Properties.McModelSamplePrjResources.MODEL_OUTPUT_TIME_LAG, McDefine.ValKind.DOUBLE);    //"出力時間間隔（秒）"
                csRtnDt.SetInfo("OUTTIME_LAG", 2.0 * 3600.0);
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csRtnDt = new SampleCodelInitialData(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                    McModelSampleDefine.BASIN,
                    McModelSampleDefine.BASIN_NAME);
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_BASIN);    //"テスト用の流量発生モデルです。（モデルディバッグ時に用いる）出力は１地点のみ。"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            csModelInfo.SetIconName("Basin");
            // モデル解説書（ｐｄｆ）表示確認用
            csModelInfo.SetManualFileName("BasinModelGuide.pdf");
            m_csCalModelInforList.AddLast(csModelInfo);

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                    McModelSampleDefine.KINEMATIC_WAVE_KIND,
                    McModelSampleDefine.KINEMATIC_WAVE_NAME);
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_KINEMATIC_WAVE_KIND);  //"コーディングサンプル：簡易河道モデルのサンプルです。"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            csModelInfo.SetIconName("Lane");
            m_csCalModelInforList.AddLast(csModelInfo);

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_CSV_FILE,
                    McModelSampleDefine.TEST_FILE_OUT_KIND,
                    McModelSampleDefine.TEST_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_TEST_FILE_OUT_KIND);   //"コーディングサンプル：ファイル出力クラス（ＣＳＶ形式、モデルディバッグ時に用いる）"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            //csModelInfo.SetIconName("DefaultOutput");
            csModelInfo.SetIconName("csvWrite");
            m_csCalModelInforList.AddLast(csModelInfo);

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_INPUT_CSV_FILE,
                McModelSampleDefine.TEST_FILE_IN_KIND,
                McModelSampleDefine.TEST_FILE_IN_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_TEST_FILE_IN_KIND);    //"コーディングサンプル：ファイル入力クラス（１変数：時系列 ＣＳＶ形式、モデルディバッグ時に用いる）"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            //csModelInfo.SetIconName("DefaultInput");
            csModelInfo.SetIconName("csvRead");
            m_csCalModelInforList.AddLast(csModelInfo);

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL,
                McModelLibraryDefine.MODEL_CLASSIFICATION_INPUT_CSV_FILE,
                McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND,
                McModelSampleDefine.TEST_2DCSV_FILE_IN_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_TEST_2DCSV_FILE_IN_KIND);  //"コーディングサンプル：ファイル入力クラス（２次元変数：時系列 ＣＳＶ形式、モデルディバッグ時に用いる）"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            //csModelInfo.SetIconName("DefaultInput");
            csModelInfo.SetIconName("csvRead");
            m_csCalModelInforList.AddLast(csModelInfo);

            // 特別モデル型紙の情報を公開
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                    McModelSampleDefine.CODE_SAMPLE_MODEL_KIND, // モデルの識別子
                    McModelSampleDefine.CODE_SAMPLE_MODEL_NAME  // モデルの名称
                                         );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_CODE_SAMPLE_MODEL_KIND);   //"コーディング例です。（処理は何もしない）"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

                        csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                        McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                        McModelSampleDefine.TEST_TRANINFO_KIND, // モデルの識別子
                        McModelSampleDefine.TEST_TRANINFO_NAME  // モデルの名称
                             );

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf(Properties.McModelSamplePrjResources.MODEL_SUMMARY_TEST_TRANINFO_KIND);   //"伝送データの取り扱いを示したコーディング例です。（処理は何もしない）"
            csModelInfo.SetCreatorInf(Properties.McModelSamplePrjResources.MODEL_CREATOR_MY_MODEL); //"CommonMP　モデル開発者"
            csModelInfo.SetIconName("DefaultModel");
            m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }

    }
}
