﻿// <summary>ソースコード：サンプル要素内演算中データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCOサンプル河道（KinematicWabe)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McPrimitiveKinematicWaveCalInfo : McCalInfo
    {
        // 計算用データの変数
        /// <summary>セル番号</summary>
        public long m_lCelNumber = 0;
        /// <summary>Ｈ</summary>
        public double[] m_dH = null;
        /// <summary>Ｖ</summary>
        public double[] m_dV = null;
        /// <summary>Ｑ</summary>
        public double[] m_dQ = null;

        /// <summary>祖度</summary>
        public double[] m_dRough = null;
        /// <summary>傾斜</summary>
        public double[] m_dSlope = null;

        /// <summary>長さ</summary>
        public double m_dLength = 100000.0;
        /// <summary>幅</summary>
        public double m_dWidth = 200.0;
        /// <summary>セル長</summary>
        public double m_dCelLength = 100000.0 / 50.0;


        /// <summary>デフォルトの　横流入する支川の位置（上流からのセル番号：０相対）</summary>
        public long m_lDefaultInLQ = 0;

        /// <summary>各セル（０相対）へ横流入する流量</summary>
        public double[] m_dInQ = null;


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McPrimitiveKinematicWaveCalInfo csRtn = new McPrimitiveKinematicWaveCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McPrimitiveKinematicWaveCalInfo csOrgDt = (McPrimitiveKinematicWaveCalInfo)csOrgInfo;
            this.m_lCelNumber = csOrgDt.m_lCelNumber;

            this.m_dH = new double[csOrgDt.m_lCelNumber];
            this.m_dV = new double[csOrgDt.m_lCelNumber];
            this.m_dQ = new double[csOrgDt.m_lCelNumber];
            this.m_dRough = new double[csOrgDt.m_lCelNumber];
            this.m_dSlope = new double[csOrgDt.m_lCelNumber];

            for (long lLp = 0; lLp < csOrgDt.m_lCelNumber; lLp++)
            {
                this.m_dH[lLp] = csOrgDt.m_dH[lLp];
                this.m_dV[lLp] = csOrgDt.m_dV[lLp];
                this.m_dQ[lLp] = csOrgDt.m_dQ[lLp];
                this.m_dRough[lLp] = csOrgDt.m_dRough[lLp];
                this.m_dSlope[lLp] = csOrgDt.m_dSlope[lLp];
            }

            this.m_dLength = csOrgDt.m_dLength;
            this.m_dWidth = csOrgDt.m_dWidth;
            this.m_dCelLength = csOrgDt.m_dCelLength;


            this.m_lDefaultInLQ = csOrgDt.m_lDefaultInLQ;
            for (long lLp = 0; lLp < csOrgDt.m_lCelNumber; lLp++)
            {
                this.m_dInQ[lLp] = csOrgDt.m_dInQ[lLp];
            }
            return true;
        }

    }
}
