﻿// <summary>ソースコード：サンプルプロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>サンプルプロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    public partial class McDotNetModelSamplePropertyDetailForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McDotNetModelSamplePropertyDetailForm csSamplePropertyDetailForm = new McDotNetModelSamplePropertyDetailForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDotNetModelSamplePropertyDetailForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            // 画面表示情報編集

            // ↓↓↓↓↓サンプルロジック↓↓↓↓↓
            McModelPropertyInfo csModelPropertyInfo = m_csPropertyInfo as McModelPropertyInfo;
            if (csModelPropertyInfo != null)
            {
                textBox1.Text = csModelPropertyInfo.GetStepTime().ToString();
            }
            // ↑↑↑↑↑サンプルロジック↑↑↑↑↑
        }

        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「設定」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「設定」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalOK()
        {
            return;
        }
        /// <summary><para>method outline:</para>
        /// <para>最終オペレーター設定「キャンセル」ボタン押下通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FinalCancel()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>詳細画面を呼び出した画面で「キャンセル」ボタンが押下された事を通知する</para>
        /// </remarks>
        public override void FinalCancel()
        {
            return;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>作業フォルダ設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button1_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button1_Click(object sender, EventArgs e)
        {
            // 作業フォルダ設定ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>配列データファイル設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button2_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button2_Click(object sender, EventArgs e)
        {
            // 配列データファイル設定ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデルデータファイル設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button3_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button3_Click(object sender, EventArgs e)
        {
            // モデルデータファイル設定ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル入力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button4_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button4_Click(object sender, EventArgs e)
        {
            // ファイル入力ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ファイル出力ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button5_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button5_Click(object sender, EventArgs e)
        {
            // ファイル出力ボタン押下時の処理を記述する。
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button5_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button6_Click(object sender, EventArgs e)
        {
            // 設定ボタン押下時の処理を記述する。
            // ①入力データの整合性チェックする。
            // 　入力データに異常があれば異常項目を通知し、メソッド終了（return）
            // ②既存の情報と変更があるかチェックする。
            // ③②で変更があった場合
            // 　入力データの保存をする。
            // 　m_csPropertyInfoおよびm_csInitialInfoへ入力データを保存
            // 　DialogResultへDialogResult.OKをセット
            // ③②で変更が無かった場合
            // 　DialogResultへDialogResult.Cancelをセット
            // ④画面終了（Close）

            DialogResult = DialogResult.OK;     // 設定変更がある場合

            DialogResult = DialogResult.Cancel; // 設定変更がない場合

            Close();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタンクリック処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>button5_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void button7_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}