﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.TestModel
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class TestModelDefine
    {
        // ToDo
        // 下記にとらわれず、必要と思われる定義を設定して下さい。（自DLL内クラスで共通に使用すると思われる常数）

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("UserAnalysisTestModelFactory");

        /// <summary>モデルプロパティ設定画面用ファクトリクラス（独自画面作成時に必要：モデルが独自のプロパティ画面を持たないときは不用です）</summary>
        public static HySID PROPERTY_SCREEN_FACTORY_LIB_ID = new HySID("PrptyScrnUserAnalysisTestModelFactory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>テスト用 モデル種別</summary>
        public static readonly HySObjectKind MyForecastModel_MODEL_KIND = new HySObjectKind("MyForecastModel");
        /// <summary>テスト用 モデル名称</summary>
        public static readonly HySString MyForecastModel_MODEL_NAME = new HySString(Properties.Resources.STRING_FOREMODEL_NAME);
        /// <summary>上流端入力</summary>
        public static readonly HySID Upper = new HySID("upper");
        /// <summary>下流端出力</summary>
        public static readonly HySID Lower = new HySID("lower");

        /// <summary>テスト用 モデル種別</summary>
        public static readonly HySObjectKind MyStateCalModel_MODEL_KIND = new HySObjectKind("MyStateCalModel");
        /// <summary>テスト用 モデル名称</summary>
        public static readonly HySString MyStateCalModel_MODEL_NAME = new HySString(Properties.Resources.STRING_STATEMODEL_NAME);


        //<@Add_> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
    }
}
