﻿
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
    /// <para>線形貯水池モデルで用いる共通の変数を定義するクラス</para>
	/// </summary>
    public class LinearReservoirModelDefine
	{
		// ****************************
		// ===== ModelPattern ========
		// ****************************
		/// <summary>デフォルトのモデルファクトリ識別子の設定</summary>
        public static readonly HySID MODEL_LIB = new HySID("CommonMPIntroduction.LinearReservoirModel.Factory");
		/// <summary>独自画面のモデルプロパティ設定画面を作成する場合のファクトリクラス識別子の設定</summary>
        public static HySID PROPERTY_SCREEN_FACTORY_LIB_ID = new HySID("CommonMPIntroduction.LinearReservoirModel.OriginalFactory");

        /// <summary>線形貯水池モデルの種別の設定</summary>
        public static readonly HySObjectKind MODEL_KIND = new HySObjectKind("CommonMPIntroduction.LinearReservoirModel");
        /// <summary>線形貯水池モデルの名前の設定</summary>
		public static readonly HySString MODEL_NAME = new HySString("CommonMP入門：線形貯水池モデル");

		// ********************************
		// ===== DataPattern ========
		// ********************************

		/// <summary>上流端入力のパターンを表わす名称の設定</summary>
		public static readonly HySID IN_PATTERN_TOP = new HySID("TopIn");

        /// <summary>下流端出力のパターンを表わす名称の設定</summary>
		public static readonly HySID OUT_PATTERN_BOTTOM = new HySID("BottomOut");

	}
}
