﻿using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
    /// <para>LinearReservoirモデルファクトリクラスの定義</para>
	/// </summary>
	public class LinearReservoirModelFactory : McBasicModelFactoryBase
	{
		/// <summary><para>method outline:</para>
		/// <para>デフォルトコンストラクタを定義する</para>
		/// </summary>
		/// <param name="">無し</param>
		/// <returns>インスタンス</returns>
		/// <exception cref="">無し</exception>
		public LinearReservoirModelFactory( )
		{
		}

		/// <summary><para>method outline:</para>
		/// <para>ファクトリ識別子を生成する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> HySID csFactID = CreateFactoryID( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>ファクトリ識別子</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override HySID CreateFactoryID()
		{
            return LinearReservoirModelDefine.MODEL_LIB;
		}

		/// <summary><para>method outline:</para>
		/// <para>演算モデルクラスを生成する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
		/// </example>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>演算モデルクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCalModel CreateCalModel(HySObjectKind csModelKind)
		{
			McCalModel csCalModel = null;
            if (csModelKind == LinearReservoirModelDefine.MODEL_KIND)
			{
				csCalModel = new LinearReservoirModel();
			}
			else
			{
			}
			
			return csCalModel;
		}

		/// <summary><para>method outline:</para>
		/// <para>要素内演算中データクラスを生成する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
		/// </example>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>要素内演算中データクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
		{
			McCalInfo csCalInfoData = null;


            if (csModelKind == LinearReservoirModelDefine.MODEL_KIND)
			{
				csCalInfoData = new LinearReservoirModelCalInfo();
			}
			else
			{
			}

			return csCalInfoData;
		}

		/// <summary><para>method outline:</para>
		/// <para>モデルプロパティ表示／設定情報を設定する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
		/// </example>
		/// <param name="csLibraryID">ライブラリー識別子</param>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>モデルプロパティ表示／設定情報クラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
		{
			if (this.EqualFactory(csLibraryID) == false)
			{
				return null;
			}

			McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == LinearReservoirModelDefine.MODEL_KIND)
			{

				csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
				csRtnCellPrptyDt.SetStepTime(60);

                csRtnCellPrptyDt.AddInfoType("m_k", "S = kQ の係数 k [sec], ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_k", 3600.0);

				McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                    LinearReservoirModelDefine.IN_PATTERN_TOP,
					McTranInfoDefine.SINGLE_CELL_SERIAL,
					"上流端流入") as McTranInfoPattern;
				{
					HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
					{
						csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
					}
					csTrnPtn.SetCellDataCharacteristic(csCellChara);
					csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);
				}
				csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

				csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                    LinearReservoirModelDefine.OUT_PATTERN_BOTTOM,
					McTranInfoDefine.SINGLE_CELL_SERIAL,
					"下流端出力") as McTranInfoPattern;
				{
					HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
					{
						csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        csCellChara.SetDataKind(1, "貯留量", HySDataKindDefine.WATER_VOLUME, "m3");
					}
					csTrnPtn.SetCellDataCharacteristic(csCellChara);
				}

				csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

			}
			else
			{
				// Do nothing
			}

			return csRtnCellPrptyDt;
		}


		/// <summary><para>method outline:</para>
		/// <para>モデル初期化表示／設定情報を設定する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
		/// </example>
		/// <param name="csLibraryID">ライブラリー識別子</param>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>初期情報クラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
		{
			if (this.EqualFactory(csLibraryID) == false)
			{
				return null;
			}

			McInitialInfo csRtnDt = null;

            if (csModelKind == LinearReservoirModelDefine.MODEL_KIND)
			{
				csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

				csRtnDt.AddInfoType("m_storage", "初期貯留量(m3)", McDefine.ValKind.DOUBLE);
				csRtnDt.SetInfo("m_storage", 10.0);
			}
			else
			{
				// Do Nothing
			}

			return csRtnDt;
		}

		/// <summary><para>method outline:</para>
		/// <para>モデル情報を設定する</para>
		/// </summary>
		/// <example>
		/// <para>usage:</para>
		/// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>モデル情報のリスト</returns>
		/// <exception cref="">無し</exception>
		/// <remarks>
		/// <para>remarks:</para>
		/// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
		/// </remarks>
		public override HySDataLinkedList GetCalModelInfoList()
		{
			McModelInfo csModelInfo=null;


			csModelInfo = new McModelInfo(
					(HySID)this.GetFactoryID(),
					McModelLibraryDefine.DIVISION_CALCULATION_MODEL,  // 演算要素への登録
                    // McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_HYDROLOGY,  // 水文への登録 
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_RIVER,         // 河川への登録
                    LinearReservoirModelDefine.MODEL_KIND,
                    LinearReservoirModelDefine.MODEL_NAME);
            csModelInfo.SetVersionInf("Ver1.3 March 11, 2011");
			csModelInfo.SetSummaryInf("線形貯水池モデル");
			csModelInfo.SetCreatorInf("CommonMP入門：執筆者");
			csModelInfo.SetIconName("Lane");
            csModelInfo.SetManualFileName(".\\CommonMPIntroduction\\linearReservoirModel.pdf");
			m_csCalModelInforList.AddLast(csModelInfo);

			return m_csCalModelInforList;
		}

	}
}


namespace CommonMP.HYMCO._SYSTEM_
{
	/// <summary><para>class outline:</para>
    /// <para>LinearReservoirModelモデルファクトリクラス</para>
	/// </summary>
	public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
	{
		/// <summary><para>method outline:</para>
		/// <para>コンストラクター</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>生成インスタンス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
		{
		}
		/// <summary><para>method outline:</para>
		/// <para>演算モデルファクトリクラス生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>演算モデルファクトリクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
		{
            return new CommonMPIntroduction.LinearReservoirModelFactory();
		}
	}
}