﻿using System;

using CommonMP.HYMCO.Interface.Data;


namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
	/// <para>線形貯水池モデルのデータクラスの定義</para>
	/// </summary>
	[Serializable]
	public class LinearReservoirModelCalInfo : McCalInfo
	{
		/// <summary> S = kQ の k </summary>
		public double m_k;

		/// <summary> 計算時間間隔 </summary>
		public double m_dt;

		/// <summary> 貯留量 </summary>
		public double m_storage;

		/// <summary> 流出量 </summary>
		public double m_outflow;

		/// <summary><para>method outline:</para>
		/// <para>自己複製</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> Clone( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>同一内容で　別インスタンス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
		/// </remarks>
		public override McCalInfo Clone()
		{
			LinearReservoirModelCalInfo csRtn = new LinearReservoirModelCalInfo();
			csRtn.CopyInfo(this);
			return csRtn;
		}
		/// <summary><para>method outline:</para>
		/// <para>引数で与えられた情報を自分にコピーを行う</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
		/// </example>
		/// <param name="csOrgInfo">コピー元情報</param>
		/// <returns> bool true :正常 , false:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override bool CopyInfo(McCalInfo csOrgInfo)
		{
			LinearReservoirModelCalInfo csOrgDt = (LinearReservoirModelCalInfo)csOrgInfo;
			this.m_k = csOrgDt.m_k;
			this.m_dt = csOrgDt.m_dt;
			this.m_storage = csOrgDt.m_storage;
			this.m_outflow = csOrgDt.m_outflow;

			return true;
		}

	}
}
