﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;



namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
	/// <para>テスト用流量発生クラス</para>
	/// </summary>
	/// <remarks><para>history:</para>
	/// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
	/// </remarks>
	
    //public class GenerateHydrologyData : McForecastModelBase
    // McForecastModelBase を継承してモデルを作成すると、ピーク流量発生時刻が
    // 設定した時刻＋Δtとなってしまう。McStateCalModelBase を継承すると問題ない。
    public class GenerateHydrologyData : McStateCalModelBase
	{
		/// <summary>流域計算情報</summary>
		GenerateHydrologyDataInfo m_csBasinInfo = null;
		
		// =========================
		// 演算実行前処理関連メソッド
		// =========================

		/// <summary><para>method outline:</para>
		/// <para>モデルを初期化する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>Initialize(csInitialData)</para>
		/// </example>
		/// <param name="csInitialData">初期化設定情報</param>
		/// <param name="lInputDataNum">入力情報数</param>
		/// <param name="csInputCellData">演算に必要な入力情報配列</param>
		/// <returns>無し</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
		{
           // ver1.5 エラートレース日本語対応
			McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "Initialize", Properties.Resources.STATEMENT_INIT );
           // McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "Initialize", "<<Init>>");
            // 使用しやすいようにキャストしておく
			// m_csBasinInfo = (McSampleBasinCalInfo)m_csCalInfo;
			if (csInitialData != null)
			{
				m_csBasinInfo.m_dOutflow = m_csBasinInfo.m_dQbasic;
			}

			return true;
		}
		/// <summary><para>method outline:</para>
		/// <para>モデルを初期化する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>OnlineInitialize(csInitialData)</para>
		/// </example>
		/// <param name="csInitialData">初期化設定情報</param>
		/// <param name="lInputDataNum">入力情報数</param>
		/// <param name="csInputCellData">演算に必要な入力情報配列</param>
		/// <returns>bool</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		protected override bool OnlineInitialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
		{
			// Do Nothing
			return true;
		}
		/// <summary><para>method outline:</para>
		/// <para>入力側の接続情報チェック</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
		/// </example>
		/// <param name="csErrorInf">エラー出力</param>
		/// <param name="lInputDataNum">入力情報数</param>
		/// <param name="csInputCellData">演算に必要な入力情報配列</param>
		/// <returns>=true:正常、=false:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
		/// </remarks>
		protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
		{
			bool bRtn = true;
			if (lInputDataNum > 0)
			{
				// エラー
               // ver1.5 エラートレース日本語対応
				csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND, 
                     Properties.Resources.STATEMENT_NO_RECEIVE_DATA );
               // csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND, "Cannot receive data.");
                bRtn = false;
			}
			return bRtn;
		}
		/// <summary><para>method outline:</para>
		/// <para>出力側の接続情報チェック</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
		/// </example>
		/// <param name="csErrorInf">エラー出力</param>
		/// <param name="lOutputDataNum">出力情報数</param>
		/// <param name="csOutputCellData">出力情報配列</param>
		/// <returns>=true:正常、=false:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
		/// </remarks>
		protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
		{
			bool bRtn = true;

			if (lOutputDataNum == 0)
			{
				// 警告（エラーではない）
               // ver1.5 エラートレース日本語対応
				csErrorInf.AddCheckWarningData(this.GetID(), ToolDefine.GENERATE_DATA_KIND,
                     Properties.Resources.STATEMENT_NO_SND_PORT );
               // csErrorInf.AddCheckWarningData(this.GetID(), ToolDefine.GENERATE_DATA_KIND, "No send port.");
            }
			for (long lP = 0; lP < lOutputDataNum; lP++)
			{   // 出力側接続線数分チェックを行う
				long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
				long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);
				if (lCellDim == 1 && lD1==1)
				{   // 1次元配列で1セルならば
					if (lCellDataNum < 1)
					{   // セル内の変数の数
                       // ver1.5 エラートレース日本語対応
						csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND,
                            Properties.Resources.STATEMENT_VAL_NUM_SHORT_S  + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND,
                       //     "Variable number in the Cells is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        bRtn = false;
					}
				}
				else
				{
					// エラー
                   // ver1.5 エラートレース日本語対応
					csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND,
                                            Properties.Resources.STATEMENT_UNEXPECT_DATA_TYPE_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), ToolDefine.GENERATE_DATA_KIND,
                   //                         "Unexpected send data type. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");

					bRtn = false;
				}
			}
			return bRtn;
		}

		// =======================
		// 演算実行処理関連メソッド
		// =======================

		/// <summary><para>method outline:</para>
		/// <para>モデル演算</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>long lRtn = Calculate(ref csInputCellData)</para>
		/// </example>
		/// <param name="lInputDataNum">入力情報数</param>
		/// <param name="csInputCellData">演算に必要な入力情報配列</param>
		/// <returns>=0:正常 -1:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		protected override long Calculate(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
		{
           // ver1.5 エラートレース日本語対応
			McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "Calculate", Properties.Resources.STATEMENT_START );
           // McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "Calculate", "<<Start>>");
            // this.m_csTotalPassingTime には シミュレーション開始時刻からの経過時間が入っている
			m_csBasinInfo.m_dTau = this.m_csTotalPassingTime.TotalSec() / m_csBasinInfo.m_csTpeak.TotalSec();
			
			m_csBasinInfo.m_dOutflow =
				(m_csBasinInfo.m_dQbasic + (m_csBasinInfo.m_dQpeak - m_csBasinInfo.m_dQbasic) 
				* (Math.Pow((m_csBasinInfo.m_dTau * Math.Exp(1.0 - m_csBasinInfo.m_dTau)), m_csBasinInfo.m_dCp)));

			
			return 0;
		}

		/// <summary><para>method outline:</para>
		/// <para>モデル演算結果を外部のエレメントに対して公開する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
		/// </example>
		/// <param name="lOutputDataNum">出力情報数</param>
		/// <param name="csOutputCellData">出力情報配列</param>
		/// <returns>=0:正常 -1:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
		{
           // ver1.5 エラートレース日本語対応
			McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "DataFusion", Properties.Resources.STATEMENT_START );
           // McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "DataFusion", "<<Start>>");
            HySCellData[] csSndCellData = null;
			for (long lP = 0; lP < m_lOutputDataNum; lP++)
			{
				csSndCellData = csOutputCellData[lP].PrepareSendCellD1();
				csSndCellData[0].m_dData[0] = m_csBasinInfo.m_dOutflow;
               // ver1.5 エラートレース日本語対応
				McLog.DebugOut(this.m_csSimTime, GetID(), "HydrologyFlowBasin", "DataFusion", 
                      Properties.Resources.STATEMENT_OUT + m_csBasinInfo.m_dOutflow.ToString() );
               // McLog.DebugOut(this.m_csSimTime, GetID(), "HydrologyFlowBasin", "DataFusion", " Outflow:" + m_csBasinInfo.m_dOutflow.ToString());
            }
			return 0;
		}
		// ====================
		// その他必要なメソッド
		// ====================

		/// <summary><para>method outline:</para>
		/// <para>プロパティ情報を設定する</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>SetProperty(csCellMdlPropertyInfo)</para>
		/// </example>
		/// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
		/// <returns>無し</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
		{
           // ver1.5 エラートレース日本語対応
			McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "SetProperty", Properties.Resources.STATEMENT_INIT );
           // McLog.DebugOut(m_csSimTime, GetID(), GetType().ToString(), "SetProperty", "<<Init>>");
            // 使用しやすいようにキャストしておく
			m_csBasinInfo = (GenerateHydrologyDataInfo)m_csCalInfo;

			McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
			if (csPrptyInfo != null)
			{
				// 計算パラメーター
				csPrptyInfo.GetInfo("m_dQbasic", ref m_csBasinInfo.m_dQbasic);
				csPrptyInfo.GetInfo("m_dQpeak", ref m_csBasinInfo.m_dQpeak);
				csPrptyInfo.GetInfo("m_dCpeak", ref m_csBasinInfo.m_dCp);

				double timePeak = 3600.0;
				csPrptyInfo.GetInfo("m_dTpeak", ref timePeak);
				m_csBasinInfo.m_csTpeak = new HySTime(timePeak * 60.0 * 60.0);  // modified by YT, Aug. 16, 2010.

				// 演算ステップ時刻設定
				this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());
			}
			else
			{
				m_csBasinInfo = (GenerateHydrologyDataInfo)m_csCalInfo;

				m_csBasinInfo.m_dQbasic = 200.0; // m3/s
				m_csBasinInfo.m_dQpeak = 2000.0; // m3/s
				m_csBasinInfo.m_csTpeak = new HySTime(12, 0, 0); // 12Hr
				m_csBasinInfo.m_dCp = 10.0; // 
				this.m_csDltTime = new HySTime(72); // 72秒   new HySTime(1, 0, 0);  // 1時間
			}
			return true;
		}
		/// <summary><para>method outline:</para>
		/// <para>演算実行中断中のプロパティ等情報設定</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para>bool bRtn = SetOnlineProperty(csCellMdlPropertyInfo)</para>
		/// </example>
		/// <param name="csCellMdlPropertyInfo">プロパティ情報</param>
		/// <returns>無し</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
		/// </remarks>
		public override bool SetOnlineProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
		{
			// プロパティ設定
			McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
			if (csPrptyInfo != null)
			{
				// To Do
				// モデルの係数等、必要な情報に対して、引数で与えられたプロパティ情報の内容を読み取って、設定していきます。
				// 但し、実行中に変更して困る情報は設定しないで下さい。
			}
			return true;
		}
		// 
	}
}
