﻿
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
	/// <para>KyotoUniv.Hydrology ツール系モデル共通定義クラス</para>
	/// </summary>
	public class ToolDefine
	{
		
		/// <summary>システムデフォルトモデルファクトリ</summary>
        public static readonly HySID TOOL_LIB = new HySID("CommonMPIntroduction.RunoffGenerationModel.Factory");
		/// <summary>モデルプロパティ設定画面用ファクトリクラス（独自画面作成時に必要）</summary>
        public static HySID PROPERTY_SCREEN_FACTORY_LIB_ID = new HySID("CommonMPIntroduction.RunoffGenerationModel.OriginalFactory");

		/// <summary>GenerateDataモデル種別</summary>
        public static readonly HySObjectKind GENERATE_DATA_KIND = new HySObjectKind("CommonMPIntroduction.RunoffGenerationModel");
		/// <summary>GenerateDataモデル名称</summary>
        public static readonly HySString GENERATE_DATA_NAME = new HySString("CommonMP入門：模擬流量発生モデル");
		

		// ********************************
		// ===== DataPattern ========
		// ********************************
		/// <summary>下流端出力</summary>
		public static readonly HySID OUT_PATTERN_BOTTOM = new HySID("BottomOut");
		/// <summary> DivisionPoint 第二出力</summary>
		public static readonly HySID OUT_PATTERN_SECOND = new HySID("SecondOut");
		/// <summary> 任意</summary>
		public static readonly HySID IN_OUT_PATTERN_ANY = new HySID("ANY");
		/// <summary> FileInput2D 任意</summary>
		public static readonly HySID IN_OUT_PATTERN_2D = new HySID("ANY2D");

		/// <summary>CompareData 第1入力</summary>
		public static readonly HySID INPUT_1 = new HySID("Input1");
		/// <summary>CompareData 第2入力</summary>
		public static readonly HySID INPUT_2 = new HySID("Input2");
	}
}
