﻿
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
	/// <para>KyotoUniv.Hydrologyツール系モデルファクトリクラス</para>
	/// </summary>
	public class ToolFactory : McBasicModelFactoryBase
	{
		/// <summary><para>method outline:</para>
		/// <para>デフォルトコンストラクタ</para>
		/// </summary>
		/// <param name="">無し</param>
		/// <returns>インスタンス</returns>
		/// <exception cref="">無し</exception>
		public ToolFactory()
		{
		}

		/// <summary><para>method outline:</para>
		/// <para>ファクトリ識別子を生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> HySID csFactID = CreateFactoryID( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>ファクトリ識別子</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override HySID CreateFactoryID()
		{
			return ToolDefine.TOOL_LIB;
		}

		/// <summary><para>method outline:</para>
		/// <para>演算モデルクラス生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
		/// </example>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>演算モデルクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCalModel CreateCalModel(HySObjectKind csModelKind)
		{
			McCalModel csCalModel = null;

            if (csModelKind == ToolDefine.GENERATE_DATA_KIND)
		    {
				csCalModel = new GenerateHydrologyData();
			}

			else
			{
			}
			
			return csCalModel;
		}

		/// <summary><para>method outline:</para>
		/// <para>要素内演算中データクラス生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
		/// </example>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>要素内演算中データクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
		{
			McCalInfo csCalInfoData = null;

			if (csModelKind == ToolDefine.GENERATE_DATA_KIND)
			{
				csCalInfoData = new GenerateHydrologyDataInfo();
			}
			else
			{
			}

			return csCalInfoData;
		}

		/// <summary><para>method outline:</para>
		/// <para>モデルプロパティ表示／設定情報クラス生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
		/// </example>
		/// <param name="csLibraryID">ライブラリー識別子</param>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>モデルプロパティ表示／設定情報クラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
		{
			if (this.EqualFactory(csLibraryID) == false)
			{
				return null;
			}

			McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == ToolDefine.GENERATE_DATA_KIND)
			{   // テスト用流量発生クラス
				csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

				csRtnCellPrptyDt.SetStepTime(60); // δT設定 秒

				csRtnCellPrptyDt.AddInfoType("m_dQbasic", "基底流量", McDefine.ValKind.DOUBLE);
				csRtnCellPrptyDt.SetInfo("m_dQbasic", 50.0);
				csRtnCellPrptyDt.AddInfoType("m_dQpeak", "ピーク流量", McDefine.ValKind.DOUBLE);
				csRtnCellPrptyDt.SetInfo("m_dQpeak", 2000.0);
				csRtnCellPrptyDt.AddInfoType("m_dTpeak", "ピーク生起時間(単位: hr)", McDefine.ValKind.DOUBLE);
				csRtnCellPrptyDt.SetInfo("m_dTpeak", 10.0);
				csRtnCellPrptyDt.AddInfoType("m_dCpeak", "係数c", McDefine.ValKind.DOUBLE);
				csRtnCellPrptyDt.SetInfo("m_dCpeak", 10.0);

				// 送信パターンの設定
				McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
					ToolDefine.OUT_PATTERN_BOTTOM,
					McTranInfoDefine.SINGLE_CELL_SERIAL,
					"データ出力") as McTranInfoPattern;
				{
					// csTrnPtn.SetDim(1); // セルの配列（1次元：1個のみ）
					// セル内変数設定
					HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
					{
						csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
					}
					csTrnPtn.SetCellDataCharacteristic(csCellChara);
				}
				csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

			}
			else 
			{
				// Do nothing
			}

			return csRtnCellPrptyDt;
		}
		/// <summary><para>method outline:</para>
		/// <para>モデル初期化表示／設定情報生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
		/// </example>
		/// <param name="csLibraryID">ライブラリー識別子</param>
		/// <param name="csModelKind">モデル種別識別子</param>
		/// <returns>初期情報クラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
		{
			if (this.EqualFactory(csLibraryID) == false)
			{
				return null;
			}

			McInitialInfo csRtnDt = null;

			if (csModelKind == ToolDefine.GENERATE_DATA_KIND)
			{
				csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
			}
			else
			{
				// Do Nothing
			}

			return csRtnDt;
		}

		/// <summary><para>method outline:</para>
		/// <para>モデル情報提供</para>
		/// </summary>
		/// <example>
		/// <para>usage:</para>
		/// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>モデル情報のリスト</returns>
		/// <exception cref="">無し</exception>
		/// <remarks>
		/// <para>remarks:</para>
		/// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
		/// </remarks>
		public override HySDataLinkedList GetCalModelInfoList()
		{
			McModelInfo csModelInfo = null;
			
			csModelInfo = new McModelInfo(
					(HySID)this.GetFactoryID(),
					McModelLibraryDefine.DIVISION_CALCULATION_MODEL,
					//McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_HYDROLOGY,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_RIVER,
					ToolDefine.GENERATE_DATA_KIND,
					ToolDefine.GENERATE_DATA_NAME);
            csModelInfo.SetVersionInf("Ver1.3 March 11, 2011");
			csModelInfo.SetSummaryInf("テスト用流量を発生する際に用いるモデル");
            csModelInfo.SetCreatorInf("CommonMP入門：執筆者");
            csModelInfo.SetIconName("DefaultModel");
            csModelInfo.SetManualFileName(".\\CommonMPIntroduction\\runoffGenerationModel.pdf");
            m_csCalModelInforList.AddLast(csModelInfo);

			return m_csCalModelInforList;
		}
	}
}

namespace CommonMP.HYMCO._SYSTEM_
{
	/// <summary><para>class outline:</para>
	/// <para>KyotoUniv.Hydrologyツール系モデルファクトリクラス</para>
	/// </summary>
	public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
	{
		/// <summary><para>method outline:</para>
		/// <para>コンストラクター</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>生成インスタンス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
		{
		}
		/// <summary><para>method outline:</para>
		/// <para>演算モデルファクトリクラス生成</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>演算モデルファクトリクラス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
		{
            return new CommonMPIntroduction.ToolFactory();
		}
	}
}