﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMPIntroduction
{
	/// <summary><para>class outline:</para>
	/// <para>テスト用流量発生モデル内演算データクラス</para>
	/// </summary>
	/// <remarks><para>history:</para>
	/// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
	/// <para>remarks</para>
	/// <para>演算中の状態、初期条件等を保持するデータクラス</para>
	/// </remarks>
	[Serializable]
	class GenerateHydrologyDataInfo : McCalInfo
	{
		// 計算専用変数
		// public double m_dWidth = 200.0; // m
		public double m_dQbasic = 200.0; // m3/s
		public double m_dQpeak = 2000.0; // m3/s
		public HySTime m_csTpeak = new HySTime(12, 0, 0); // 12Hr
		public double m_dCp = 10.0; // 
		public double m_dOutflow = 0.0; // m3/s

		public double m_dTau = 0.0;

		// モデル外へのデータの送信関係等制御
		/// <summary>セル情報管理 </summary>
		public McCellIDMngData m_csOutCellIDMng = new McCellIDMngData();

		//// <summary>セル内情報の種別</summary>
		// public HySDataCharacteristicInCell m_csCellDataKind = new HySDataCharacteristicInCell(1);
		//// <summary> セル内情報の数 </summary>
		// public long m_lCellDataDim = 1;


		/// <summary><para>method outline:</para>
		/// <para>自己複製</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> Clone( ) </para>
		/// </example>
		/// <param name="">無し</param>
		/// <returns>同一内容で　別インスタンス</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
		/// </remarks>
		public override McCalInfo Clone()
		{
			GenerateHydrologyDataInfo csRtn = new GenerateHydrologyDataInfo();
			csRtn.CopyInfo(this);
			return csRtn;
		}
		/// <summary><para>method outline:</para>
		/// <para>引数で与えられた情報を自分にコピーを行う</para>
		/// </summary>
		/// <example><para>usage:</para>
		/// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
		/// </example>
		/// <param name="csOrgInfo">コピー元情報</param>
		/// <returns> bool true :正常 , false:異常</returns>
		/// <exception cref="">無し</exception>
		/// <remarks><para>remarks:</para>
		/// <para>無し</para>
		/// </remarks>
		public override bool CopyInfo(McCalInfo csOrgInfo)
		{
			GenerateHydrologyDataInfo csOrgDt = (GenerateHydrologyDataInfo)csOrgInfo;
			this.m_dQbasic = csOrgDt.m_dQbasic;
			this.m_dQpeak = csOrgDt.m_dQpeak;
			this.m_dCp = csOrgDt.m_dCp;
			this.m_dOutflow = csOrgDt.m_dOutflow;
			this.m_dTau = csOrgDt.m_dTau;
			this.m_csTpeak = csOrgDt.m_csTpeak.Clone();
			// if (csOrgDt.m_csOutCellIDMng != null)
			// {
			//	this.m_csOutCellIDMng = csOrgDt.m_csOutCellIDMng.Clone();
			// }

			return true;
		}

	}
}
