﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptionl.HymcoModelDLLWrapper;

//using CommonMP.HYMCO.Interface.Data;
//using CommonMP.HYMCO.Interface.Model;
//using CommonMP.HYMCO.CoreImpl.Data;
//using CommonMP.HYMCO.CoreImpl.Model;

namespace CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp
{
    /// <summary><para>class outline:</para>
    /// <para>フォートラン要素モデル情報格納クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2011/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class Mc32BitFortranModelInfo : HySDataRoot, HySVersionManagement 
    {
        /// <summary> モデル名称 </summary>
        protected HySString m_csModelName = null;

        /// <summary>FortranDLL 情報ファイル（XML)名 </summary>
        protected HySString m_csMdlInfoXMLFileName = null;

        /// <summary>３２ビット／６４ビット区分（フォートランコンパイラーは何ビットでコンパイルされたか？）</summary>
        protected long m_lNativeBit = 32;

        /// <summary>FortranDLL ファイル名 </summary>
        protected HySString     m_csDLLFileName=null;

        /// <summary> DLL識別子 </summary>
        protected HySID m_csDLLID = Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB;
        /// <summary> モデルの分類 </summary>
        protected HySObjectKind m_csCategory=null;
        /// <summary> モデルの種類 </summary>
        protected HySObjectKind m_csModelKind = null;

        /// <summary> モデルのプロパティ情報 </summary>
        protected Mc32BitFortranModelPropertyInfo m_csMdlProperty = null;

        /// <summary> モデルの初期化情報 </summary>
        protected Mc32BitFortranModelInitialData m_csMdlInitial = null;

        /// <summary> マニュアルを記述したファイル名 </summary>
        protected HySString m_csManualFileName = null;
        /// <summary> アイコン名 </summary>
        protected HySString m_csIconName = new HySString("FortranModel");
        /// <summary> モデルのバージョン </summary>
        protected HySString m_csModelVer = new HySString("1.0");
        /// <summary> モデルの概要説明 </summary>
        protected HySString m_csModelSummary = new HySString("");
        /// <summary> モデル作成者 </summary>
        protected HySString m_csCreatorInf = new HySString("");

 
        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlOUT(string csXmlNameWithPath)
        {
            bool bRtn = false;
            HySXmlWriter csXmlWriter = new HySXmlWriter(csXmlNameWithPath);
            if (csXmlWriter != null)
            {
                HySXmlNode csRootNode = csXmlWriter.CreateRoot(Mc32BitFortranModelInfo.xml_FortranMdl);
                csRootNode.SetAttribute(Mc32BitFortranModelInfo.xml_MdlName, m_csModelName.ToString());
                csRootNode.SetAttribute(Mc32BitFortranModelInfo.xml_MDLCategory, m_csCategory.ToString());

                csRootNode.SetAttribute(Mc32BitFortranModelInfo.xml_DLLName, m_csDLLFileName.ToString());

                HySXmlNode csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlInfXmlFile, csXmlWriter);
                csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csMdlInfoXMLFileName.ToString());
                csRootNode.AppendChild(csLclNode);
                if ((object)m_csManualFileName != null)
                {
                    csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlManualFile, csXmlWriter);
                    csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csManualFileName.ToString());
                    csRootNode.AppendChild(csLclNode);
                }
                csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlIconName, csXmlWriter);
                csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csIconName.ToString());
                csRootNode.AppendChild(csLclNode);
                csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlVer, csXmlWriter);
                csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csModelVer.ToString());
                csRootNode.AppendChild(csLclNode);
                csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlSummary, csXmlWriter);
                csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csModelSummary.ToString());
                csRootNode.AppendChild(csLclNode);
                csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlCreatorInf, csXmlWriter);
                csLclNode.SetAttribute(Mc32BitFortranModelInfo.xml_Val, m_csCreatorInf.ToString());
                csRootNode.AppendChild(csLclNode);


                HySXmlNode csPrptyNode = m_csMdlProperty.XmlOUT(ref csXmlWriter);
                if (csPrptyNode != null)
                {
                    csRootNode.AppendChild(csPrptyNode);

                    // 受信パターン
                    csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlInputPtn, csXmlWriter);
                    HySDataLinkedList csPtnList = m_csMdlProperty.GetReceivePatternList();
                    long lPtnNo = csPtnList.GetCount();
                    McTranInfoPattern csPtn;
                    HySXmlNode csPtnNode;
                    for (long lLp = 0; lLp < lPtnNo; lLp++)
                    {
                        csPtn = csPtnList.GetData(lLp) as McTranInfoPattern;
                        csPtnNode = csPtn.XmlOUT(ref csXmlWriter);
                        csLclNode.AppendChild(csPtnNode);
                    }
                    csRootNode.AppendChild(csLclNode);

                    // 送信パターン
                    csLclNode = HySXmlNode.CreateElement(Mc32BitFortranModelInfo.xml_MdlOutputPtn, csXmlWriter);
                    csPtnList = m_csMdlProperty.GetSendPatternList();
                    lPtnNo = csPtnList.GetCount();
                    for (long lLp = 0; lLp < lPtnNo; lLp++)
                    {
                        csPtn = csPtnList.GetData(lLp) as McTranInfoPattern;
                        csPtnNode = csPtn.XmlOUT(ref csXmlWriter);
                        csLclNode.AppendChild(csPtnNode);
                    }
                    csRootNode.AppendChild(csLclNode);
                }
                HySXmlNode csInitNode = m_csMdlInitial.XmlOUT(ref csXmlWriter);
                if (csInitNode != null)
                {
                    csRootNode.AppendChild(csInitNode);
                }
                csXmlWriter.Save();
                bRtn = true;
            }


            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool XmlIN(string csXmlNameWithPath)
        {
            bool bRtn = false;
            HySFile csFile = new HySFile(csXmlNameWithPath);
            if (csFile.Exist() == true)
            {
                HySXmlReader csXmlReader = new HySXmlReader(csXmlNameWithPath);
                HySXmlNode csRootNode = csXmlReader.GetRootNode();
                if (csRootNode != null)
                {
                    // 属性
                    string sWork = csRootNode.GetAttribute(Mc32BitFortranModelInfo.xml_MdlName);
                    this.SetModelName(new HySString(sWork));
                    sWork = csRootNode.GetAttribute(Mc32BitFortranModelInfo.xml_MDLCategory);
                    this.SetCategory(new HySObjectKind(sWork));
                    sWork = csRootNode.GetAttribute(Mc32BitFortranModelInfo.xml_DLLName);
                    this.SetDLLName(new HySString(sWork));

                    HySXmlNode csXmlValNode;
                    HySXmlNodeList csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlInfXmlFile);
                    csXmlValNode = csXmlValNodeList.GetNode(0);
                    sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                    this.SetMdlInfoXMLFileName(new HySString(sWork));

                    csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlManualFile);
                    if (csXmlValNodeList.GetCount() >= 1)
                    {
                        csXmlValNode = csXmlValNodeList.GetNode(0);
                        sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                        this.SetManualFileName(new HySString(sWork));
                    }

                    csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlIconName);
                    csXmlValNode = csXmlValNodeList.GetNode(0);
                    sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                    this.SetIconName(new HySString(sWork));

                    csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlVer);
                    csXmlValNode = csXmlValNodeList.GetNode(0);
                    sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                    this.SetModelVer(new HySString(sWork));

                    csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlSummary);
                    csXmlValNode = csXmlValNodeList.GetNode(0);
                    sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                    this.SetModelSummary(new HySString(sWork));

                    csXmlValNodeList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlCreatorInf);
                    csXmlValNode = csXmlValNodeList.GetNode(0);
                    sWork = csXmlValNode.GetAttribute(Mc32BitFortranModelInfo.xml_Val);
                    this.SetCreatorInf(new HySString(sWork));

                    // プロパティ解読
                    m_csMdlProperty = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, m_csModelKind);
                    HySXmlNode csXmlPropertyNode;
                    HySXmlNodeList csXmlPropertyList = csRootNode.GetChildNodeListByTagName(McDefine.xml_PROPERTY);
                    long lPropertyNum = csXmlPropertyList.GetCount(); // 通常は１個
                    for (long lLp = 0; lLp < lPropertyNum; lLp++)
                    {
                        csXmlPropertyNode = csXmlPropertyList.GetNode(lLp);

                        // プロパティタグ内容を読み出す
                        m_csMdlProperty.XmlIN(csXmlPropertyNode);
                    }
                    HySXmlNode csXmlPtnNode;
                    HySXmlNodeList csXmRcvList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlInputPtn);
                    if (csXmRcvList.GetCount() >= 1)
                    {
                        HySXmlNode csXmlRcvNode = csXmRcvList.GetNode(0);

                        HySXmlNodeList csXmlPtnList = csXmlRcvNode.GetChildNodeListByTagName(McTranInfoPattern.xml_TrnInfoRoot);
                        long lPtnNum = csXmlPtnList.GetCount();
                        McTranInfoPattern csTrnPtn = null;
                        for (long lLp = 0; lLp < lPtnNum; lLp++)
                        {
                            csXmlPtnNode = csXmlPtnList.GetNode(lLp);
                            csTrnPtn = new McTranInfoPattern(new HySID(""), new HySObjectKind(""), "");
                            csTrnPtn.XmlIN(csXmlPtnNode);
                            m_csMdlProperty.AddReceivePattern(csTrnPtn);
                        }
                    }
                    HySXmlNodeList csXmSndList = csRootNode.GetChildNodeListByTagName(Mc32BitFortranModelInfo.xml_MdlOutputPtn);
                    if (csXmSndList.GetCount() >= 1)
                    {
                        HySXmlNode csXmlSndNode = csXmSndList.GetNode(0);
                        HySXmlNodeList csXmlPtnList = csXmlSndNode.GetChildNodeListByTagName(McTranInfoPattern.xml_TrnInfoRoot);
                        long lPtnNum = csXmlPtnList.GetCount();
                        McTranInfoPattern csTrnPtn = null;
                        for (long lLp = 0; lLp < lPtnNum; lLp++)
                        {
                            csXmlPtnNode = csXmlPtnList.GetNode(lLp);
                            csTrnPtn = new McTranInfoPattern(new HySID(""), new HySObjectKind(""), "");
                            csTrnPtn.XmlIN(csXmlPtnNode);
                            m_csMdlProperty.AddSendPattern(csTrnPtn);
                        }
                    }


                    // 初期化情報解読
                    m_csMdlInitial = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, m_csModelKind);
                    HySXmlNode csXmlInitalNode;
                    HySXmlNodeList csXmlInitialList = csRootNode.GetChildNodeListByTagName(McDefine.xml_INITIAL_SET);
                    long lInitialNum = csXmlInitialList.GetCount(); // 通常は１個
                    for (long lLp = 0; lLp < lInitialNum; lLp++)
                    {
                        csXmlInitalNode = csXmlInitialList.GetNode(lLp);
                        // 初期情報ノード読み出し

                        // プロパティタグ内容を読み出す
                        m_csMdlInitial.XmlIN(csXmlInitalNode);
                    }

                }

                bRtn = true;
            }
            return bRtn;
        }

        
        // ------------------------------
        // 各種Ｇｅｔｔｅｒ，Ｓｅｔｔｅｒ
        // ------------------------------

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csMdlInfoXMLFileName"></param>
        public void SetMdlInfoXMLFileName(HySString csMdlInfoXMLFileName)
        { m_csMdlInfoXMLFileName = csMdlInfoXMLFileName; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetMdlInfoXMLFileName()
        { return m_csMdlInfoXMLFileName; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csModelName"></param>
        public void SetModelName(HySString csModelName)
        { m_csModelName = csModelName; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetModelName()
        { return m_csModelName; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csDllName"></param>
        public void SetDLLName(HySString csDllName)
        {
            m_csDLLFileName = csDllName;
            m_csModelKind = new HySObjectKind(csDllName);
            m_csMdlProperty = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, m_csModelKind);
            m_csMdlInitial = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, m_csModelKind);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetDLLName()
        { return m_csDLLFileName; }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySID GetDLLID()
        { return m_csDLLID; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csCagegory"></param>
        public void SetCategory(HySObjectKind csCagegory)
        { m_csCategory = csCagegory; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySObjectKind GetCategory()
        { return m_csCategory; }
 
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySObjectKind GetModelKind()
        { return m_csModelKind; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csPrpty"></param>
        public void SetModelProperty(Mc32BitFortranModelPropertyInfo csPrpty)
        { m_csMdlProperty=csPrpty; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Mc32BitFortranModelPropertyInfo GetModelProperty()
        { return m_csMdlProperty; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csInit"></param>
        public void SetModelInitialInfo(Mc32BitFortranModelInitialData csInit)
        { m_csMdlInitial = csInit; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Mc32BitFortranModelInitialData GetModelInitialInfo()
        { return m_csMdlInitial; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csModelVer"></param>
        public void SetModelVer(HySString csModelVer)
        { m_csModelVer = csModelVer; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetModelVer( )
        { return m_csModelVer; }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="csModelSummary"></param>
        public void SetModelSummary(HySString csModelSummary)
        { m_csModelSummary = csModelSummary; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetModelSummary( )
        { return m_csModelSummary; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csCreatorInf"></param>
        public void SetCreatorInf(HySString csCreatorInf)
        { m_csCreatorInf = csCreatorInf; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetCreatorInf( )
        { return m_csCreatorInf; }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="csIconName"></param>
        public void SetIconName(HySString csIconName)
        { m_csIconName = csIconName; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetIconName( )
        { return m_csIconName; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csManualFileName"></param>
        public void SetManualFileName(HySString csManualFileName)
        { m_csManualFileName = csManualFileName; }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public HySString GetManualFileName( )
        { return m_csManualFileName; }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public McModelInfo CreateModelInfo()
        {
            McModelInfo csModelInfo = null;
            csModelInfo = new McModelInfo(
                    m_csDLLID,
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    m_csCategory, // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    m_csModelKind, // モデルの識別子
                    m_csModelName  // モデルの名称
                                    );

            if ((object)m_csModelVer != null)
            {
                csModelInfo.SetVersionInf(m_csModelVer);
            }
            if ((object)m_csModelSummary != null)
            {
                csModelInfo.SetSummaryInf(m_csModelSummary);
            }
            if ((object)m_csCreatorInf != null)
            {
                csModelInfo.SetCreatorInf(m_csCreatorInf);
            }
            if ((object)m_csIconName != null)
            {
                csModelInfo.SetIconName(m_csIconName);
            }
            if ((object)m_csManualFileName != null)
            {
                csModelInfo.SetManualFileName(new HySString(".\\")+ m_csManualFileName);
            }
            //csModelInfo.SetPropertyInfo(m_csMdlProperty);
            //csModelInfo.SetInitialInfo(m_csMdlInitial);
            return csModelInfo;
        }


        /// <summary>XMLラベル:ルート</summary>
        static string xml_FortranMdl = "FortranModel";
        /// <summary>XMLラベル:モデル名</summary>
        static string xml_MdlName = "ModelName";
        /// <summary>XMLラベル:DLL名</summary>
        static string xml_DLLName = "FortranDLLName";
        /// <summary>XMLラベル:分類名</summary>
        static string xml_MDLCategory = "Category";
        /// <summary>XMLラベル:分類名</summary>
        static string xml_Val = "Val";

        /// <summary>XMLラベル:XMLファイル名</summary>
        static string xml_MdlInfXmlFile = "MdlXmlFile";
        /// <summary>XMLラベル:マニュアル</summary>
        static string xml_MdlManualFile = "ManualFileName";
        /// <summary>XMLラベル:アイコン名</summary>
        static string xml_MdlIconName = "IconName";
        /// <summary>XMLラベル:</summary>
        static string xml_MdlVer = "Version";
        /// <summary>XMLラベル:</summary>
        static string xml_MdlSummary = "Summary";
        /// <summary>XMLラベル:</summary>
        static string xml_MdlCreatorInf = "CreatorInf";

        /// <summary>XMLラベル:</summary>
        static string xml_MdlInputPtn = "ReceivePtn";
        /// <summary>XMLラベル:</summary>
        static string xml_MdlOutputPtn = "SendPtn";

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            // ﾒﾝﾊﾞｰ：McPropertyInfo内のシリアライズ対象外のインスタンスを設定する


            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();//復元後の整合性確保処理
        }  
    }
}
