﻿using System;
using System.Collections.Generic;
using System.Text;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreOptionl.HymcoModelDLLWrapper;

namespace CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp
{
    /// <summary><para>class outline:</para>
    /// <para>Fortran要素ﾓﾃﾞﾙWrapper関連定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2011/04/01][新規作成]</para>
    /// </remarks>
    public class Mc32BitFortranWrapperDef
    {
        /// <summary>フォートランモデル情報格納ディレクトリ取得用変数 </summary>
        public const string FORTRAN_MODEL_INF_FOLDER = "FORTRAN_MODEL_INF_FOLDER";

        /// <summary> ＤＬＬモデルパラメーター受信エリアの最大配列数を取得する</summary>
        public const string GET_MAX_PARADT_AREA = "FGetMaxParaDim";
        /// <summary> ＤＬＬモデルへ設定するデータのエリアの最大配列数を取得する</summary>
        public const string GET_MAX_RCVDT_AREA = "FGetMaxReceiveDataDim";
        /// <summary> ＤＬＬモデルから取得するデータのエリアの最大配列数を取得する</summary>
        public const string GET_MAX_SNDDT_AREA = "FGetMaxSendDataDim";

        /// <summary>δＴの設定</summary>
        public const string SET_DELTA_TIME = "FSetDeltaTime";
        /// <summary>プロパティ情報設定</summary>
        public const string PROPERTY_SET = "FSetProperty";

        /// <summary> 初期化</summary>
        public const string INITIALIZE = "FInitialize";
        /// <summary> 収束判定</summary>
        public const string ISCONVERGEDE = "FIsConverged";
        /// <summary> ＤＬＬモデルが欲しいデータの時刻を取得する</summary>
        public const string WANTTIME = "FWantTime";
        /// <summary> ＤＬＬモデルへのデータを設定取得</summary>
        public const string INPUTDATA = "FGetRcvData";
        /// <summary> 計算</summary>
        public const string CALCULATE = "FCalculate";
        /// <summary> ＤＬＬモデルから計算結果取得</summary>
        public const string DATAFUSION = "FSetSndData";
        /// <summary> 計算時刻を進める</summary>
        public const string GAIN_SIMULATION_TIME = "FGainSimuTime";
        /// <summary> 目標時刻の設定</summary>
        public const string SET_TARGET_TIME = "FSetTargetTime";

        /// <summary> 計算開始</summary>
        public const string READY_CALUCLATION = "FReadyCalculation";
        /// <summary> 計算終了</summary>
        public const string COMPLETE_CALCULATION = "FCompleteCalculation";
        /// <summary> 計算一時中断</summary>
        public const string SUSPEND_CALCULATION = "FSuspendCalculation";


        /// <summary>モデルファクトリ</summary>
        public static readonly HySID FORTRAN_WRAPPER_MODEL_LIB = new HySID("CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp.Fctry");
    }
}
