﻿// <summary>ソースコード：サンプルプロパティ詳細設定画面クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp;

namespace CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp.DetailForm
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>フォートランプロパティ詳細設定画面</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/06/22][新規作成]</para>
    /// </remarks>
    public partial class McDotNetFortranWrapperPrptyForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        /// <summary> モデルのプロパティ情報 </summary>
        protected Mc32BitFortranModelPropertyInfo m_csMdlProperty = null;
        /// <summary> モデルのプロパティ情報(編集時一時保存) </summary>
        protected Mc32BitFortranModelPropertyInfo m_csEditMdlProperty = null;

        /// <summary> モデルの初期化情報 </summary>
        protected Mc32BitFortranModelInitialData m_csMdlInitial = null;
        /// <summary> モデルの初期化情報(編集時一時保存) </summary>
        protected Mc32BitFortranModelInitialData m_csEditMdlInitial = null;

        bool bInitFlg = true;

        /// <summary>
        /// コンストラクター
        /// </summary>
        public McDotNetFortranWrapperPrptyForm()
        {
            bInitFlg = true;
            InitializeComponent();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void EditParameter()
        {
            bInitFlg = true;

            m_csEditMdlProperty = this.m_csPropertyInfo as Mc32BitFortranModelPropertyInfo;
            m_csMdlProperty = this.m_csOriginalPropertyInfo as Mc32BitFortranModelPropertyInfo;
            m_csEditMdlInitial = this.m_csInitialInfo as Mc32BitFortranModelInitialData;
            m_csMdlInitial = this.m_csOriginalInitialInfo as Mc32BitFortranModelInitialData;

            // 画面表示情報編集
            double dltT = m_csEditMdlProperty.GetStepTime();
            TimeStep_textBox.Text = dltT.ToString();

            bool bType=true;
            m_csEditMdlProperty.GetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, ref bType);
            // 未来予測型:True／現在状態計算型:False
            if (bType == true)
            {
                ModelType_comboBox.SelectedItem = "未来予測型";
            }
            else
            {
                ModelType_comboBox.SelectedItem = "現在状態計算型";
            }
            int iDispCnt=0;
            long lCount = m_csEditMdlProperty.GetLongParaNum();
            long lPara=0;
            double dPara=0.0;
            string sLbl = "";
            for(long lLp=0;lLp<lCount;lLp++)
            {
                ModelPropertyDataGridView.Rows.Add();
                m_csEditMdlProperty.GetLongPara(lLp, ref lPara, ref sLbl);
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[1].Value = "L"+lLp.ToString();
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[2].Value = sLbl;
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[3].Value = lPara.ToString();
                iDispCnt+=1;
            }
            lCount = m_csEditMdlProperty.GetDoubleParaNum();         
            for(long lLp=0;lLp<lCount;lLp++)
            {
                ModelPropertyDataGridView.Rows.Add();
                m_csEditMdlProperty.GetDoublePara(lLp, ref dPara, ref sLbl);
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[0].Value = "Real(8)";
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[1].Value = "D"+lLp.ToString();
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[2].Value = sLbl;
                ModelPropertyDataGridView.Rows[iDispCnt].Cells[3].Value = dPara.ToString();
                iDispCnt+=1;
            }


            iDispCnt = 0;
            lCount = m_csEditMdlInitial.GetLongParaNum();
            for(long lLp=0;lLp<lCount;lLp++)
            {
                ModelInitialDataGridView.Rows.Add();
                m_csEditMdlInitial.GetLongPara(lLp, ref lPara, ref sLbl);
                ModelInitialDataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                ModelInitialDataGridView.Rows[iDispCnt].Cells[1].Value = "L"+lLp.ToString();
                ModelInitialDataGridView.Rows[iDispCnt].Cells[2].Value = sLbl;
                ModelInitialDataGridView.Rows[iDispCnt].Cells[3].Value = lPara.ToString();
                iDispCnt+=1;
            }
            lCount = m_csEditMdlInitial.GetDoubleParaNum();         
            for(long lLp=0;lLp<lCount;lLp++)
            {
                ModelInitialDataGridView.Rows.Add();
                m_csEditMdlInitial.GetDoublePara(lLp, ref dPara, ref sLbl);
                ModelInitialDataGridView.Rows[iDispCnt].Cells[0].Value = "Real(8)";
                ModelInitialDataGridView.Rows[iDispCnt].Cells[1].Value = "D"+lLp.ToString();
                ModelInitialDataGridView.Rows[iDispCnt].Cells[2].Value = sLbl;
                ModelInitialDataGridView.Rows[iDispCnt].Cells[3].Value = dPara.ToString();
                iDispCnt+=1;
            }


            bInitFlg = false;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>TabControl背景色設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>TabControl_DrawItem(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void TabControl1_DrawItem(object sender, DrawItemEventArgs e)
        {
            //対象のTabControlを取得 
            TabControl csTab = (TabControl)sender;

            //タブページのテキストを取得 
            string csTxt = csTab.TabPages[e.Index].Text;

            //タブのテキストは黒色とする 
            Brush csForeBrush = new SolidBrush(Color.Black);

            Font csTxtFont;        //タブのテキストのFont
            Brush csBackBrush;     //タブのテキストと背景を描画するためのブラシ 

            //選択タブ判定 
            if (e.State == DrawItemState.Selected)
            {// タブが選択されている場合
                //選択されているタブの背景を白色とする 
                csBackBrush = new SolidBrush(Color.White);

                //タブのテキストのFontを太字にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Bold);
            }
            else
            {// タブが選択されていない場合
                //選択されていないタブの背景を背景標準色とする 
                csBackBrush = new SolidBrush(csTab.TabPages[e.Index].BackColor);

                //タブのテキストのFontを標準にする
                csTxtFont = new Font(csTab.TabPages[e.Index].Font, FontStyle.Regular);
            }

            //描画座標・サイズ取得
            Rectangle csRect = e.Bounds;
            csRect.Y = csRect.Y + 1;

            //StringFormatを作成 
            StringFormat csfForm = new StringFormat();

            //中央に表示する 
            csfForm.Alignment = StringAlignment.Center;
            csfForm.LineAlignment = StringAlignment.Center;

            //背景の描画 
            e.Graphics.FillRectangle(csBackBrush, e.Bounds);

            //Textの描画 
            e.Graphics.DrawString(csTxt, csTxtFont, csForeBrush, csRect, csfForm);

            //後処理
            csfForm.Dispose();      //StringFormat
            csTxtFont.Dispose();    //タブのテキストのFont
            csBackBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csForeBrush.Dispose();  //タブのテキストと背景を描画するためのブラシ 
            csTxt = null;           //タブページのテキスト
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void PraSet_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            
            string sVal = TimeStep_textBox.Text;
            m_csEditMdlProperty.SetStepTime(Double.Parse(sVal));

            Close();
        }

        private void ModelInitialDataGridView_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            if (bInitFlg == false)
            {
                string RefL="L";
                string RefD="D";
                int iClmIdx = e.ColumnIndex;
                int iRowIdx = e.RowIndex;
                string sKey = ModelInitialDataGridView.Rows[iRowIdx].Cells[1].Value as string;
                string sVal= ModelInitialDataGridView.Rows[iRowIdx].Cells[3].Value as string;
                if (sKey[0] == RefL[0])
                {
                    long lVal = Int32.Parse(sVal);
                    m_csEditMdlInitial.SetInfo(sKey, lVal);
                }
                if (sKey[0] == RefD[0])
                {
                    double dVal = Double.Parse(sVal);
                    m_csEditMdlInitial.SetInfo(sKey, dVal);
                }
            }
        }

        private void ModelPropertyDataGridView_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            if (bInitFlg == false)
            {
                string RefL = "L";
                string RefD = "D";
                int iClmIdx = e.ColumnIndex;
                int iRowIdx = e.RowIndex;
                string sKey = ModelPropertyDataGridView.Rows[iRowIdx].Cells[1].Value as string;
                string sVal = ModelPropertyDataGridView.Rows[iRowIdx].Cells[3].Value as string;
                if (sKey[0] == RefL[0])
                {
                    long lVal = Int32.Parse(sVal);
                    m_csEditMdlProperty.SetInfo(sKey, lVal);
                }
                if (sKey[0] == RefD[0])
                {
                    double dVal = Double.Parse(sVal);
                    m_csEditMdlProperty.SetInfo(sKey, dVal);
                }
            }

        }

        private void ModelType_comboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (bInitFlg == false)
            {
                if ((string)(ModelType_comboBox.SelectedItem) == "未来予測型")
                {
                    m_csEditMdlProperty.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, true);
                }
                else
                {
                    m_csEditMdlProperty.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, false);
                }
            }
        }

        private void TimeStep_textBox_TextChanged(object sender, EventArgs e)
        {
            if (bInitFlg == false)
            {
                //string sVal = TimeStep_textBox.Text;
                //m_csEditMdlProperty.SetStepTime(Double.Parse(sVal));
            }
        }
    }
}
