﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptionl.HymcoModelDLLWrapper;


namespace CommonMP.HYMCO.OptionImpl.Hymco64FortranWrapp
{
    /// <summary><para>class outline:</para>
    /// <para>モデルのプロパティ情報格納クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2011/04/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>プロパティ情報を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class Mc64BitFortranModelPropertyInfo : McCellModelPropertyInfo
    {
        /// <summary>未来予測／現状計算型区分用ラベル名称</summary>
        static public string KEY_FORECAST_FLG = "ForecastFlg"; 

        // start of XML化対象外
        /// <summary>Long型パラメーターの数 </summary>
        protected long m_lLongParaNum = 0;
        /// <summary>Double型パラメーターの数 </summary>
        protected long m_lDoubleParaNum = 0;
        // end of XML化対象外


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new Mc32BitFortranModelPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子=DLL名とする</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Mc64BitFortranModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// DLL名取得
        /// </summary>
        /// <returns></returns>
        public string GetDLLName()
        {
            HySString csDLLFileName = this.GetModelKind().GetString() as HySString;
            return csDLLFileName.ToString();
        }

        /// <summary>
        /// 未来予測型／現在状態計算型の設定
        /// </summary>
        /// <param name="bFlg"></param>
        public void SetForecastFlg(bool bFlg)
        {
            this.AddInfoType(Mc64BitFortranModelPropertyInfo.KEY_FORECAST_FLG, "未来予測型:True／現在状態計算型:False", McDefine.ValKind.BOOL);
            //this.SetInfo(Mc64BitFortranModelPropertyInfo);
        }
        /// <summary>
        /// 未来予測型／現在状態計算型の取得
        /// </summary>
        /// <returns></returns>
        public bool GetForecastFlg()
        {
            bool bForecastFlg = false;
            this.GetInfo(Mc64BitFortranModelPropertyInfo.KEY_FORECAST_FLG, ref bForecastFlg);
            return bForecastFlg;
        }

        /// <summary>
        /// Integer型変数の数を設定
        /// </summary>
        /// <param name="lNum"></param>
        public void SetLongParaNum(long lNum)
        {
            m_lLongParaNum = lNum;
            this.AddInfoType("LongParaNum", "Integr型ﾊﾟﾗﾒｰﾀｰ数", McDefine.ValKind.LONG);
            this.SetInfo("LongParaNum", lNum);
        }
        /// <summary>
        /// Integer型変数の数を取得
        /// </summary>
        /// <returns></returns>
        public long GetLongParaNum()
        {
            m_lLongParaNum = 0;
            HySString csKey = new HySString("LongParaNum");
            this.GetInfo(csKey, ref m_lLongParaNum);
            return m_lLongParaNum;
        }

        /// <summary>
        /// Integer型変数値を設定
        /// </summary>
        /// <param name="lItemNo0"></param>
        /// <param name="lPara"></param>
        /// <param name="sLabel"></param>
        public void SetLongPara(long lItemNo0, long lPara, string sLabel)
        {
            if (lItemNo0 < m_lLongParaNum)
            {
                this.AddInfoType("L"+lItemNo0.ToString(), sLabel, McDefine.ValKind.LONG);
                this.SetInfo("L"+lItemNo0.ToString(), lPara);
            }
        }
        /// <summary>
        /// Integer型変数値を取得
        /// </summary>
        /// <param name="lItemNo0"></param>
        /// <param name="lPara"></param>
        /// <param name="sLabel"></param>
        /// <returns></returns>
        public bool GetLongPara(long lItemNo0, ref long lPara, ref string sLabel)
        {
            bool bRtn = false;
            if (lItemNo0 < m_lLongParaNum)
            {
                HySString csKey = new HySString("L" + lItemNo0.ToString());
                HySString csLabel = new HySString("");
                McDefine.ValKind lObjKind=McDefine.ValKind.BOOL;
                bRtn = GetInfoType(csKey, ref csLabel, ref lObjKind);
                if (bRtn == true)
                {
                    sLabel = csLabel.ToString();
                    bRtn = this.GetInfo(csKey, ref lPara);
                }
            }
            return bRtn;
        }

        /// <summary>
        /// Real(8)型変数の数を設定
        /// </summary>
        /// <param name="lNum"></param>
        public void SetDoubleParaNum(long lNum)
        {
            m_lDoubleParaNum = lNum;
            this.AddInfoType("DoubleParaNum", "Real(8)型ﾊﾟﾗﾒｰﾀｰ数", McDefine.ValKind.LONG);
            this.SetInfo("DoubleParaNum", lNum);

        }
        /// <summary>
        /// Real(8)型変数の数を取得
        /// </summary>
        /// <returns></returns>
        public long GetDoubleParaNum()
        {
            m_lDoubleParaNum = 0;
            HySString csKey = new HySString("DoubleParaNum");
            this.GetInfo(csKey, ref m_lDoubleParaNum);
            return m_lDoubleParaNum;
        }

        /// <summary>
        /// Real(8)型変数値を設定
        /// </summary>
        /// <param name="lItemNo0"></param>
        /// <param name="dPara"></param>
        /// <param name="sLabel"></param>
        public void SetDoublePara(long lItemNo0, double dPara, string sLabel)
        {
            if (lItemNo0 < m_lDoubleParaNum)
            {
                this.AddInfoType("D" + lItemNo0.ToString(), sLabel, McDefine.ValKind.DOUBLE);
                this.SetInfo("D" + lItemNo0.ToString(), dPara);
            }
        }
        /// <summary>
        /// Real(8)型変数値を取得
        /// </summary>
        /// <param name="lItemNo0"></param>
        /// <param name="dPara"></param>
        /// <param name="sLabel"></param>
        /// <returns></returns>
        public bool GetDoublePara(long lItemNo0, ref double dPara, ref string sLabel)
        {
            bool bRtn = false;
            if (lItemNo0 < m_lDoubleParaNum)
            {
                HySString csKey = new HySString("D" + lItemNo0.ToString());
                HySString csLabel = new HySString("");
                McDefine.ValKind lObjKind = McDefine.ValKind.BOOL;
                bRtn = GetInfoType(csKey, ref csLabel, ref lObjKind);
                if (bRtn == true)
                {
                    sLabel = csLabel.ToString();
                    bRtn = this.GetInfo(csKey, ref dPara);
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            Mc64BitFortranModelPropertyInfo csRtn = new Mc64BitFortranModelPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            Mc64BitFortranModelPropertyInfo csPrpOrgObj = csOrgObj as Mc64BitFortranModelPropertyInfo;
            if (csPrpOrgObj != null)
            {
                //this.m_csMdlInfoXMLFileName = csPrpOrgObj.m_csMdlInfoXMLFileName.Clone();
                //this.m_csDLLFileName = csPrpOrgObj.m_csDLLFileName.Clone();
                this.m_lLongParaNum = csPrpOrgObj.m_lLongParaNum;
                this.m_lDoubleParaNum = csPrpOrgObj.m_lDoubleParaNum;
                //this.m_bForecastFlg = csPrpOrgObj.m_bForecastFlg;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CopyData(Mc64BitFortranModelPropertyInfo csOrgObj)
        {
            this.CopyInf(csOrgObj);
        }

        // =============================================
        // === バージョンアップ時の互換性を保つ為の処理 ===
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
