﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptionl.HymcoModelDLLWrapper;


using CommonMP.HYMCO.OptionImpl.Hymco32FortranWrapp;

namespace FortranInfoEditor
{
    public partial class FortranInfoEditForm : Form
    {
        /// <summary> Fortranモデル情報 </summary>
        protected Mc32BitFortranModelInfo m_csFortranModelInfo = null; //new Mc32BitFortranModelInfo();
        /// <summary> モデルのプロパティ情報 </summary>
        protected Mc32BitFortranModelPropertyInfo m_csMdlProperty = null; //new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("") );
        /// <summary> モデルの初期化情報 </summary>
        protected Mc32BitFortranModelInitialData m_csMdlInitial = null; //new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind(""));

        /// <summary>受信パターンリスト</summary>
        protected List<PtnData>    m_RcvPtnList = new List<PtnData>();
        /// <summary>送信パターンリスト</summary>
        protected List<PtnData> m_SndPtnList = new List<PtnData>(); 
        //protected HySDataLinkedList m_csSndPtnList = new HySDataLinkedList();


        protected string m_sXmlFileName = "dmy.xml";
        protected string m_sXmlFileDir = @"C:\";

        public FortranInfoEditForm()
        {
            InitializeComponent();
            EditPara();
        }

        private void FileOpen_Click(object sender, EventArgs e)
        {   
            // ファイル名を選択するダイアローグを開く
            //OpenFileDialogクラスのインスタンスを作成
            OpenFileDialog ofd = new OpenFileDialog();

            //はじめのファイル名を指定する
            //はじめに「ファイル名」で表示される文字列を指定する
            ofd.FileName = "default.xml";
            //はじめに表示されるフォルダを指定する
            //指定しない（空の文字列）の時は、現在のディレクトリが表示される
            ofd.InitialDirectory = m_sXmlFileDir;
            //[ファイルの種類]に表示される選択肢を指定する
            //指定しないとすべてのファイルが表示される
            ofd.Filter =
                "XMLファイル(*.xml)|*.xml;|すべてのファイル(*.*)|*.*";
            //[ファイルの種類]ではじめに
            //「XMLファイル(*.xml)」が選択されているようにする
            ofd.FilterIndex = 1;
            //タイトルを設定する
            ofd.Title = "開くファイルを選択してください";
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            ofd.RestoreDirectory = true;
            //存在しないファイルの名前が指定されたとき警告を表示する
            //デフォルトでTrueなので指定する必要はない
            ofd.CheckFileExists = false;
            //存在しないパスが指定されたとき警告を表示する
            //デフォルトでTrueなので指定する必要はない
            //ofd.CheckPathExists = true;

            //ダイアログを表示する
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                FileName.Text = ofd.FileName;
                m_sXmlFileName = ofd.SafeFileName;
                string sDirFileDir =  ofd.FileName;
                m_sXmlFileDir = sDirFileDir.Substring(0, (sDirFileDir.Length - m_sXmlFileName.Length));
                //if (m_csFortranModelInfo == null)
                {
                    m_csFortranModelInfo = new Mc32BitFortranModelInfo(); 
                }
                //OKボタンがクリックされたとき
                // ファイル名設定の後、XMLファイルを作成
                m_csFortranModelInfo.XmlIN(ofd.FileName);

                m_csMdlProperty = m_csFortranModelInfo.GetModelProperty();
                if (m_csMdlProperty == null)
                {
                    m_csMdlProperty = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("Dmy"));
                }
                m_csMdlInitial = m_csFortranModelInfo.GetModelInitialInfo();
                if (m_csMdlInitial == null)
                {
                    m_csMdlInitial = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("Dmy"));
                }

                EditPara();
            }

        }

        private void FileSave_Click(object sender, EventArgs e)
        {
            // ファイル名を選択するダイアローグを開く
            //OpenFileDialogクラスのインスタンスを作成
            OpenFileDialog ofd = new OpenFileDialog();

            //はじめのファイル名を指定する
            //はじめに「ファイル名」で表示される文字列を指定する
            ofd.FileName = "m_sXmlFileName";
            //はじめに表示されるフォルダを指定する
            //指定しない（空の文字列）の時は、現在のディレクトリが表示される
            ofd.InitialDirectory = m_sXmlFileDir;
            //[ファイルの種類]に表示される選択肢を指定する
            //指定しないとすべてのファイルが表示される
            ofd.Filter =
                "XMLファイル(*.xml)|*.xml;|すべてのファイル(*.*)|*.*";
            //[ファイルの種類]ではじめに
            //「XMLファイル(*.xml)」が選択されているようにする
            ofd.FilterIndex = 1;
            //タイトルを設定する
            ofd.Title = "開くファイルを選択してください";
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            ofd.RestoreDirectory = true;
            //存在しないファイルの名前が指定されたとき警告を表示する
            //デフォルトでTrueなので指定する必要はない
            ofd.CheckFileExists = false;
            //存在しないパスが指定されたとき警告を表示する
            //デフォルトでTrueなので指定する必要はない
            //ofd.CheckPathExists = true;

            //ダイアログを表示する
            if (ofd.ShowDialog() == DialogResult.OK)
            {

                // 画面の設定情報を入れる
                GetPara();


                m_csFortranModelInfo.SetModelProperty(m_csMdlProperty);
                m_csFortranModelInfo.SetModelInitialInfo(m_csMdlInitial);

//kinematicSet1();
//dmnamicSet1();
                m_csMdlProperty.SetModelKind(m_csFortranModelInfo.GetModelKind());
                m_csFortranModelInfo.SetModelProperty(m_csMdlProperty);
                m_csMdlInitial.SetModelKind(m_csFortranModelInfo.GetModelKind());
                m_csFortranModelInfo.SetModelInitialInfo(m_csMdlInitial);

                FileName.Text = ofd.FileName;
                m_sXmlFileName = ofd.FileName;
                m_csFortranModelInfo.SetMdlInfoXMLFileName(new HySString(ofd.SafeFileName));
                // ファイル名設定の後、XMLファイルを作成
                m_csFortranModelInfo.XmlOUT(m_sXmlFileName);
            }


        }

        private void DLLNameTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csFortranModelInfo.SetDLLName(new HySString(DLLNameTextBox.Text));
        }

        private void EditPara()
        {

            if (m_csFortranModelInfo != null)
            {
                // --------------------------- 一般情報
                ModelNameTextBox.Text = m_csFortranModelInfo.GetModelName().ToString();
                DLLNameTextBox.Text = m_csFortranModelInfo.GetDLLName().ToString();
                IconTextBox.Text = m_csFortranModelInfo.GetIconName().ToString();
                if ((object)m_csFortranModelInfo.GetManualFileName() != null)
                {
                    MnltTxtBox.Text = m_csFortranModelInfo.GetManualFileName().ToString();
                }
                CreatorTextBox.Text = m_csFortranModelInfo.GetCreatorInf().ToString();
                VertionTextBox.Text = m_csFortranModelInfo.GetModelVer().ToString();
                MdlAbstructTextBox.Text = m_csFortranModelInfo.GetModelSummary().ToString();
                CategoryTextBox.Text = m_csFortranModelInfo.GetCategory().ToString();

                // -----------------------------　接続情報
                HySDataLinkedList csPtnList = m_csMdlProperty.GetReceivePatternList();
                long iPtnNum = csPtnList.GetCount();
                McTranInfoPattern csPtn = null;
                csPtnList.SetCursorFirst();
                for (int lLp = 0; lLp < iPtnNum; lLp++)
                {
                    csPtn = csPtnList.GetCursorData() as McTranInfoPattern;
                    this.AddSndRcvPtn(true, false, csPtn); // 受信側
                    csPtnList.MoveCursorNext();
                }
                csPtnList = m_csMdlProperty.GetSendPatternList();
                iPtnNum = csPtnList.GetCount();
                csPtn = null;
                csPtnList.SetCursorFirst();
                for (int lLp = 0; lLp < iPtnNum; lLp++)
                {
                    csPtn = csPtnList.GetCursorData() as McTranInfoPattern;
                    this.AddSndRcvPtn(true, true, csPtn); // 送信側
                    csPtnList.MoveCursorNext();
                }
                // -----------------------------　ﾌﾟﾛﾊﾟﾃｨ情報
                TimeStep_textBox.Text = m_csMdlProperty.GetStepTime().ToString();
                bool bFlg = true;
                m_csMdlProperty.GetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, ref bFlg);
                if (bFlg == true)
                {
                    ModelType_comboBox.SelectedIndex = 0;
                }
                else
                {
                    ModelType_comboBox.SelectedIndex = 1;
                }

                PrptyIntNumTextBox.Text = "0";
                PrptyDblNumTextBox.Text = "0";
                InitIntNumTextBox.Text = "0";
                InitDblNumTextBox.Text = "0";

                long lCnt = m_csMdlProperty.GetLongParaNum();
                long lVal = 0;
                double dVal = 0.0;
                string sLvl = "";
                for (long lLp = 0; lLp < lCnt; lLp++)
                {
                    m_csMdlProperty.GetLongPara(lLp, ref lVal, ref sLvl);
                    RcdVal csRcdval = new RcdVal();
                    csRcdval.m_lItemNo = lLp;
                    csRcdval.m_sDfltVal = lVal.ToString();
                    csRcdval.m_sName = sLvl;
                    csRcdval.m_lEditType = 1;  // 0:初期情報、 1:ﾌﾟﾛﾊﾟﾃｨ情報
                    csRcdval.m_lDataType = 1;  // 1:LONG型情報、2:Double型情報
                    this.AddRecord(csRcdval);
                }
                lCnt = m_csMdlProperty.GetDoubleParaNum();
                for (long lLp = 0; lLp < lCnt; lLp++)
                {
                    m_csMdlProperty.GetDoublePara(lLp, ref dVal, ref sLvl);
                    RcdVal csRcdval = new RcdVal();
                    csRcdval.m_lItemNo = lLp;
                    csRcdval.m_sDfltVal = dVal.ToString();
                    csRcdval.m_sName = sLvl;
                    csRcdval.m_lEditType = 1;  // 0:初期情報、 1:ﾌﾟﾛﾊﾟﾃｨ情報
                    csRcdval.m_lDataType = 2;  // 1:LONG型情報、2:Double型情報
                    this.AddRecord(csRcdval);
                }
                // -----------------------------　初期化情報
                lCnt = m_csMdlInitial.GetLongParaNum();
                for (long lLp = 0; lLp < lCnt; lLp++)
                {
                    m_csMdlInitial.GetLongPara(lLp, ref lVal, ref sLvl);
                    RcdVal csRcdval = new RcdVal();
                    csRcdval.m_lItemNo = lLp;
                    csRcdval.m_sDfltVal = lVal.ToString();
                    csRcdval.m_sName = sLvl;
                    csRcdval.m_lEditType = 0;  // 0:初期情報、 1:ﾌﾟﾛﾊﾟﾃｨ情報
                    csRcdval.m_lDataType = 1;  // 1:LONG型情報、2:Double型情報
                    this.AddRecord(csRcdval);
                }
                lCnt = m_csMdlInitial.GetDoubleParaNum();
                for (long lLp = 0; lLp < lCnt; lLp++)
                {
                    m_csMdlInitial.GetDoublePara(lLp, ref dVal, ref sLvl);
                    RcdVal csRcdval = new RcdVal();
                    csRcdval.m_lItemNo = lLp;
                    csRcdval.m_sDfltVal = dVal.ToString();
                    csRcdval.m_sName = sLvl;
                    csRcdval.m_lEditType = 0;  // 0:初期情報、 1:ﾌﾟﾛﾊﾟﾃｨ情報
                    csRcdval.m_lDataType = 2;  // 1:LONG型情報、2:Double型情報
                    this.AddRecord(csRcdval);
                }
            }
            else
            {
                PrptyIntNumTextBox.Text = "0";
                PrptyDblNumTextBox.Text = "0";
                InitIntNumTextBox.Text = "0";
                InitDblNumTextBox.Text = "0";
                ModelType_comboBox.SelectedIndex = 0;
                TimeStep_textBox.Text = "60";
                CategoryTextBox.Text = "CAL_HYDROLOGICAL_MODELS";
            }
        }

        private void GetPara()
        {
            m_csFortranModelInfo = new Mc32BitFortranModelInfo();
            m_csMdlProperty = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("") );
            m_csMdlInitial = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind(""));

            // --------------------------- 一般情報
            m_csFortranModelInfo.SetModelName(new HySString((string)ModelNameTextBox.Text));
            m_csFortranModelInfo.SetDLLName(new HySString((string)DLLNameTextBox.Text));
            m_csFortranModelInfo.SetIconName(new HySString((string)IconTextBox.Text));
            if ((string)MnltTxtBox.Text != "")
            {
                m_csFortranModelInfo.SetManualFileName(new HySString((string)MnltTxtBox.Text));
            }
            m_csFortranModelInfo.SetCreatorInf(new HySString((string)CreatorTextBox.Text));
            m_csFortranModelInfo.SetModelVer(new HySString((string)VertionTextBox.Text));
            m_csFortranModelInfo.SetModelSummary(new HySString((string)MdlAbstructTextBox.Text));

            m_csFortranModelInfo.SetCategory(new HySObjectKind((string)CategoryTextBox.Text));
            
            // -----------------------------　接続情報
            long lPtnNum = m_RcvPtnList.Count;
            for (int lLp = 0; lLp < lPtnNum; lLp++)
            {
                PtnData csData = m_RcvPtnList[lLp];
                csData.m_csTrnInfPtn.SetPatternID( new HySID(lLp.ToString()));
                m_csMdlProperty.AddReceivePattern(csData.m_csTrnInfPtn);
            }

            lPtnNum = m_SndPtnList.Count;
            for (int lLp = 0; lLp < lPtnNum; lLp++)
            {
                PtnData csData = m_SndPtnList[lLp];
                csData.m_csTrnInfPtn.SetPatternID(new HySID(lLp.ToString()));
                m_csMdlProperty.AddSendPattern(csData.m_csTrnInfPtn);
            }

            // -----------------------------　ﾌﾟﾛﾊﾟﾃｨ情報
            m_csMdlProperty.SetStepTime(Double.Parse((string)TimeStep_textBox.Text));
            m_csMdlProperty.AddInfoType(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, "未来予測型:True／現在状態計算型:False", McDefine.ValKind.BOOL);
            if ((string)(ModelType_comboBox.SelectedItem) == "未来予測型")
            {
                m_csMdlProperty.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, true);
            }
            else
            {
                m_csMdlProperty.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, false);
            }

            long lVal = 0;
            double dVal = 0.0;
            string sName = "";
            int iNum = PrptyIntdataGridView.RowCount;

            m_csMdlProperty.SetLongParaNum(iNum);
            for (int i = 0; i < iNum; i++)
            {
                sName = (string)PrptyIntdataGridView.Rows[i].Cells[2].Value;
                lVal = Int32.Parse( (string)PrptyIntdataGridView.Rows[i].Cells[3].Value);
                m_csMdlProperty.SetLongPara((long)i, lVal, sName);
            }

            iNum = PrptyDbldataGridView.RowCount;
            m_csMdlProperty.SetDoubleParaNum(iNum);
            for (int i = 0; i < iNum; i++)
            {
                sName = (string)PrptyDbldataGridView.Rows[i].Cells[2].Value;
                dVal = Double.Parse((string)PrptyDbldataGridView.Rows[i].Cells[3].Value);
                m_csMdlProperty.SetDoublePara((long)i, dVal, sName);
            }

            // -----------------------------　初期化情報
            iNum = InitIntdataGridView.RowCount;
            m_csMdlInitial.SetLongParaNum(iNum);
            for (int i = 0; i < iNum; i++)
            {
                sName = (string)InitIntdataGridView.Rows[i].Cells[2].Value;
                lVal = Int32.Parse((string)InitIntdataGridView.Rows[i].Cells[3].Value);
                m_csMdlInitial.SetLongPara((long)i, lVal, sName);
            }

            iNum = InitDbldataGridView.RowCount;
            m_csMdlInitial.SetDoubleParaNum(iNum);
            for (int i = 0; i < iNum; i++)
            {
                sName = (string)InitDbldataGridView.Rows[i].Cells[2].Value;
                dVal = Double.Parse((string)InitDbldataGridView.Rows[i].Cells[3].Value);
                m_csMdlInitial.SetDoublePara((long)i, dVal, sName);
            }

            // ---------------------------------
            m_csFortranModelInfo.SetModelProperty(m_csMdlProperty);
            m_csFortranModelInfo.SetModelInitialInfo(m_csMdlInitial);
        }


        private void PrptyIntAddButton_Click(object sender, EventArgs e)
        {
            RcdVal csRcdVal = new RcdVal();
            csRcdVal.m_lEditType = 1;
            csRcdVal.m_lDataType = 1;
            csRcdVal.m_lItemNo = PrptyIntdataGridView.RowCount;
            PrpIntRecodeForm csRcdInFrm = new PrpIntRecodeForm(csRcdVal, this);
            csRcdInFrm.ShowDialog();
        }

        private void PrptyIntDelButton_Click(object sender, EventArgs e)
        {
            int iClm = PrptyIntdataGridView.CurrentCell.RowIndex;
            PrptyIntdataGridView.Rows.RemoveAt(iClm);
            int iClmNum = PrptyIntdataGridView.RowCount;
            for (int iL = 0; iL < iClmNum; iL++)
            {
                PrptyIntdataGridView.Rows[iL].Cells[1].Value = "L" + iL.ToString();
            }
            PrptyIntNumTextBox.Text = iClmNum.ToString();
        }

        private void PrptyDblAddButton_Click(object sender, EventArgs e)
        {
            RcdVal csRcdVal = new RcdVal();
            csRcdVal.m_lEditType = 1;
            csRcdVal.m_lDataType = 2;
            csRcdVal.m_lItemNo = PrptyDbldataGridView.RowCount;
            PrpIntRecodeForm csRcdInFrm = new PrpIntRecodeForm(csRcdVal, this);
            csRcdInFrm.ShowDialog();
        }

        private void PrptyDblDelButton_Click(object sender, EventArgs e)
        {
            int iClm = PrptyDbldataGridView.CurrentCell.RowIndex;
            PrptyDbldataGridView.Rows.RemoveAt(iClm);
            int iClmNum = PrptyDbldataGridView.RowCount;
            for (int iL = 0; iL < iClmNum; iL++)
            {
                PrptyDbldataGridView.Rows[iL].Cells[1].Value = "D" + iL.ToString();
            }
            PrptyDblNumTextBox.Text = iClmNum.ToString();
        }

        private void InitIntAddButton_Click(object sender, EventArgs e)
        {
            RcdVal csRcdVal = new RcdVal();
            csRcdVal.m_lEditType = 0;
            csRcdVal.m_lDataType = 1;
            csRcdVal.m_lItemNo = InitIntdataGridView.RowCount;
            PrpIntRecodeForm csRcdInFrm = new PrpIntRecodeForm(csRcdVal, this);
            csRcdInFrm.ShowDialog();
        }

        private void InitIntDelButton_Click(object sender, EventArgs e)
        {
            int iClm = InitIntdataGridView.CurrentCell.RowIndex;
            InitIntdataGridView.Rows.RemoveAt(iClm);
            int iClmNum = PrptyIntdataGridView.RowCount;
            for (int iL = 0; iL < iClmNum; iL++)
            {
                InitIntdataGridView.Rows[iL].Cells[1].Value = "L" + iL.ToString();
            }
            InitIntNumTextBox.Text = iClmNum.ToString();
        }

        private void InitDblAddButton_Click(object sender, EventArgs e)
        {
            RcdVal csRcdVal = new RcdVal();
            csRcdVal.m_lEditType = 0;
            csRcdVal.m_lDataType = 2;
            csRcdVal.m_lItemNo = InitDbldataGridView.RowCount;
            PrpIntRecodeForm csRcdInFrm = new PrpIntRecodeForm(csRcdVal, this);
            csRcdInFrm.ShowDialog();

        }

        private void InitDblDelButton_Click(object sender, EventArgs e)
        {
            int iClm = InitDbldataGridView.CurrentCell.RowIndex;
            InitDbldataGridView.Rows.RemoveAt(iClm);
            int iClmNum = InitDbldataGridView.RowCount;
            for (int iL = 0; iL < iClmNum; iL++)
            {
                InitDbldataGridView.Rows[iL].Cells[1].Value = "D" + iL.ToString();
            }
            InitDblNumTextBox.Text = iClmNum.ToString();
        }

        internal void AddRecord(RcdVal csRcdval)
        {
            if (csRcdval.m_lEditType == 1)
            {
                if (csRcdval.m_lDataType == 1)
                {
                    PrptyIntdataGridView.Rows.Add();
                    int iDispCnt = PrptyIntdataGridView.RowCount-1;
                    PrptyIntdataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                    PrptyIntdataGridView.Rows[iDispCnt].Cells[1].Value = "L"+ csRcdval.m_lItemNo.ToString();
                    PrptyIntdataGridView.Rows[iDispCnt].Cells[2].Value = csRcdval.m_sName;
                    PrptyIntdataGridView.Rows[iDispCnt].Cells[3].Value = csRcdval.m_sDfltVal;

                    PrptyIntNumTextBox.Text = PrptyIntdataGridView.RowCount.ToString();
                }
                else
                {
                    PrptyDbldataGridView.Rows.Add();
                    int iDispCnt = PrptyDbldataGridView.RowCount-1;
                    PrptyDbldataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                    PrptyDbldataGridView.Rows[iDispCnt].Cells[1].Value = "L" + csRcdval.m_lItemNo.ToString();
                    PrptyDbldataGridView.Rows[iDispCnt].Cells[2].Value = csRcdval.m_sName;
                    PrptyDbldataGridView.Rows[iDispCnt].Cells[3].Value = csRcdval.m_sDfltVal;

                    PrptyDblNumTextBox.Text = PrptyDbldataGridView.RowCount.ToString();
                }
            }
            else
            {
                if (csRcdval.m_lDataType == 1)
                {
                    InitIntdataGridView.Rows.Add();
                    int iDispCnt = InitIntdataGridView.RowCount-1;
                    InitIntdataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                    InitIntdataGridView.Rows[iDispCnt].Cells[1].Value = "L" + csRcdval.m_lItemNo.ToString();
                    InitIntdataGridView.Rows[iDispCnt].Cells[2].Value = csRcdval.m_sName;
                    InitIntdataGridView.Rows[iDispCnt].Cells[3].Value = csRcdval.m_sDfltVal;

                    InitIntNumTextBox.Text = InitIntdataGridView.RowCount.ToString();
                }
                else
                {
                    InitDbldataGridView.Rows.Add();
                    int iDispCnt = InitDbldataGridView.RowCount-1;
                    InitDbldataGridView.Rows[iDispCnt].Cells[0].Value = "Integr";
                    InitDbldataGridView.Rows[iDispCnt].Cells[1].Value = "L" + csRcdval.m_lItemNo.ToString();
                    InitDbldataGridView.Rows[iDispCnt].Cells[2].Value = csRcdval.m_sName;
                    InitDbldataGridView.Rows[iDispCnt].Cells[3].Value = csRcdval.m_sDfltVal;

                    InitDblNumTextBox.Text = InitDbldataGridView.RowCount.ToString();
                }
            }
        }


        private void AddRcvPtnButton_Click(object sender, EventArgs e)
        {
            McTranInfoPattern csTrnInfPtn = null;
            TranInfoPatternForm csForm = new TranInfoPatternForm(this,true,false, csTrnInfPtn);
            csForm.ShowDialog();
        }

        private void DelRcvPtnButton_Click(object sender, EventArgs e)
        {
            int iSlct = RcvListBox.SelectedIndex;
            if (iSlct >= 0 && iSlct < m_RcvPtnList.Count)
            {
                DialogResult result = MessageBox.Show("削除してもよろしいですか？", "削除確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                if (result == DialogResult.Yes)
                {
                    PtnData csPtnDt = m_RcvPtnList[iSlct];
                    m_RcvPtnList.Remove(csPtnDt);

                    RcvListBox.Items.Clear();
                    int iCnt = m_RcvPtnList.Count;
                    for (int iL = 0; iL < iCnt; iL++)
                    {
                        PtnData csData = m_RcvPtnList[iL];
                        csData.m_lIndex = iL;
                        csData.m_csTrnInfPtn.SetPatternID(new HySID(csData.m_lIndex.ToString()));
                        string sLvl = csData.m_lIndex.ToString() + "      " + csData.m_sPtnName;
                        RcvListBox.Items.Add(sLvl);
                    }
                }
            }
        }

        private void SetRcvPtnButton_Click(object sender, EventArgs e)
        {
            int iSlct = RcvListBox.SelectedIndex;
            if (iSlct >= 0 && iSlct < m_RcvPtnList.Count)
            {
                PtnData csPtnDt = m_RcvPtnList[iSlct];
                TranInfoPatternForm csForm = new TranInfoPatternForm(this,false, false, csPtnDt.m_csTrnInfPtn);
                csForm.ShowDialog();
            }
        }

        private void AddSndPtnButton_Click(object sender, EventArgs e)
        {
            McTranInfoPattern csTrnInfPtn = null;
            TranInfoPatternForm csForm = new TranInfoPatternForm(this,true, true, csTrnInfPtn);
            csForm.ShowDialog();
        }

        private void DelSndPtnButton_Click(object sender, EventArgs e)
        {
            int iSlct = SndListBox.SelectedIndex;
            if (iSlct >= 0 && iSlct < m_SndPtnList.Count)
            {
                DialogResult result = MessageBox.Show("削除してもよろしいですか？", "削除確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
                if (result == DialogResult.Yes)
                {
                    PtnData csPtnDt = m_SndPtnList[iSlct];
                    m_SndPtnList.Remove(csPtnDt);

                    SndListBox.Items.Clear();
                    int iCnt = m_SndPtnList.Count;
                    for (int iL = 0; iL < iCnt; iL++)
                    {
                        PtnData csData = m_SndPtnList[iL];
                        csData.m_lIndex = iL;
                        csData.m_csTrnInfPtn.SetPatternID(new HySID(csData.m_lIndex.ToString()));
                        string sLvl = csData.m_lIndex.ToString() + "      " + csData.m_sPtnName;
                        SndListBox.Items.Add(sLvl);
                    }
                }
            }
        }

        private void SetSndPtnButton_Click(object sender, EventArgs e)
        {
            int iSlct = SndListBox.SelectedIndex;
            if (iSlct >= 0 && iSlct < m_SndPtnList.Count)
            {
                PtnData csPtnDt = m_SndPtnList[iSlct];
                TranInfoPatternForm csForm = new TranInfoPatternForm(this,false, true, csPtnDt.m_csTrnInfPtn);
                csForm.ShowDialog();
            }
        }

        private void CloseButton_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("終了してもよろしいですか？", "終了確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2);
            if (result == DialogResult.Yes)
            {
                Application.Exit();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="bRcvSndPtnFlg"> // false : 受信パターン,  true : 送信パターン</param>
        /// <param name="csTrnInfPtn"></param>
        internal void AddSndRcvPtn(bool bNewDtFlg, bool bRcvSndPtnFlg, McTranInfoPattern csTrnInfPtn)
        {
            PtnData csPtnDt = new PtnData();
            csPtnDt.m_sPtnName = csTrnInfPtn.GetName().ToString();
            csPtnDt.m_csTrnInfPtn = csTrnInfPtn;

            if (bNewDtFlg == true)
            {
                if (bRcvSndPtnFlg == false)
                {   // 受信パターン
                    csPtnDt.m_lIndex = m_RcvPtnList.Count;
                    csPtnDt.m_csTrnInfPtn.SetPatternID( new HySID( csPtnDt.m_lIndex.ToString()));
                    m_RcvPtnList.Add(csPtnDt);
                    string sLvl = csPtnDt.m_lIndex.ToString() + "      " + csPtnDt.m_sPtnName;
                    RcvListBox.Items.Add(sLvl);
                }
                else
                {   // 送信パターン
                    csPtnDt.m_lIndex = m_SndPtnList.Count;
                    csPtnDt.m_csTrnInfPtn.SetPatternID(new HySID(csPtnDt.m_lIndex.ToString()));
                    m_SndPtnList.Add(csPtnDt);
                    string sLvl = csPtnDt.m_lIndex.ToString() + "      " + csPtnDt.m_sPtnName;
                    SndListBox.Items.Add(sLvl);
                }
            }
            else
            {
                int lDtIdx = Int32.Parse( csTrnInfPtn.GetPatternID().ToString() );
                if (bRcvSndPtnFlg == false)
                {   // 受信パターン
                    csPtnDt = m_RcvPtnList[lDtIdx];
                    csPtnDt.m_csTrnInfPtn = csTrnInfPtn;
                    csPtnDt.m_sPtnName = csTrnInfPtn.GetName().ToString();

                    RcvListBox.Items.Clear();
                    int iCnt = m_RcvPtnList.Count;
                    for (int iL = 0; iL < iCnt; iL++)
                    {
                        PtnData csData = m_RcvPtnList[iL];
                        csData.m_lIndex = iL;
                        csData.m_csTrnInfPtn.SetPatternID(new HySID(csData.m_lIndex.ToString()));
                        string sLvl = csData.m_lIndex.ToString() + "      " + csData.m_sPtnName;
                        RcvListBox.Items.Add(sLvl);
                    }

                }
                else
                {   // 送信パターン
                    csPtnDt = m_SndPtnList[lDtIdx];
                    csPtnDt.m_csTrnInfPtn = csTrnInfPtn;
                    csPtnDt.m_sPtnName = csTrnInfPtn.GetName().ToString();

                    SndListBox.Items.Clear();
                    int iCnt = m_SndPtnList.Count;
                    for (int iL = 0; iL < iCnt; iL++)
                    {
                        PtnData csData = m_SndPtnList[iL];
                        csData.m_lIndex = iL;
                        csData.m_csTrnInfPtn.SetPatternID(new HySID(csData.m_lIndex.ToString()));
                        string sLvl = csData.m_lIndex.ToString() + "      " + csData.m_sPtnName;
                        SndListBox.Items.Add(sLvl);
                    }
                }

            }
        }


        //-------------------------------------------------------------------------------
        // Debug 用
        private void kinematicSet1()
        {
            Mc32BitFortranModelInfo csObj = new Mc32BitFortranModelInfo();
            csObj = new Mc32BitFortranModelInfo();
            csObj.SetModelName(new HySString("ﾗｯﾊﾟｰ用ｻﾝﾌﾟﾙﾓﾃﾞﾙ;Fortran：KinematicWaveModel"));
            csObj.SetDLLName(new HySString("FortranSampleKinematicWave.dll"));
            //csObj.SetDLLID(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB);
            csObj.SetCategory(new HySObjectKind("CAL_SAMPLE_MODELS"));
            //csObj.SetModelKind(new HySObjectKind("KinematicWaveModelDll.dll")); // <-- ModelKind は　DLL命である事に注意
            csObj.SetModelVer(new HySString("1.0"));
            csObj.SetModelSummary(new HySString("ﾗｯﾊﾟｰ用ｻﾝﾌﾟﾙﾓﾃﾞﾙ"));
            csObj.SetCreatorInf(new HySString("CommonMP"));
            Mc32BitFortranModelPropertyInfo csPrptyInf = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("FortranSampleKinematicWave.dll")); // <-- ModelKind は　DLL名である事に注意
            //csPrptyInf.SetDLLName(new HySString("KinematicWaveModelDll.dll"));
            csPrptyInf.SetStepTime(48.0 * 3600.0 / 2400.0);
            csPrptyInf.AddInfoType(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, "未来予測型:True／現在状態計算型:False", McDefine.ValKind.BOOL);
            csPrptyInf.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, true);
            csPrptyInf.SetLongParaNum(1);
            csPrptyInf.SetLongPara(0, 51, "モデル内セル分割数+1");
            //csPrptyInf.SetDoubleParaNum(3);
            csPrptyInf.SetDoubleParaNum(4);
            csPrptyInf.SetDoublePara(0, 0.03, "粗度");
            csPrptyInf.SetDoublePara(1, 200.0, "川幅[m]");
            csPrptyInf.SetDoublePara(2, 100.0 * 1000.0, "川長[m]");
            csPrptyInf.SetDoublePara(3, 1.0 / 2000.0, "河床勾配");

            {
                // 受信第１パターン
                short sPrnNo = 0;
                McTranInfoPattern csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.SINGLE_CELL_SERIAL,
                    "上流端流入") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    //csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                csPrptyInf.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            }
            {
                // 第１パターン
                short sPrnNo = 0;
                McTranInfoPattern csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.SINGLE_CELL_SERIAL,
                    "下流端出力") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                        csCellChara.SetDataKind(1, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csPrptyInf.AddSendPattern(csTrnPtn);
                // 送信第２パターン
                sPrnNo += 1;
                csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.D1_CELL_SERIAL,
                    "断面出力") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                        csCellChara.SetDataKind(1, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csPrptyInf.AddSendPattern(csTrnPtn);
            }
            csObj.SetModelProperty(csPrptyInf);

            Mc32BitFortranModelInitialData csInitInf = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("FortranSampleKinematicWave.dll")); // <-- ModelKind は　DLL命である事に注意
            csInitInf.SetDoubleParaNum(3);
            csInitInf.SetDoublePara(0, 1.0, "初期水位");
            csInitInf.SetDoublePara(1, 0.1, "初期流量");
            csInitInf.SetDoublePara(2, 0.1, "初期流速");

            csObj.SetModelInitialInfo(csInitInf);

            //------------------
            m_csMdlProperty = csPrptyInf;
            m_csMdlInitial = csInitInf;
            m_csFortranModelInfo = csObj;
        }
        // Debug 用
        private void dmnamicSet1()
        {
            Mc32BitFortranModelInfo csObj = new Mc32BitFortranModelInfo();
            csObj = new Mc32BitFortranModelInfo();
            csObj.SetModelName(new HySString("ﾗｯﾊﾟｰ用ｻﾝﾌﾟﾙﾓﾃﾞﾙ;Fortran：DynamicWaveModel"));
            csObj.SetDLLName(new HySString("FortranSampleDynamicWave.dll"));
            //csObj.SetDLLID(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB);
            csObj.SetCategory(new HySObjectKind("CAL_SAMPLE_MODELS"));
            //csObj.SetModelKind(new HySObjectKind("KinematicWaveModelDll.dll")); // <-- ModelKind は　DLL命である事に注意
            csObj.SetModelVer(new HySString("1.0"));
            csObj.SetModelSummary(new HySString("ﾗｯﾊﾟｰ用ｻﾝﾌﾟﾙﾓﾃﾞﾙ"));
            csObj.SetCreatorInf(new HySString("CommonMP"));
            Mc32BitFortranModelPropertyInfo csPrptyInf = new Mc32BitFortranModelPropertyInfo(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("FortranSampleKinematicWave.dll")); // <-- ModelKind は　DLL名である事に注意
            //csPrptyInf.SetDLLName(new HySString("KinematicWaveModelDll.dll"));
            csPrptyInf.SetStepTime(48.0 * 3600.0 / 2400.0);
            csPrptyInf.AddInfoType(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, "未来予測型:True／現在状態計算型:False", McDefine.ValKind.BOOL);
            csPrptyInf.SetInfo(Mc32BitFortranModelPropertyInfo.KEY_FORECAST_FLG, true);
            csPrptyInf.SetLongParaNum(1);
            csPrptyInf.SetLongPara(0, 50, "モデル内セル分割数");
            //csPrptyInf.SetDoubleParaNum(3);
            csPrptyInf.SetDoubleParaNum(4);
            csPrptyInf.SetDoublePara(0, 0.03, "粗度");
            csPrptyInf.SetDoublePara(1, 200.0, "川幅[m]");
            csPrptyInf.SetDoublePara(2, 100.0 * 1000.0, "川長[m]");
            csPrptyInf.SetDoublePara(3, 1.0 / 2000.0, "河床勾配");

            {
                // 受信第１パターン
                short sPrnNo = 0;
                McTranInfoPattern csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.SINGLE_CELL_SERIAL,
                    "上流端流入") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                    {
                        csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    //csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                }
                csPrptyInf.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            }
            {
                // 第１パターン
                short sPrnNo = 0;
                McTranInfoPattern csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.SINGLE_CELL_SERIAL,
                    "下流端出力") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                        csCellChara.SetDataKind(1, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csPrptyInf.AddSendPattern(csTrnPtn);
                // 送信第２パターン
                sPrnNo += 1;
                csTrnPtn = csPrptyInf.CreateTranInforPattern(
                    new HySID(sPrnNo.ToString()), //  <-- ここは必ず数字が入る事
                    McTranInfoDefine.D1_CELL_SERIAL,
                    "断面出力") as McTranInfoPattern;
                {
                    // セル内変数設定
                    HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                    {
                        csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                        csCellChara.SetDataKind(1, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                    }
                    csTrnPtn.SetCellDataCharacteristic(csCellChara);
                }
                csPrptyInf.AddSendPattern(csTrnPtn);
            }
            csObj.SetModelProperty(csPrptyInf);

            Mc32BitFortranModelInitialData csInitInf = new Mc32BitFortranModelInitialData(Mc32BitFortranWrapperDef.FORTRAN_WRAPPER_MODEL_LIB, new HySObjectKind("FortranSampleKinematicWave.dll")); // <-- ModelKind は　DLL命である事に注意
            csInitInf.SetDoubleParaNum(3);
            csInitInf.SetDoublePara(0, 1.0, "初期水位");
            csInitInf.SetDoublePara(1, 0.1, "初期流量");
            csInitInf.SetDoublePara(2, 0.1, "初期流速");

            csObj.SetModelInitialInfo(csInitInf);

            //------------------
            m_csMdlProperty = csPrptyInf;
            m_csMdlInitial = csInitInf;
            m_csFortranModelInfo = csObj;
        }

    }
}
