﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FortranInfoEditor
{
    public partial class PrpIntRecodeForm : Form
    {
        internal RcdVal m_csRcdval = null;
        
        FortranInfoEditForm m_csPrntForm = null;

        internal PrpIntRecodeForm(RcdVal csRcdval, FortranInfoEditForm csPrntForm)
        {
            m_csRcdval = csRcdval;

            InitializeComponent();

            if (m_csRcdval.m_lDataType == 1)
            {
                TypeTextBox.Text = "Integer";
                ItemTextBox.Text = "L" + m_csRcdval.m_lItemNo.ToString();
            }
            else
            {
                TypeTextBox.Text = "Real(8)";
                ItemTextBox.Text = "D" + m_csRcdval.m_lItemNo.ToString();
            }
            NameTextBox.Text = m_csRcdval.m_sName;
            DefaultValTextBox.Text = m_csRcdval.m_sDfltVal;
            m_csPrntForm = csPrntForm;
        }

 
        private void DefaultValTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csRcdval.m_sDfltVal = DefaultValTextBox.Text;
        }

        private void NameTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csRcdval.m_sName = NameTextBox.Text;
        }

        private void OKButton_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            m_csPrntForm.AddRecord(m_csRcdval);

            this.Close();
        }

        private void CancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
